/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SurroundWithArrayFix
extends PsiElementBaseIntentionAction {
    private final PsiCall myMethodCall;
    @Nullable
    private final PsiExpression myExpression;

    public SurroundWithArrayFix(@Nullable PsiCall methodCall, @Nullable PsiExpression expression2) {
        this.myMethodCall = methodCall;
        this.myExpression = expression2;
    }

    @NotNull
    public String getText() {
        return "Surround with array initialization";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        return this.getExpression(element) != null;
    }

    @Nullable
    protected PsiExpression getExpression(PsiElement element) {
        if (this.myMethodCall == null || !this.myMethodCall.isValid()) {
            return this.myExpression == null || !this.myExpression.isValid() ? null : this.myExpression;
        }
        PsiMethod method = this.myMethodCall.resolveMethod();
        if (method != null) {
            return this.checkMethod(element, method);
        }
        if (this.myMethodCall instanceof PsiMethodCallExpression) {
            Collection psiElements = TargetElementUtil.getInstance().getTargetCandidates((PsiReference)((PsiMethodCallExpression)this.myMethodCall).getMethodExpression());
            for (PsiElement psiElement : psiElements) {
                PsiExpression expression2;
                if (!(psiElement instanceof PsiMethod) || (expression2 = this.checkMethod(element, (PsiMethod)psiElement)) == null) continue;
                return expression2;
            }
        }
        return null;
    }

    @Nullable
    private PsiExpression checkMethod(PsiElement element, PsiMethod psiMethod) {
        PsiParameter[] psiParameters = psiMethod.getParameterList().getParameters();
        PsiExpressionList argumentList = this.myMethodCall.getArgumentList();
        int idx = 0;
        for (PsiExpression expression2 : argumentList.getExpressions()) {
            PsiType expressionType;
            PsiType paramType;
            if (element != null && PsiTreeUtil.isAncestor((PsiElement)expression2, (PsiElement)element, (boolean)false) && psiParameters.length > idx && (paramType = psiParameters[idx].getType()) instanceof PsiArrayType && (expressionType = TypeConversionUtil.erasure((PsiType)expression2.getType())) != null && PsiTypesUtil.isDenotableType((PsiType)expressionType, (PsiElement)element) && expressionType != PsiType.NULL) {
                PsiType componentType = ((PsiArrayType)paramType).getComponentType();
                if (TypeConversionUtil.isAssignable((PsiType)componentType, (PsiType)expressionType)) {
                    return expression2;
                }
                PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)componentType);
                if (ArrayUtilRt.find((Object[])psiMethod.getTypeParameters(), (Object)psiClass) != -1) {
                    for (PsiClassType superType : psiClass.getSuperTypes()) {
                        if (!TypeConversionUtil.isAssignable((PsiType)superType, (PsiType)expressionType)) continue;
                        return expression2;
                    }
                }
            }
            ++idx;
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        PsiExpression expression2 = this.getExpression(element);
        assert (expression2 != null);
        PsiExpression toReplace = elementFactory.createExpressionFromText(SurroundWithArrayFix.getArrayCreation(expression2), element);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(expression2.replace((PsiElement)toReplace));
    }

    @NonNls
    private static String getArrayCreation(@NotNull PsiExpression expression2) {
        PsiType expressionType = expression2.getType();
        assert (expressionType != null);
        PsiType arrayComponentType = TypeConversionUtil.erasure((PsiType)expressionType);
        return "new " + arrayComponentType.getCanonicalText() + "[]{" + expression2.getText() + "}";
    }
}

