/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.generation.surroundWith.JavaWithTryCatchSurrounder;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public class SurroundWithTryCatchFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.SurroundWithTryCatchFix");
    private PsiElement myElement;

    public SurroundWithTryCatchFix(@NotNull PsiElement element) {
        if (element instanceof PsiStatement || element instanceof PsiResourceVariable || element instanceof PsiExpression && !(element instanceof PsiMethodReferenceExpression) && ControlFlowUtils.canExtractStatement(ExpressionUtils.getTopLevelExpression((PsiExpression)element))) {
            this.myElement = element;
        }
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("surround.with.try.catch.fix", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("surround.with.try.catch.fix", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (this.myElement != null && this.myElement.isValid()) {
            PsiElement parentStatement = RefactoringUtil.getParentStatement(this.myElement, false);
            return !(parentStatement instanceof PsiDeclarationStatement) || !(((PsiDeclarationStatement)parentStatement).getDeclaredElements()[0] instanceof PsiClass);
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        int col = editor.getCaretModel().getLogicalPosition().column;
        int line = editor.getCaretModel().getLogicalPosition().line;
        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(0, 0));
        if (this.myElement instanceof PsiExpression) {
            this.myElement = RefactoringUtil.ensureCodeBlock(ExpressionUtils.getTopLevelExpression((PsiExpression)this.myElement));
        }
        this.myElement = RefactoringUtil.getParentStatement(this.myElement, false);
        if (this.myElement == null) {
            return;
        }
        TextRange range = null;
        try {
            JavaWithTryCatchSurrounder handler = new JavaWithTryCatchSurrounder();
            range = handler.surroundElements(project, editor, new PsiElement[]{this.myElement});
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        LogicalPosition pos = new LogicalPosition(line, col);
        editor.getCaretModel().moveToLogicalPosition(pos);
        if (range != null) {
            int offset = range.getStartOffset();
            editor.getCaretModel().moveToOffset(offset);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

