/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.dataFlow.fix.DeleteSwitchLabelFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.controlflow.SwitchStatementWithTooFewBranchesInspection;
import com.siyeh.ig.psiutils.BreakConverter;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UnwrapSwitchLabelFix
implements LocalQuickFix {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return "Remove unreachable branches";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiExpression label = (PsiExpression)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PsiExpression.class);
        if (label == null) {
            return;
        }
        PsiSwitchLabelStatementBase labelStatement = PsiImplUtil.getSwitchLabel(label);
        if (labelStatement == null) {
            return;
        }
        PsiSwitchBlock block = labelStatement.getEnclosingSwitchBlock();
        if (block == null) {
            return;
        }
        List labels2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)block.getBody(), PsiSwitchLabelStatementBase.class);
        boolean shouldKeepDefault = block instanceof PsiSwitchExpression && (!(labelStatement instanceof PsiSwitchLabeledRuleStatement) || !(((PsiSwitchLabeledRuleStatement)labelStatement).getBody() instanceof PsiExpressionStatement));
        for (PsiSwitchLabelStatementBase otherLabel : labels2) {
            if (otherLabel == labelStatement || shouldKeepDefault && otherLabel.isDefaultCase()) continue;
            DeleteSwitchLabelFix.deleteLabel(otherLabel);
        }
        for (PsiExpression expression2 : Objects.requireNonNull(labelStatement.getCaseValues()).getExpressions()) {
            if (expression2 == label) continue;
            new CommentTracker().deleteAndRestoreComments((PsiElement)expression2);
        }
        this.tryUnwrap(labelStatement, block);
    }

    public void tryUnwrap(PsiSwitchLabelStatementBase labelStatement, PsiSwitchBlock block) {
        if (block instanceof PsiSwitchStatement) {
            BreakConverter converter = BreakConverter.from(block);
            if (converter == null) {
                return;
            }
            converter.process();
            UnwrapSwitchLabelFix.unwrapStatement(labelStatement, (PsiSwitchStatement)block);
        } else {
            SwitchStatementWithTooFewBranchesInspection.UnwrapSwitchStatementFix.unwrapExpression((PsiSwitchExpression)block);
        }
    }

    private static void unwrapStatement(PsiSwitchLabelStatementBase labelStatement, PsiSwitchStatement statement) {
        PsiStatement body2;
        PsiCodeBlock block = statement.getBody();
        PsiStatement psiStatement = body2 = labelStatement instanceof PsiSwitchLabeledRuleStatement ? ((PsiSwitchLabeledRuleStatement)labelStatement).getBody() : null;
        if (body2 == null) {
            new CommentTracker().deleteAndRestoreComments((PsiElement)labelStatement);
        } else if (body2 instanceof PsiBlockStatement) {
            block = ((PsiBlockStatement)body2).getCodeBlock();
        } else {
            new CommentTracker().replaceAndRestoreComments((PsiElement)labelStatement, (PsiElement)body2);
        }
        PsiCodeBlock parent = (PsiCodeBlock)ObjectUtils.tryCast((Object)statement.getParent(), PsiCodeBlock.class);
        CommentTracker ct = new CommentTracker();
        if (parent != null && !BlockUtils.containsConflictingDeclarations(Objects.requireNonNull(block), parent)) {
            ct.grabComments((PsiElement)statement);
            ct.markUnchanged(block);
            ct.insertCommentsBefore((PsiElement)statement);
            BlockUtils.inlineCodeBlock((PsiStatement)statement, block);
        } else if (block != null) {
            ct.replaceAndRestoreComments((PsiElement)statement, ct.text((PsiElement)block));
        } else {
            ct.deleteAndRestoreComments((PsiElement)statement);
        }
    }
}

