/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureDialog;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableTypeFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.VariableTypeFix");
    private final PsiType myReturnType;
    protected final String myName;

    public VariableTypeFix(@NotNull PsiVariable variable, PsiType toReturn) {
        super((PsiElement)variable);
        this.myReturnType = GenericsUtil.getVariableTypeByExpressionType((PsiType)toReturn);
        this.myName = variable.getName();
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("fix.variable.type.text", UsageViewUtil.getType((PsiElement)this.getStartElement()), this.myName, this.getReturnType().getCanonicalText());
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("fix.variable.type.family", new Object[0]);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiVariable myVariable = (PsiVariable)startElement;
        return myVariable.getTypeElement() != null && BaseIntentionAction.canModify((PsiElement)myVariable) && this.getReturnType() != null && !LambdaUtil.notInferredType((PsiType)this.getReturnType()) && this.getReturnType().isValid() && !TypeConversionUtil.isNullType((PsiType)this.getReturnType()) && !TypeConversionUtil.isVoidType((PsiType)this.getReturnType());
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiVariable myVariable = (PsiVariable)startElement;
        if (this.changeMethodSignatureIfNeeded(myVariable)) {
            return;
        }
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{file}).withName(this.getText()).run(() -> {
            try {
                myVariable.normalizeDeclaration();
                PsiTypeElement typeElement = myVariable.getTypeElement();
                LOG.assertTrue(typeElement != null, myVariable.getClass());
                PsiTypeElement newTypeElement = JavaPsiFacade.getElementFactory((Project)file.getProject()).createTypeElement(this.getReturnType());
                typeElement.replace((PsiElement)newTypeElement);
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)myVariable);
                UndoUtil.markPsiFileForUndo((PsiFile)file);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        });
    }

    private boolean changeMethodSignatureIfNeeded(PsiVariable myVariable) {
        PsiElement scope;
        if (myVariable instanceof PsiParameter && (scope = ((PsiParameter)myVariable).getDeclarationScope()) instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)scope;
            PsiMethod psiMethod = SuperMethodWarningUtil.checkSuperMethod(method, RefactoringBundle.message((String)"to.refactor"));
            if (psiMethod == null) {
                return true;
            }
            int parameterIndex = method.getParameterList().getParameterIndex((PsiParameter)myVariable);
            if (!FileModificationService.getInstance().prepareFileForWrite(psiMethod.getContainingFile())) {
                return true;
            }
            ArrayList<ParameterInfoImpl> infos = new ArrayList<ParameterInfoImpl>();
            int i = 0;
            for (PsiParameter parameter2 : psiMethod.getParameterList().getParameters()) {
                boolean changeType = i == parameterIndex;
                infos.add(new ParameterInfoImpl(i++, parameter2.getName(), changeType ? this.getReturnType() : parameter2.getType()));
            }
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                JavaChangeSignatureDialog dialog = new JavaChangeSignatureDialog(psiMethod.getProject(), psiMethod, false, (PsiElement)myVariable);
                dialog.setParameterInfos(infos);
                dialog.show();
            } else {
                ChangeSignatureProcessor processor = new ChangeSignatureProcessor(psiMethod.getProject(), psiMethod, false, null, psiMethod.getName(), psiMethod.getReturnType(), infos.toArray(new ParameterInfoImpl[0]));
                processor.run();
            }
            return true;
        }
        return false;
    }

    protected PsiType getReturnType() {
        return this.myReturnType;
    }
}

