/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightFixUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationProcessor;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class VariableTypeFromCallFix
implements IntentionAction {
    private final PsiType myExpressionType;
    private final PsiVariable myVar;

    private VariableTypeFromCallFix(@NotNull PsiType type2, @NotNull PsiVariable var) {
        this.myExpressionType = type2;
        this.myVar = var;
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("fix.variable.type.text", UsageViewUtil.getType((PsiElement)this.myVar), this.myVar.getName(), this.myExpressionType.getCanonicalText());
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("fix.variable.type.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return this.myExpressionType.isValid() && this.myVar.isValid();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        TypeMigrationRules rules = new TypeMigrationRules(project);
        rules.setBoundScope(PsiSearchHelper.getInstance((Project)project).getUseScope((PsiElement)this.myVar));
        TypeMigrationProcessor.runHighlightingTypeMigration(project, editor, rules, (PsiElement)this.myVar, this.myExpressionType);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public static List<IntentionAction> getQuickFixActions(@NotNull PsiMethodCallExpression methodCall, @NotNull PsiExpressionList list) {
        JavaResolveResult result = methodCall.getMethodExpression().advancedResolve(false);
        PsiMethod method = (PsiMethod)result.getElement();
        PsiSubstitutor substitutor = result.getSubstitutor();
        PsiExpression[] expressions2 = list.getExpressions();
        if (method == null) {
            return Collections.emptyList();
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (parameters2.length != expressions2.length) {
            return Collections.emptyList();
        }
        ArrayList<IntentionAction> actions = new ArrayList<IntentionAction>();
        for (int i = 0; i < expressions2.length; ++i) {
            PsiElement resolved;
            PsiParameter parameter2;
            PsiType formalParamType;
            PsiType parameterType;
            PsiExpression expression2 = expressions2[i];
            PsiType expressionType = expression2.getType();
            if (expressionType instanceof PsiPrimitiveType) {
                expressionType = ((PsiPrimitiveType)expressionType).getBoxedType((PsiElement)expression2);
            }
            if (expressionType == null || (parameterType = substitutor.substitute(formalParamType = (parameter2 = parameters2[i]).getType())).isAssignableFrom(expressionType)) continue;
            PsiExpression qualifierExpression2 = methodCall.getMethodExpression().getQualifierExpression();
            if (qualifierExpression2 instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)qualifierExpression2).resolve()) instanceof PsiVariable) {
                PsiType varType = ((PsiVariable)resolved).getType();
                PsiClass varClass = PsiUtil.resolveClassInType((PsiType)varType);
                Project project = expression2.getProject();
                PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)project).getResolveHelper();
                if (varClass != null) {
                    PsiSubstitutor psiSubstitutor = resolveHelper.inferTypeArguments(varClass.getTypeParameters(), parameters2, expressions2, PsiSubstitutor.EMPTY, resolved, (ParameterTypeInferencePolicy)DefaultParameterTypeInferencePolicy.INSTANCE);
                    PsiType appropriateVarType = GenericsUtil.getVariableTypeByExpressionType((PsiType)JavaPsiFacade.getElementFactory((Project)project).createType(varClass, psiSubstitutor));
                    if (!varType.equals(appropriateVarType)) {
                        actions.add(new VariableTypeFromCallFix(appropriateVarType, (PsiVariable)resolved));
                        break;
                    }
                }
            }
            actions.addAll(VariableTypeFromCallFix.getParameterTypeChangeFixes(method, expression2, parameterType));
        }
        return actions;
    }

    private static List<IntentionAction> getParameterTypeChangeFixes(@NotNull PsiMethod method, @NotNull PsiExpression expression2, PsiType parameterType) {
        if (!(expression2 instanceof PsiReferenceExpression)) {
            return Collections.emptyList();
        }
        ArrayList<IntentionAction> result = new ArrayList<IntentionAction>();
        if (BaseIntentionAction.canModify((PsiElement)method)) {
            PsiType varType;
            PsiMethod[] superMethods;
            for (PsiMethod superMethod : superMethods = method.findDeepestSuperMethods()) {
                if (BaseIntentionAction.canModify((PsiElement)superMethod)) continue;
                return Collections.emptyList();
            }
            PsiElement resolve = ((PsiReferenceExpression)expression2).resolve();
            if (resolve instanceof PsiVariable && !(varType = ((PsiVariable)resolve).getType()).equals(GenericsUtil.getVariableTypeByExpressionType((PsiType)parameterType))) {
                result.addAll(HighlightFixUtil.getChangeVariableTypeFixes((PsiVariable)resolve, parameterType));
            }
        }
        return result;
    }
}

