/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrapExpressionFix
implements IntentionAction {
    private final PsiExpression myExpression;
    private final PsiClassType myExpectedType;
    private final boolean myPrimitiveExpected;

    public WrapExpressionFix(@NotNull PsiType expectedType, @NotNull PsiExpression expression2) {
        this.myExpression = expression2;
        this.myExpectedType = WrapExpressionFix.getClassType(expectedType, (PsiElement)expression2);
        this.myPrimitiveExpected = expectedType instanceof PsiPrimitiveType;
    }

    @Nullable
    private static PsiClassType getClassType(PsiType type2, PsiElement place) {
        if (type2 instanceof PsiClassType) {
            return (PsiClassType)type2;
        }
        if (type2 instanceof PsiPrimitiveType) {
            return ((PsiPrimitiveType)type2).getBoxedType(place.getManager(), GlobalSearchScope.allScope((Project)place.getProject()));
        }
        return null;
    }

    @NotNull
    public String getText() {
        PsiType type2 = this.myExpression.getType();
        PsiMethod wrapper = this.myExpression.isValid() && this.myExpectedType != null && type2 != null ? WrapExpressionFix.findWrapper(type2, this.myExpectedType, this.myPrimitiveExpected) : null;
        String methodPresentation = wrapper != null ? wrapper.getContainingClass().getName() + "." + wrapper.getName() : "";
        return QuickFixBundle.message("wrap.expression.using.static.accessor.text", methodPresentation);
    }

    @Nullable
    private static PsiMethod findWrapper(@NotNull PsiType type2, @NotNull PsiClassType expectedType, boolean primitiveExpected) {
        PsiClass aClass = expectedType.resolve();
        if (aClass != null) {
            PsiClassType expectedReturnType = expectedType;
            if (primitiveExpected) {
                expectedReturnType = PsiPrimitiveType.getUnboxedType((PsiType)expectedType);
            }
            if (expectedReturnType == null) {
                return null;
            }
            PsiMethod[] methods = aClass.getMethods();
            LinkedHashSet<PsiMethod> wrapperMethods = new LinkedHashSet<PsiMethod>();
            for (PsiMethod method : methods) {
                if (!method.hasModifierProperty("static") || method.getParameterList().getParametersCount() != 1 || !method.getParameterList().getParameters()[0].getType().isAssignableFrom(type2) || method.getReturnType() == null || !expectedReturnType.equals(method.getReturnType())) continue;
                String methodName = method.getName();
                if (methodName.startsWith("parse") || methodName.equals("valueOf")) {
                    return method;
                }
                wrapperMethods.add(method);
            }
            if (!wrapperMethods.isEmpty()) {
                return (PsiMethod)wrapperMethods.iterator().next();
            }
        }
        return null;
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("wrap.expression.using.static.accessor.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return this.myExpression.isValid() && BaseIntentionAction.canModify((PsiElement)this.myExpression) && PsiImplUtil.getSwitchLabel(this.myExpression) == null && this.myExpectedType != null && this.myExpectedType.isValid() && this.myExpression.getType() != null && WrapExpressionFix.findWrapper(this.myExpression.getType(), this.myExpectedType, this.myPrimitiveExpected) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiType type2 = this.myExpression.getType();
        assert (type2 != null);
        PsiMethod wrapper = WrapExpressionFix.findWrapper(type2, this.myExpectedType, this.myPrimitiveExpected);
        assert (wrapper != null);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)file.getProject());
        String methodCallText = "Foo." + wrapper.getName() + "()";
        PsiMethodCallExpression call = (PsiMethodCallExpression)factory.createExpressionFromText(methodCallText, null);
        call.getArgumentList().add((PsiElement)this.myExpression);
        ((PsiReferenceExpression)call.getMethodExpression().getQualifierExpression()).bindToElement((PsiElement)wrapper.getContainingClass());
        this.myExpression.replace((PsiElement)call);
    }

    public boolean startInWriteAction() {
        return true;
    }

    public static void registerWrapAction(JavaResolveResult[] candidates, PsiExpression[] expressions2, HighlightInfo highlightInfo) {
        PsiType expectedType = null;
        PsiExpression expr = null;
        block0: for (int i = 0; i < candidates.length && expectedType == null; ++i) {
            JavaResolveResult candidate = candidates[i];
            PsiSubstitutor substitutor = candidate.getSubstitutor();
            PsiElement element = candidate.getElement();
            assert (element != null);
            PsiMethod method = (PsiMethod)element;
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            if (!method.isVarArgs() && parameters2.length != expressions2.length) continue;
            for (int j = 0; j < expressions2.length; ++j) {
                PsiExpression expression2 = expressions2[j];
                PsiType exprType = expression2.getType();
                if (exprType == null || PsiType.NULL.equals((Object)exprType)) continue;
                PsiType paramType = parameters2[Math.min(j, parameters2.length - 1)].getType();
                if (paramType instanceof PsiEllipsisType) {
                    paramType = ((PsiEllipsisType)paramType).getComponentType();
                }
                if ((paramType = substitutor.substitute(paramType)).isAssignableFrom(exprType)) continue;
                PsiClassType classType = WrapExpressionFix.getClassType(paramType, (PsiElement)expression2);
                if (expectedType == null && classType != null && WrapExpressionFix.findWrapper(exprType, classType, paramType instanceof PsiPrimitiveType) != null) {
                    expectedType = paramType;
                    expr = expression2;
                    continue;
                }
                expectedType = null;
                expr = null;
                continue block0;
            }
        }
        if (expectedType != null) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)expr.getTextRange(), (IntentionAction)new WrapExpressionFix(expectedType, expr));
        }
    }
}

