/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.editorActions.JoinLinesHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChainCallJoinLinesHandler
implements JoinLinesHandlerDelegate {
    public int tryJoinLines(@NotNull Document document, @NotNull PsiFile psiFile, int start, int end) {
        PsiJavaToken elementAtStartLineEnd = (PsiJavaToken)ObjectUtils.tryCast((Object)psiFile.findElementAt(start), PsiJavaToken.class);
        if (elementAtStartLineEnd == null || !elementAtStartLineEnd.getTokenType().equals(JavaTokenType.SEMICOLON)) {
            return -1;
        }
        PsiExpressionStatement secondStatement = (PsiExpressionStatement)PsiTreeUtil.getParentOfType((PsiElement)psiFile.findElementAt(end), PsiExpressionStatement.class);
        if (secondStatement == null) {
            return -1;
        }
        PsiMethodCallExpression secondCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)secondStatement.getExpression(), PsiMethodCallExpression.class);
        if (secondCall == null) {
            return -1;
        }
        PsiElement firstStatement = elementAtStartLineEnd.getParent();
        boolean result = false;
        if (firstStatement instanceof PsiExpressionStatement) {
            if (firstStatement.getParent() != secondStatement.getParent()) {
                return -1;
            }
            PsiExpression firstExpression = ((PsiExpressionStatement)firstStatement).getExpression();
            if (firstExpression instanceof PsiMethodCallExpression) {
                result = ChainCallJoinLinesHandler.joinTwoCalls((PsiMethodCallExpression)firstExpression, secondCall);
            } else if (firstExpression instanceof PsiAssignmentExpression) {
                result = ChainCallJoinLinesHandler.joinAssignmentAndCall((PsiAssignmentExpression)firstExpression, secondCall);
            }
        } else if (firstStatement instanceof PsiLocalVariable) {
            PsiLocalVariable var = (PsiLocalVariable)firstStatement;
            result = ChainCallJoinLinesHandler.joinExpressionAndCall(var, var.getInitializer(), secondCall);
        }
        if (!result) {
            return -1;
        }
        secondStatement.delete();
        return firstStatement.getTextRange().getEndOffset();
    }

    private static boolean joinAssignmentAndCall(PsiAssignmentExpression assignmentExpression, PsiMethodCallExpression nextCall) {
        if (!assignmentExpression.getOperationTokenType().equals(JavaTokenType.EQ)) {
            return false;
        }
        PsiLocalVariable var = ExpressionUtils.resolveLocalVariable(assignmentExpression.getLExpression());
        if (var == null) {
            return false;
        }
        return ChainCallJoinLinesHandler.joinExpressionAndCall(var, assignmentExpression.getRExpression(), nextCall);
    }

    private static boolean joinExpressionAndCall(PsiLocalVariable var, PsiExpression initializer, PsiMethodCallExpression nextCall) {
        if (initializer == null) {
            return false;
        }
        PsiExpression qualifier = ChainCallJoinLinesHandler.getDeepQualifier(nextCall);
        if (!ExpressionUtils.isReferenceTo(qualifier, (PsiVariable)var)) {
            return false;
        }
        PsiType type2 = nextCall.getType();
        if (type2 == null || !type2.equals(initializer.getType())) {
            return false;
        }
        if (ReferencesSearch.search((PsiElement)var, (SearchScope)new LocalSearchScope((PsiElement)nextCall)).findAll().size() > 1) {
            return false;
        }
        qualifier.replace((PsiElement)initializer);
        initializer.replace((PsiElement)nextCall);
        return true;
    }

    private static boolean joinTwoCalls(PsiMethodCallExpression firstCall, @NotNull PsiMethodCallExpression secondCall) {
        if (firstCall == null) {
            return false;
        }
        PsiExpression firstQualifier = ChainCallJoinLinesHandler.getDeepQualifier(firstCall);
        if (firstQualifier == null) {
            return false;
        }
        PsiExpression secondQualifier = ChainCallJoinLinesHandler.getDeepQualifier(secondCall);
        if (secondQualifier == null) {
            return false;
        }
        if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)firstQualifier, (PsiElement)secondQualifier)) {
            return false;
        }
        PsiType type2 = firstCall.getType();
        if (type2 == null || !firstCall.getType().equals(firstQualifier.getType())) {
            return false;
        }
        secondQualifier.replace((PsiElement)firstCall);
        firstCall.replace((PsiElement)secondCall);
        return true;
    }

    @Nullable
    static PsiExpression getDeepQualifier(PsiMethodCallExpression firstCall) {
        PsiMethodCallExpression firstQualifier = firstCall;
        while (firstQualifier instanceof PsiMethodCallExpression) {
            firstQualifier = firstQualifier.getMethodExpression().getQualifierExpression();
        }
        return firstQualifier;
    }
}

