/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.JoinLinesHandlerDelegate;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiPrecedenceUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeclarationJoinLinesHandler
implements JoinLinesHandlerDelegate {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.DeclarationJoinLinesHandler");

    public int tryJoinLines(@NotNull Document document, @NotNull PsiFile file, int start, int end) {
        PsiElement elementAtStartLineEnd = file.findElementAt(start);
        PsiElement elementAtNextLineStart = file.findElementAt(end);
        if (elementAtStartLineEnd == null || elementAtNextLineStart == null) {
            return -1;
        }
        if (!(elementAtStartLineEnd instanceof PsiJavaToken)) {
            return -1;
        }
        PsiJavaToken lastFirstLineToken = (PsiJavaToken)elementAtStartLineEnd;
        if (lastFirstLineToken.getTokenType() != JavaTokenType.SEMICOLON) {
            return -1;
        }
        if (!(lastFirstLineToken.getParent() instanceof PsiLocalVariable)) {
            return -1;
        }
        PsiLocalVariable var = (PsiLocalVariable)lastFirstLineToken.getParent();
        if (!(var.getParent() instanceof PsiDeclarationStatement)) {
            return -1;
        }
        PsiDeclarationStatement decl = (PsiDeclarationStatement)var.getParent();
        if (decl.getDeclaredElements().length > 1) {
            return -1;
        }
        if (!(elementAtNextLineStart instanceof PsiJavaToken)) {
            return -1;
        }
        PsiJavaToken firstNextLineToken = (PsiJavaToken)elementAtNextLineStart;
        if (firstNextLineToken.getTokenType() != JavaTokenType.IDENTIFIER) {
            return -1;
        }
        if (!(firstNextLineToken.getParent() instanceof PsiReferenceExpression)) {
            return -1;
        }
        PsiReferenceExpression ref = (PsiReferenceExpression)firstNextLineToken.getParent();
        PsiElement refResolved = ref.resolve();
        PsiManager psiManager = ref.getManager();
        if (!psiManager.areElementsEquivalent(refResolved, (PsiElement)var)) {
            return -1;
        }
        if (!(ref.getParent() instanceof PsiAssignmentExpression)) {
            return -1;
        }
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)ref.getParent();
        if (!(assignment.getParent() instanceof PsiExpressionStatement)) {
            return -1;
        }
        PsiExpression rExpression = assignment.getRExpression();
        if (rExpression == null) {
            return -1;
        }
        if (ReferencesSearch.search((PsiElement)var, (SearchScope)new LocalSearchScope((PsiElement)rExpression), (boolean)false).findFirst() != null) {
            return -1;
        }
        PsiExpression initializerExpression = DeclarationJoinLinesHandler.getInitializerExpression(var, assignment);
        if (initializerExpression == null) {
            return -1;
        }
        PsiExpressionStatement statement = (PsiExpressionStatement)assignment.getParent();
        int startOffset = decl.getTextRange().getStartOffset();
        try {
            PsiLocalVariable variable = DeclarationJoinLinesHandler.copyVarWithInitializer(var, initializerExpression);
            if (variable == null) {
                return -1;
            }
            PsiDeclarationStatement newDecl = (PsiDeclarationStatement)variable.getParent();
            int offsetBeforeEQ = Objects.requireNonNull(variable.getNameIdentifier()).getTextRange().getEndOffset();
            int offsetAfterEQ = Objects.requireNonNull(variable.getInitializer()).getTextRange().getStartOffset() + 1;
            newDecl = (PsiDeclarationStatement)CodeStyleManager.getInstance((PsiManager)psiManager).reformatRange((PsiElement)newDecl, offsetBeforeEQ, offsetAfterEQ);
            PsiElement child = statement.getLastChild();
            while (child instanceof PsiComment || child instanceof PsiWhiteSpace) {
                child = child.getPrevSibling();
            }
            if (child != null && child.getNextSibling() != null) {
                newDecl.addRangeBefore(child.getNextSibling(), statement.getLastChild(), null);
            }
            decl.replace((PsiElement)newDecl);
            statement.delete();
            return startOffset + newDecl.getTextRange().getEndOffset() - newDecl.getTextRange().getStartOffset();
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return -1;
        }
    }

    @Nullable
    public static PsiExpression getInitializerExpression(PsiLocalVariable var, PsiAssignmentExpression assignment) {
        return DeclarationJoinLinesHandler.getInitializerExpression(var.getInitializer(), assignment);
    }

    @Nullable
    public static PsiExpression getInitializerExpression(PsiExpression initializer, PsiAssignmentExpression assignment) {
        String initializerText;
        PsiJavaToken sign = assignment.getOperationSign();
        IElementType compoundOp = assignment.getOperationTokenType();
        PsiExpression rExpression = assignment.getRExpression();
        if (rExpression == null) {
            return null;
        }
        if (compoundOp == JavaTokenType.EQ) {
            return rExpression;
        }
        if (initializer == null) {
            return null;
        }
        String opSign = sign.getText().replace("=", "");
        IElementType simpleOp = TypeConversionUtil.convertEQtoOperation((IElementType)compoundOp);
        if (simpleOp == null) {
            return null;
        }
        Project project = assignment.getProject();
        String rightText = rExpression.getText();
        if ("+".equals(opSign) && ExpressionUtils.isZero(initializer) || "*".equals(opSign) && ExpressionUtils.isOne(initializer)) {
            initializerText = rightText;
        } else {
            boolean parenthesesForLhs = PsiPrecedenceUtil.getPrecedence((PsiExpression)initializer) > PsiPrecedenceUtil.getPrecedenceForOperator((IElementType)simpleOp);
            boolean parenthesesForRhs = PsiPrecedenceUtil.areParenthesesNeeded((PsiJavaToken)sign, (PsiExpression)rExpression);
            initializerText = (parenthesesForLhs ? "(" + initializer.getText() + ")" : initializer.getText()) + opSign + (parenthesesForRhs ? "(" + rExpression.getText() + ")" : rExpression.getText());
        }
        PsiExpression initializerExpression = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(initializerText, (PsiElement)assignment);
        return (PsiExpression)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)initializerExpression);
    }

    @Nullable
    public static PsiLocalVariable copyVarWithInitializer(PsiLocalVariable origVar, PsiExpression initializer) {
        PsiElement declCopy = origVar.getParent().copy();
        PsiLocalVariable varCopy = (PsiLocalVariable)ContainerUtil.find((Object[])declCopy.getChildren(), e -> e instanceof PsiLocalVariable && Objects.equals(origVar.getName(), ((PsiLocalVariable)e).getName()));
        if (varCopy != null) {
            varCopy.setInitializer(initializer);
            varCopy.normalizeDeclaration();
        }
        return varCopy;
    }
}

