/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionMemory;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.hint.ParameterInfoController;
import com.intellij.codeInsight.hints.ParameterHintsPass;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.infos.CandidateInfo;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JavaMethodOverloadSwitchHandler
extends EditorActionHandler {
    private static final Key<Map<String, String>> ENTERED_PARAMETERS = Key.create((String)"entered.parameters");
    private final boolean mySwitchUp;

    JavaMethodOverloadSwitchHandler(boolean up) {
        this.mySwitchUp = up;
    }

    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        if (!CodeInsightSettings.getInstance().SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION || !ParameterInfoController.existsForEditor((Editor)editor)) {
            return false;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        PsiElement exprList = JavaMethodOverloadSwitchHandler.getExpressionList(editor, caret.getOffset(), project);
        if (exprList == null) {
            return false;
        }
        int lbraceOffset = exprList.getTextRange().getStartOffset();
        ParameterInfoController controller = ParameterInfoController.findControllerAtOffset((Editor)editor, (int)lbraceOffset);
        return controller != null && controller.isHintShown(false);
    }

    @Nullable
    private static PsiElement getExpressionList(@NotNull Editor editor, int offset, @NotNull Project project) {
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        return file != null ? ParameterInfoController.findArgumentList((PsiFile)file, (int)offset, (int)-1) : null;
    }

    protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project != null && CodeInsightSettings.getInstance().SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION && ParameterInfoController.existsWithVisibleHintForEditor((Editor)editor, (boolean)false)) {
            this.doSwitch(editor, caret == null ? editor.getCaretModel().getPrimaryCaret() : caret, project);
        }
    }

    private void doSwitch(@NotNull Editor editor, @NotNull Caret caret, @NotNull Project project) {
        int currentIndex;
        if (editor.isViewer() || !EditorModificationUtil.requestWriting((Editor)editor)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiElement exprList = JavaMethodOverloadSwitchHandler.getExpressionList(editor, caret.getOffset(), project);
        if (!(exprList instanceof PsiExpressionList)) {
            return;
        }
        PsiElement call = exprList.getParent();
        if (!(call instanceof PsiCall)) {
            return;
        }
        int lbraceOffset = exprList.getTextRange().getStartOffset();
        ParameterInfoController controller = ParameterInfoController.findControllerAtOffset((Editor)editor, (int)lbraceOffset);
        if (controller == null || !controller.isHintShown(false)) {
            return;
        }
        Object[] objects = controller.getObjects();
        Object highlighted = controller.getHighlighted();
        if (objects == null || objects.length <= 1) {
            return;
        }
        HashMap<String, String> enteredParameters = (HashMap<String, String>)exprList.getUserData(ENTERED_PARAMETERS);
        if (enteredParameters == null) {
            enteredParameters = new HashMap<String, String>();
            exprList.putUserData(ENTERED_PARAMETERS, enteredParameters);
        }
        boolean virtualComma = Registry.is((String)"editor.completion.hints.virtual.comma");
        if (highlighted == null) {
            currentIndex = this.mySwitchUp ? objects.length : -1;
        } else {
            PsiExpression[] enteredExpressions;
            int enteredCount;
            currentIndex = Arrays.asList(objects).indexOf(highlighted);
            if (currentIndex < 0) {
                return;
            }
            PsiMethod currentMethod = (PsiMethod)((CandidateInfo)objects[currentIndex]).getElement();
            int currentMethodParameterCount = currentMethod.getParameterList().getParametersCount();
            if (!(currentMethodParameterCount == (enteredCount = (enteredExpressions = ((PsiExpressionList)exprList).getExpressions()).length) || enteredCount == 0 && currentMethodParameterCount == 1 || virtualComma && (currentMethod.isVarArgs() || enteredCount <= currentMethodParameterCount))) {
                return;
            }
            for (int i = 0; i < enteredExpressions.length; ++i) {
                PsiExpression expression2 = enteredExpressions[i];
                String value2 = expression2.getText().trim();
                if (value2.isEmpty()) continue;
                String key2 = JavaMethodOverloadSwitchHandler.getParameterKey(currentMethod, i);
                enteredParameters.put(key2, value2);
            }
        }
        PsiMethod targetMethod = (PsiMethod)((CandidateInfo)objects[(currentIndex + (this.mySwitchUp ? -1 : 1) + objects.length) % objects.length]).getElement();
        JavaMethodOverloadSwitchHandler.updateParameterValues(editor, caret, targetMethod, exprList, lbraceOffset, enteredParameters, virtualComma);
        PsiCall methodCall = (PsiCall)call;
        JavaMethodCallElement.setCompletionModeIfNotSet(methodCall, (Disposable)controller);
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        CompletionMemory.registerChosenMethod(targetMethod, methodCall);
        controller.setPreservedOnHintHidden(true);
        ParameterHintsPass.syncUpdate((PsiElement)call, (Editor)editor);
        controller.showHint(false, false);
    }

    private static void updateParameterValues(@NotNull Editor editor, @NotNull Caret caret, @NotNull PsiMethod targetMethod, @NotNull PsiElement exprList, int lbraceOffset, @NotNull Map<String, String> enteredParameters, boolean virtualComma) {
        PsiParameterList parameterList = targetMethod.getParameterList();
        int parametersCount = parameterList.getParametersCount();
        caret.moveToOffset(lbraceOffset);
        int endOffset = exprList.getTextRange().getEndOffset() - 1;
        int lastParameterWithValue = -1;
        if (virtualComma) {
            for (int i = parametersCount - 1; i >= 0; --i) {
                String key2 = JavaMethodOverloadSwitchHandler.getParameterKey(targetMethod, i);
                String value2 = enteredParameters.getOrDefault(key2, "");
                if (value2.isEmpty()) continue;
                lastParameterWithValue = i;
                break;
            }
        }
        int paramsToInsert = virtualComma ? lastParameterWithValue + 1 : parametersCount;
        Ref targetCaretPosition = new Ref();
        WriteAction.run(() -> {
            int offset = lbraceOffset + 1;
            editor.getDocument().deleteString(offset, endOffset);
            for (int i = 0; i < paramsToInsert; ++i) {
                String key2 = JavaMethodOverloadSwitchHandler.getParameterKey(targetMethod, i);
                String value2 = enteredParameters.getOrDefault(key2, "");
                if (value2.isEmpty() && targetCaretPosition.isNull()) {
                    targetCaretPosition.set((Object)offset);
                }
                if (i < parametersCount - 1 && (!virtualComma || i < paramsToInsert - 1 || targetCaretPosition.isNull())) {
                    value2 = value2 + ", ";
                }
                editor.getDocument().insertString(offset, (CharSequence)value2);
                offset += value2.length();
            }
            if (targetCaretPosition.isNull()) {
                targetCaretPosition.set((Object)offset);
            }
        });
        caret.moveToOffset(((Integer)targetCaretPosition.get()).intValue());
    }

    private static String getParameterKey(PsiMethod method, int parameterIndex) {
        int parameterCount = method.getParameterList().getParametersCount();
        int mainIndex = method.isVarArgs() && parameterIndex >= parameterCount ? parameterCount - 1 : parameterIndex;
        int subIndex = parameterIndex - mainIndex;
        PsiParameter parameter2 = method.getParameterList().getParameters()[mainIndex];
        return parameter2.getName() + ":" + parameter2.getType().getCanonicalText() + (subIndex == 0 ? "" : ":" + subIndex);
    }
}

