/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.hint.ParameterInfoController;
import com.intellij.codeInsight.hints.ParameterHintsPass;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.util.text.CharArrayUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaPrevParameterHandler
extends EditorActionHandler {
    private final EditorActionHandler myDelegate;

    public JavaPrevParameterHandler(EditorActionHandler delegate) {
        this.myDelegate = delegate;
    }

    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        return this.myDelegate.isEnabled(editor, caret, dataContext);
    }

    protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
        PsiElement exprList;
        PsiFile file;
        int offset = caret != null ? caret.getOffset() : editor.getCaretModel().getOffset();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project != null && (file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) instanceof PsiJavaFile && (exprList = ParameterInfoController.findArgumentList((PsiFile)file, (int)offset, (int)-1)) instanceof PsiExpressionList) {
            ParameterInfoController controller;
            CharSequence text2 = editor.getDocument().getImmutableCharSequence();
            int next = CharArrayUtil.shiftForward((CharSequence)text2, (int)offset, (String)" \t");
            int prev = CharArrayUtil.shiftBackward((CharSequence)text2, (int)(offset - 1), (String)" \t");
            int rParOffset = exprList.getTextRange().getEndOffset() - 1;
            if ((offset == rParOffset + 1 || next == rParOffset && prev >= 0 && prev < text2.length() && text2.charAt(prev) == ',') && (controller = ParameterInfoController.findControllerAtOffset((Editor)editor, (int)exprList.getTextRange().getStartOffset())) != null) {
                Object[] objects = controller.getObjects();
                Object highlighted = controller.getHighlighted();
                if (objects != null && objects.length > 0 && (highlighted != null || objects.length == 1)) {
                    PsiMethod currentMethod;
                    int currentIndex;
                    int n = currentIndex = highlighted == null ? 0 : Arrays.asList(objects).indexOf(highlighted);
                    if (currentIndex >= 0 && ((currentMethod = (PsiMethod)((CandidateInfo)objects[currentIndex]).getElement()).isVarArgs() || offset != rParOffset + 1 && ((PsiExpressionList)exprList).getExpressionCount() > (Registry.is((String)"editor.completion.hints.virtual.comma") ? 1 : JavaMethodCallElement.getCompletionHintsLimit()))) {
                        boolean toReturn = false;
                        if (offset == rParOffset + 1) {
                            WriteAction.run(() -> editor.getDocument().insertString(rParOffset, (CharSequence)", "));
                        } else {
                            WriteAction.run(() -> editor.getDocument().deleteString(prev, next));
                            toReturn = true;
                        }
                        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                        PsiElement call = exprList.getParent();
                        if (call != null) {
                            ParameterHintsPass.syncUpdate((PsiElement)call, (Editor)editor);
                        }
                        if (toReturn) {
                            return;
                        }
                    }
                }
            }
        }
        this.myDelegate.execute(editor, caret, dataContext);
    }
}

