/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.MultiCharQuoteHandler;
import com.intellij.codeInsight.editorActions.SimpleTokenSetQuoteHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiRawStringLiteralUtil;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaQuoteHandler
extends SimpleTokenSetQuoteHandler
implements JavaLikeQuoteHandler,
MultiCharQuoteHandler {
    private final TokenSet concatenatableStrings = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.STRING_LITERAL});

    public JavaQuoteHandler() {
        super(new IElementType[]{JavaTokenType.STRING_LITERAL, JavaTokenType.CHARACTER_LITERAL, JavaTokenType.RAW_STRING_LITERAL});
    }

    public boolean isOpeningQuote(HighlighterIterator iterator, int offset) {
        boolean openingQuote = super.isOpeningQuote(iterator, offset);
        if (openingQuote && !iterator.atEnd()) {
            iterator.retreat();
            if (!iterator.atEnd() && StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(iterator.getTokenType())) {
                openingQuote = false;
            }
            iterator.advance();
        }
        return openingQuote;
    }

    public boolean isClosingQuote(HighlighterIterator iterator, int offset) {
        boolean closingQuote = super.isClosingQuote(iterator, offset);
        if (closingQuote && !iterator.atEnd()) {
            iterator.advance();
            if (!iterator.atEnd() && StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(iterator.getTokenType())) {
                closingQuote = false;
            }
            iterator.retreat();
        }
        return closingQuote;
    }

    public TokenSet getConcatenatableStringTokenTypes() {
        return this.concatenatableStrings;
    }

    public String getStringConcatenationOperatorRepresentation() {
        return "+";
    }

    public TokenSet getStringTokenTypes() {
        return this.myLiteralTokenSet;
    }

    public boolean isAppropriateElementTypeForLiteral(@NotNull IElementType tokenType) {
        return JavaQuoteHandler.isAppropriateElementTypeForLiteralStatic(tokenType);
    }

    public boolean needParenthesesAroundConcatenation(PsiElement element) {
        return element.getParent() instanceof PsiLiteralExpression && element.getParent().getParent() instanceof PsiReferenceExpression;
    }

    @Nullable
    public CharSequence getClosingQuote(@NotNull HighlighterIterator iterator, int offset) {
        int closingSequence;
        CharSequence text2;
        int leadingTicsSequence;
        if (iterator.getTokenType() == JavaTokenType.RAW_STRING_LITERAL && this.isOpeningQuote(iterator, offset - (leadingTicsSequence = PsiRawStringLiteralUtil.getLeadingTicksSequence((CharSequence)(text2 = iterator.getDocument().getImmutableCharSequence()).subSequence(iterator.getStart(), offset)))) && (closingSequence = PsiRawStringLiteralUtil.getLeadingTicksSequence((CharSequence)text2.subSequence(offset, iterator.getEnd()))) + 1 == leadingTicsSequence) {
            return "`";
        }
        return null;
    }

    public void insertClosingQuote(@NotNull Editor editor, int offset, @NotNull CharSequence closingQuote) {
        editor.getDocument().insertString(offset, (CharSequence)(" " + closingQuote));
        editor.getSelectionModel().setSelection(offset, offset + 1);
    }

    public static boolean isAppropriateElementTypeForLiteralStatic(IElementType tokenType) {
        return ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(tokenType) || tokenType == JavaTokenType.SEMICOLON || tokenType == JavaTokenType.COMMA || tokenType == JavaTokenType.RPARENTH || tokenType == JavaTokenType.RBRACKET || tokenType == JavaTokenType.RBRACE || tokenType == JavaTokenType.STRING_LITERAL || tokenType == JavaTokenType.CHARACTER_LITERAL || tokenType == JavaTokenType.RAW_STRING_LITERAL;
    }
}

