/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.JoinLinesHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class NestedIfJoinLinesHandler
implements JoinLinesHandlerDelegate {
    public int tryJoinLines(@NotNull Document document, @NotNull PsiFile psiFile, int start, int end) {
        PsiBlockStatement blockStatement;
        PsiCodeBlock block;
        PsiJavaToken elementAtStartLineEnd = (PsiJavaToken)ObjectUtils.tryCast((Object)psiFile.findElementAt(start), PsiJavaToken.class);
        PsiElement nextLineElement = psiFile.findElementAt(end);
        if (elementAtStartLineEnd == null || nextLineElement == null) {
            return -1;
        }
        PsiIfStatement outerIf = null;
        if (elementAtStartLineEnd.getTokenType().equals(JavaTokenType.RPARENTH)) {
            outerIf = (PsiIfStatement)ObjectUtils.tryCast((Object)elementAtStartLineEnd.getParent(), PsiIfStatement.class);
        } else if (elementAtStartLineEnd.getTokenType().equals(JavaTokenType.LBRACE) && (block = (PsiCodeBlock)ObjectUtils.tryCast((Object)elementAtStartLineEnd.getParent(), PsiCodeBlock.class)) != null && (blockStatement = (PsiBlockStatement)ObjectUtils.tryCast((Object)block.getParent(), PsiBlockStatement.class)) != null && ((outerIf = (PsiIfStatement)ObjectUtils.tryCast((Object)blockStatement.getParent(), PsiIfStatement.class)) == null || outerIf.getThenBranch() != blockStatement)) {
            return -1;
        }
        if (outerIf == null || outerIf.getElseBranch() != null) {
            return -1;
        }
        PsiIfStatement innerIf = (PsiIfStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.stripBraces(outerIf.getThenBranch()), PsiIfStatement.class);
        if (!PsiTreeUtil.isAncestor((PsiElement)innerIf, (PsiElement)nextLineElement, (boolean)false)) {
            return -1;
        }
        if (innerIf.getThenBranch() == null || innerIf.getElseBranch() != null) {
            return -1;
        }
        PsiExpression outerCondition = outerIf.getCondition();
        if (outerCondition == null) {
            return -1;
        }
        PsiExpression innerCondition = innerIf.getCondition();
        if (innerCondition == null) {
            return -1;
        }
        CommentTracker ct = new CommentTracker();
        String childConditionText = ParenthesesUtils.getText(ct.markUnchanged(innerCondition), 14);
        String parentConditionText = ParenthesesUtils.getText(ct.markUnchanged(outerCondition), 14);
        PsiElement newCondition = ct.replace((PsiElement)outerCondition, parentConditionText + "&&" + childConditionText);
        ct.replaceAndRestoreComments((PsiElement)outerIf.getThenBranch(), (PsiElement)innerIf.getThenBranch());
        return newCondition.getTextRange().getStartOffset() + parentConditionText.length() + 1;
    }
}

