/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.ReferenceData;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import java.awt.datatransfer.DataFlavor;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;

public class ReferenceTransferableData
implements TextBlockTransferableData,
Cloneable,
Serializable {
    private final ReferenceData[] myReferenceDatas;

    public ReferenceTransferableData(@NotNull ReferenceData[] referenceDatas) {
        this.myReferenceDatas = referenceDatas;
    }

    public DataFlavor getFlavor() {
        return ReferenceData.getDataFlavor();
    }

    public int getOffsetCount() {
        return this.myReferenceDatas.length * 2;
    }

    public int getOffsets(int[] offsets, int index) {
        for (ReferenceData data : this.myReferenceDatas) {
            offsets[index++] = data.startOffset;
            offsets[index++] = data.endOffset;
        }
        return index;
    }

    public int setOffsets(int[] offsets, int index) {
        for (ReferenceData data : this.myReferenceDatas) {
            data.startOffset = offsets[index++];
            data.endOffset = offsets[index++];
        }
        return index;
    }

    public ReferenceTransferableData clone() {
        ReferenceData[] newReferenceData = new ReferenceData[this.myReferenceDatas.length];
        for (int i = 0; i < this.myReferenceDatas.length; ++i) {
            newReferenceData[i] = (ReferenceData)this.myReferenceDatas[i].clone();
        }
        return new ReferenceTransferableData(newReferenceData);
    }

    @NotNull
    public ReferenceData[] getData() {
        return this.myReferenceDatas;
    }
}

