/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.codeInsight.editorActions.TextBlockTransferable;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import java.awt.datatransfer.DataFlavor;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringLiteralCopyPasteProcessor
implements CopyPastePreProcessor {
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text2) {
        StringBuilder buffer = new StringBuilder();
        int givenTextOffset = 0;
        boolean textWasChanged = false;
        int deducedBlockSelectionWidth = StringLiteralCopyPasteProcessor.deduceBlockSelectionWidth(startOffsets, endOffsets, text2);
        for (int i = 0; i < startOffsets.length && givenTextOffset < text2.length(); ++i, ++givenTextOffset) {
            TextRange escapedRange;
            if (i > 0) {
                buffer.append('\n');
            }
            int fileStartOffset = startOffsets[i];
            int fileEndOffset = endOffsets[i];
            int givenTextStartOffset = givenTextOffset;
            int givenTextEndOffset = givenTextOffset + (fileEndOffset - fileStartOffset);
            if ((givenTextOffset = givenTextEndOffset) > text2.length()) {
                return null;
            }
            String fragment = text2.substring(givenTextStartOffset, givenTextEndOffset);
            PsiElement element = file.findElementAt(fileStartOffset);
            TextRange textRange = escapedRange = element == null ? null : this.getEscapedRange(element);
            if (escapedRange == null || escapedRange.getStartOffset() > fileStartOffset || escapedRange.getEndOffset() < fileEndOffset) {
                buffer.append(fragment);
            } else {
                textWasChanged = true;
                buffer.append(this.unescape(fragment, element));
            }
            int blockSelectionPadding = deducedBlockSelectionWidth - (fileEndOffset - fileStartOffset);
            for (int j = 0; j < blockSelectionPadding; ++j) {
                buffer.append(' ');
                ++givenTextOffset;
            }
        }
        return textWasChanged ? buffer.toString() : null;
    }

    private static int deduceBlockSelectionWidth(int[] startOffsets, int[] endOffsets, String text2) {
        int fragmentCount = startOffsets.length;
        assert (fragmentCount > 0);
        int totalLength = fragmentCount - 1;
        for (int i = 0; i < fragmentCount; ++i) {
            totalLength += endOffsets[i] - startOffsets[i];
        }
        if (totalLength < text2.length() && (text2.length() + 1) % fragmentCount == 0) {
            return (text2.length() + 1) / fragmentCount - 1;
        }
        return -1;
    }

    @NotNull
    protected String unescape(String text2, PsiElement token) {
        return StringUtil.unescapeStringCharacters((String)text2);
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text2, RawText rawText) {
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getSelectionStart();
        int selectionEnd = selectionModel.getSelectionEnd();
        PsiElement token = this.findLiteralTokenType(file, selectionStart, selectionEnd);
        if (token == null) {
            return text2;
        }
        if (rawText != null && StringLiteralCopyPasteProcessor.wasUnescaped(text2, rawText.rawText)) {
            return rawText.rawText;
        }
        if (this.isStringLiteral(token)) {
            text2 = this.escapeAndSplit(text2, token);
        } else if (this.isCharLiteral(token)) {
            return this.escapeCharCharacters(text2, token);
        }
        return text2;
    }

    public String escapeAndSplit(String text2, PsiElement token) {
        StringBuilder buffer = new StringBuilder(text2.length());
        String breaker = this.getLineBreaker(token);
        String[] lines = LineTokenizer.tokenize((char[])text2.toCharArray(), (boolean)false, (boolean)true);
        for (int i = 0; i < lines.length; ++i) {
            buffer.append(this.escapeCharCharacters(lines[i], token));
            if (i != lines.length - 1) {
                buffer.append(breaker);
                continue;
            }
            if (!text2.endsWith("\n")) continue;
            buffer.append("\\n");
        }
        text2 = buffer.toString();
        return text2;
    }

    private static boolean wasUnescaped(String text2, String originalText) {
        try {
            return new TextBlockTransferable(StringUtil.unescapeStringCharacters((String)originalText), Collections.emptyList(), null).getTransferData(DataFlavor.stringFlavor).equals(text2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getLineBreaker(@NotNull PsiElement token) {
        CommonCodeStyleSettings codeStyleSettings = CodeStyle.getLanguageSettings((PsiFile)token.getContainingFile());
        return codeStyleSettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE ? "\\n\"\n+ \"" : "\\n\" +\n\"";
    }

    @Nullable
    protected PsiElement findLiteralTokenType(PsiFile file, int selectionStart, int selectionEnd) {
        TextRange textRange;
        PsiElement elementAtSelectionStart = file.findElementAt(selectionStart);
        if (elementAtSelectionStart == null) {
            return null;
        }
        if (!this.isStringLiteral(elementAtSelectionStart) && !this.isCharLiteral(elementAtSelectionStart)) {
            return null;
        }
        if (elementAtSelectionStart.getTextRange().getEndOffset() < selectionEnd) {
            PsiElement elementAtSelectionEnd = file.findElementAt(selectionEnd);
            if (elementAtSelectionEnd == null) {
                return null;
            }
            if (elementAtSelectionEnd.getNode().getElementType() == elementAtSelectionStart.getNode().getElementType() && elementAtSelectionEnd.getTextRange().getStartOffset() < selectionEnd) {
                return elementAtSelectionStart;
            }
        }
        if (selectionStart <= (textRange = elementAtSelectionStart.getTextRange()).getStartOffset() || selectionEnd >= textRange.getEndOffset()) {
            return null;
        }
        return elementAtSelectionStart;
    }

    protected boolean isCharLiteral(@NotNull PsiElement token) {
        ASTNode node = token.getNode();
        return node != null && node.getElementType() == JavaTokenType.CHARACTER_LITERAL;
    }

    protected boolean isStringLiteral(@NotNull PsiElement token) {
        ASTNode node = token.getNode();
        return node != null && node.getElementType() == JavaTokenType.STRING_LITERAL;
    }

    @Nullable
    protected TextRange getEscapedRange(@NotNull PsiElement token) {
        if (this.isCharLiteral(token) || this.isStringLiteral(token)) {
            TextRange tokenRange = token.getTextRange();
            return new TextRange(tokenRange.getStartOffset() + 1, tokenRange.getEndOffset() - 1);
        }
        return null;
    }

    @NotNull
    protected String escapeCharCharacters(@NotNull String s, @NotNull PsiElement token) {
        StringBuilder buffer = new StringBuilder();
        StringUtil.escapeStringCharacters((int)s.length(), (String)s, (String)(this.isStringLiteral(token) ? "\"" : "'"), (StringBuilder)buffer);
        return buffer.toString();
    }
}

