/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.moveUpDown;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.editorActions.moveUpDown.LineMover;
import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.jsp.jspJava.JspClassLevelDeclarationStatement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DeclarationMover
extends LineMover {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.actions.moveUpDown.DeclarationMover");
    private PsiEnumConstant myEnumToInsertSemicolonAfter;
    private boolean moveEnumConstant;

    DeclarationMover() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeMove(@NotNull Editor editor, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        super.beforeMove(editor, info, down);
        if (this.myEnumToInsertSemicolonAfter != null) {
            LeafElement semicolon = Factory.createSingleLeafElement((IElementType)JavaTokenType.SEMICOLON, (CharSequence)";", (int)0, (int)1, null, (PsiManager)this.myEnumToInsertSemicolonAfter.getManager());
            try {
                PsiElement inserted = this.myEnumToInsertSemicolonAfter.getParent().addAfter(semicolon.getPsi(), (PsiElement)this.myEnumToInsertSemicolonAfter);
                inserted = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)inserted);
                LogicalPosition position = editor.offsetToLogicalPosition(inserted.getTextRange().getEndOffset());
                info.toMove2 = new LineRange(position.line + 1, position.line + 1);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
            finally {
                this.myEnumToInsertSemicolonAfter = null;
            }
        }
    }

    public void afterMove(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        super.afterMove(editor, file, info, down);
        if (this.moveEnumConstant) {
            Document document = editor.getDocument();
            CharSequence cs = document.getCharsSequence();
            int end1 = info.range1.getEndOffset();
            char c1 = cs.charAt(--end1);
            while (Character.isWhitespace(c1)) {
                c1 = cs.charAt(--end1);
            }
            int end2 = info.range2.getEndOffset();
            char c2 = cs.charAt(--end2);
            while (Character.isWhitespace(c2)) {
                c2 = cs.charAt(--end2);
            }
            if (c1 == c2 || !DeclarationMover.contains(info.range1, end1) || !DeclarationMover.contains(info.range2, end2)) {
                return;
            }
            if (c1 == ',' || c1 == ';') {
                document.deleteString(end1, end1 + 1);
                if (end1 < end2) {
                    --end1;
                    --end2;
                }
                document.insertString(end2 + 1, (CharSequence)String.valueOf(c1));
            }
            if (c2 == ',' || c2 == ';') {
                document.deleteString(end2, end2 + 1);
                if (end2 < end1) {
                    --end1;
                }
                document.insertString(end1 + 1, (CharSequence)String.valueOf(c2));
            }
        }
    }

    private static boolean contains(RangeMarker rangeMarker, int index) {
        return rangeMarker.getStartOffset() <= index && rangeMarker.getEndOffset() >= index;
    }

    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        int neighbourLine;
        PsiElement sibling;
        LineRange range;
        if (!(file instanceof PsiJavaFile)) {
            return false;
        }
        boolean available = super.checkAvailable(editor, file, info, down);
        if (!available) {
            return false;
        }
        Pair psiRange = DeclarationMover.getElementRange((Editor)editor, (PsiFile)file, (LineRange)info.toMove);
        if (psiRange == null) {
            return false;
        }
        PsiMember firstMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)psiRange.getFirst()), PsiMember.class, (boolean)false);
        PsiElement endElement = (PsiElement)psiRange.getSecond();
        if (firstMember instanceof PsiEnumConstant && endElement instanceof PsiJavaToken) {
            IElementType tokenType = ((PsiJavaToken)endElement).getTokenType();
            if (down && tokenType == JavaTokenType.SEMICOLON) {
                return info.prohibitMove();
            }
            if (tokenType == JavaTokenType.COMMA || tokenType == JavaTokenType.SEMICOLON) {
                endElement = PsiTreeUtil.skipWhitespacesBackward((PsiElement)endElement);
            }
        }
        PsiMember lastMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)endElement, PsiMember.class, (boolean)false);
        if (firstMember == null || lastMember == null) {
            return false;
        }
        if (lastMember instanceof PsiEnumConstantInitializer) {
            PsiEnumConstantInitializer enumConstantInitializer = (PsiEnumConstantInitializer)lastMember;
            lastMember = enumConstantInitializer.getEnumConstant();
        }
        if (firstMember == lastMember) {
            this.moveEnumConstant = firstMember instanceof PsiEnumConstant;
            range = DeclarationMover.memberRange((PsiElement)firstMember, editor, info.toMove);
            if (range == null) {
                return false;
            }
            range.firstElement = range.lastElement = firstMember;
        } else {
            PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)firstMember, (PsiElement)lastMember);
            if (parent == null) {
                return false;
            }
            Pair combinedRange = DeclarationMover.getElementRange((PsiElement)parent, (PsiElement)firstMember, (PsiElement)lastMember);
            if (combinedRange == null) {
                return false;
            }
            LineRange lineRange1 = DeclarationMover.memberRange((PsiElement)combinedRange.getFirst(), editor, info.toMove);
            if (lineRange1 == null) {
                return false;
            }
            LineRange lineRange2 = DeclarationMover.memberRange((PsiElement)combinedRange.getSecond(), editor, info.toMove);
            if (lineRange2 == null) {
                return false;
            }
            range = new LineRange(lineRange1.startLine, lineRange2.endLine);
            range.firstElement = (PsiElement)combinedRange.getFirst();
            range.lastElement = (PsiElement)combinedRange.getSecond();
        }
        Document document = editor.getDocument();
        PsiElement psiElement = (down ? range.endLine >= document.getLineCount() : range.startLine == 0) ? null : (sibling = DeclarationMover.firstNonWhiteElement((int)(down ? document.getLineStartOffset(range.endLine) : document.getLineEndOffset(range.startLine - 1)), (PsiFile)file, (boolean)down));
        if (range.lastElement instanceof PsiEnumConstant) {
            if (sibling instanceof PsiJavaToken) {
                PsiJavaToken token = (PsiJavaToken)sibling;
                IElementType tokenType = token.getTokenType();
                if (down && tokenType == JavaTokenType.SEMICOLON) {
                    return info.prohibitMove();
                }
                if (tokenType == JavaTokenType.COMMA) {
                    sibling = down ? PsiTreeUtil.skipWhitespacesForward((PsiElement)sibling) : PsiTreeUtil.skipWhitespacesBackward((PsiElement)sibling);
                }
            } else if (sibling instanceof PsiField && !(sibling instanceof PsiEnumConstant)) {
                return info.prohibitMove();
            }
        }
        boolean areWeMovingClass = range.firstElement instanceof PsiClass;
        info.toMove = range;
        int n = neighbourLine = down ? range.endLine : range.startLine - 1;
        if (neighbourLine >= 0 && neighbourLine < document.getLineCount() && CharArrayUtil.containsOnlyWhiteSpaces((CharSequence)document.getImmutableCharSequence().subSequence(document.getLineStartOffset(neighbourLine), document.getLineEndOffset(neighbourLine))) && DeclarationMover.emptyLineCanBeDeletedAccordingToCodeStyle(file, document, document.getLineEndOffset(neighbourLine))) {
            info.toMove2 = new LineRange(neighbourLine, neighbourLine + 1);
        } else {
            try {
                LineRange intraClassRange = this.moveInsideOutsideClassPosition(editor, sibling, down, areWeMovingClass);
                if (intraClassRange == null) {
                    Couple<LineRange> splitRange = DeclarationMover.extractCommentRange(sibling);
                    LineRange lineRange = info.toMove2 = ((LineRange)splitRange.first).startLine == ((LineRange)splitRange.first).endLine || !down ? (LineRange)splitRange.second : (LineRange)splitRange.first;
                    if (down && sibling.getNextSibling() == null) {
                        return false;
                    }
                } else {
                    info.toMove2 = intraClassRange;
                }
                if (down ? info.toMove2.startLine < info.toMove.endLine : info.toMove2.endLine > info.toMove.startLine) {
                    return false;
                }
            }
            catch (IllegalMoveException e) {
                info.prohibitMove();
            }
        }
        return true;
    }

    private static boolean emptyLineCanBeDeletedAccordingToCodeStyle(PsiFile file, Document document, int offset) {
        CharSequence text2 = document.getImmutableCharSequence();
        String whitespace = " \t\n";
        int whitespaceStartOffset = CharArrayUtil.shiftBackward((CharSequence)text2, (int)(offset - 1), (String)whitespace) + 1;
        int whitespaceEndOffset = CharArrayUtil.shiftForward((CharSequence)text2, (int)offset, (String)whitespace);
        int minLineFeeds = CodeStyleManager.getInstance((Project)file.getProject()).getMinLineFeeds(file, whitespaceEndOffset);
        int actualLineFeeds = StringUtil.countNewLines((CharSequence)text2.subSequence(whitespaceStartOffset, whitespaceEndOffset));
        return actualLineFeeds > minLineFeeds;
    }

    private static LineRange memberRange(@NotNull PsiElement member, Editor editor, LineRange lineRange) {
        TextRange textRange = member.getTextRange();
        if (editor.getDocument().getTextLength() < textRange.getEndOffset()) {
            return null;
        }
        int startLine = editor.offsetToLogicalPosition((int)textRange.getStartOffset()).line;
        int endLine = editor.offsetToLogicalPosition((int)textRange.getEndOffset()).line + 1;
        Couple<LineRange> splitRanges = DeclarationMover.extractCommentRange(member);
        if (lineRange.startLine >= ((LineRange)splitRanges.first).endLine) {
            startLine = ((LineRange)splitRanges.second).startLine;
        } else if (lineRange.endLine < ((LineRange)splitRanges.second).startLine) {
            endLine = ((LineRange)splitRanges.first).endLine;
        }
        if (!DeclarationMover.isInsideDeclaration(member, startLine, endLine, lineRange, editor)) {
            return null;
        }
        return new LineRange(startLine, endLine);
    }

    private static Couple<LineRange> extractCommentRange(@NotNull PsiElement member) {
        PsiElement firstChild;
        PsiElement firstCoreChild = firstChild = member.getFirstChild();
        while (firstCoreChild instanceof PsiComment && !(firstCoreChild instanceof PsiDocComment) || firstCoreChild instanceof PsiWhiteSpace) {
            firstCoreChild = firstCoreChild.getNextSibling();
        }
        PsiElement lastAttachedChild = PsiTreeUtil.skipWhitespacesBackward((PsiElement)firstCoreChild);
        if (lastAttachedChild == null) {
            LineRange wholeRange = new LineRange(member);
            return Couple.of((Object)new LineRange(wholeRange.startLine, wholeRange.startLine), (Object)wholeRange);
        }
        return Couple.of((Object)new LineRange(firstChild, lastAttachedChild), (Object)new LineRange(firstCoreChild, member));
    }

    private static boolean isInsideDeclaration(@NotNull PsiElement member, int startLine, int endLine, LineRange lineRange, Editor editor) {
        PsiIdentifier nameIdentifier;
        PsiModifierList modifierList;
        if (startLine == lineRange.startLine || startLine == lineRange.endLine || endLine == lineRange.startLine || endLine == lineRange.endLine) {
            return true;
        }
        ArrayList<Object> memberSuspects = new ArrayList<Object>();
        PsiModifierList psiModifierList = modifierList = member instanceof PsiMember ? ((PsiMember)member).getModifierList() : null;
        if (modifierList != null) {
            memberSuspects.add(modifierList);
        }
        if (member instanceof PsiClass) {
            PsiClass aClass = (PsiClass)member;
            if (aClass instanceof PsiAnonymousClass) {
                return false;
            }
            nameIdentifier = aClass.getNameIdentifier();
            if (nameIdentifier != null) {
                memberSuspects.add(nameIdentifier);
            }
        }
        if (member instanceof PsiMethod) {
            PsiTypeElement psiTypeElement;
            PsiMethod method = (PsiMethod)member;
            nameIdentifier = method.getNameIdentifier();
            if (nameIdentifier != null) {
                memberSuspects.add(nameIdentifier);
            }
            if ((psiTypeElement = method.getReturnTypeElement()) != null) {
                memberSuspects.add(psiTypeElement);
            }
        }
        if (member instanceof PsiField) {
            PsiField field = (PsiField)member;
            nameIdentifier = field.getNameIdentifier();
            memberSuspects.add(nameIdentifier);
            PsiTypeElement psiTypeElement = field.getTypeElement();
            if (psiTypeElement != null) {
                memberSuspects.add(psiTypeElement);
            }
        }
        TextRange lineTextRange = new TextRange(editor.getDocument().getLineStartOffset(lineRange.startLine), editor.getDocument().getLineEndOffset(lineRange.endLine));
        for (PsiElement psiElement : memberSuspects) {
            TextRange textRange = psiElement.getTextRange();
            if (textRange == null || !lineTextRange.intersects(textRange)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private LineRange moveInsideOutsideClassPosition(Editor editor, PsiElement sibling, boolean isDown, boolean areWeMovingClass) throws IllegalMoveException {
        if (sibling == null || sibling instanceof PsiImportList) {
            throw new IllegalMoveException();
        }
        if (sibling instanceof PsiJavaToken && ((PsiJavaToken)sibling).getTokenType() == (isDown ? JavaTokenType.RBRACE : JavaTokenType.LBRACE) && sibling.getParent() instanceof PsiClass) {
            PsiClass aClass = (PsiClass)sibling.getParent();
            PsiElement parent = aClass.getParent();
            if (!areWeMovingClass && !(parent instanceof PsiClass)) {
                throw new IllegalMoveException();
            }
            if (aClass instanceof PsiAnonymousClass) {
                throw new IllegalMoveException();
            }
            PsiElement start = isDown ? sibling : aClass.getModifierList();
            return new LineRange(start, sibling, editor.getDocument());
        }
        if (!isDown && sibling.getParent() instanceof PsiClass && (PsiUtil.isJavaToken((PsiElement)sibling, (IElementType)JavaTokenType.SEMICOLON) || sibling instanceof PsiErrorElement) && DeclarationMover.firstNonWhiteElement((PsiElement)sibling.getPrevSibling(), (boolean)false) instanceof PsiEnumConstant) {
            PsiClass aClass = (PsiClass)sibling.getParent();
            if (!areWeMovingClass && !(aClass.getParent() instanceof PsiClass)) {
                throw new IllegalMoveException();
            }
            Document document = editor.getDocument();
            int startLine = document.getLineNumber(aClass.getTextRange().getStartOffset());
            int endLine = document.getLineNumber(sibling.getTextRange().getEndOffset()) + 1;
            return new LineRange(startLine, endLine);
        }
        if (sibling instanceof PsiClass) {
            PsiClass aClass = (PsiClass)sibling;
            if (aClass instanceof PsiAnonymousClass) {
                throw new IllegalMoveException();
            }
            if (isDown) {
                PsiElement child = aClass.getFirstChild();
                if (child == null) {
                    throw new IllegalMoveException();
                }
                return new LineRange(child, aClass.isEnum() ? this.afterEnumConstantsPosition(aClass) : aClass.getLBrace(), editor.getDocument());
            }
            PsiElement rBrace = aClass.getRBrace();
            if (rBrace == null) {
                throw new IllegalMoveException();
            }
            return new LineRange(rBrace, rBrace, editor.getDocument());
        }
        if (sibling instanceof JspClassLevelDeclarationStatement && DeclarationMover.firstNonWhiteElement((PsiElement)(isDown ? sibling.getNextSibling() : sibling.getPrevSibling()), (boolean)isDown) == null) {
            throw new IllegalMoveException();
        }
        return null;
    }

    private PsiElement afterEnumConstantsPosition(PsiClass aClass) {
        PsiField[] fields = aClass.getFields();
        for (int i = fields.length - 1; i >= 0; --i) {
            PsiField field = fields[i];
            if (!(field instanceof PsiEnumConstant)) continue;
            PsiElement anchor = DeclarationMover.firstNonWhiteElement((PsiElement)field.getNextSibling(), (boolean)true);
            if (!PsiUtil.isJavaToken((PsiElement)anchor, (IElementType)JavaTokenType.SEMICOLON)) {
                anchor = field;
                this.myEnumToInsertSemicolonAfter = (PsiEnumConstant)field;
            }
            return anchor;
        }
        return aClass.getLBrace();
    }

    private static class IllegalMoveException
    extends Exception {
        private IllegalMoveException() {
        }
    }
}

