/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.EnterProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;

public class CommentBreakerEnterProcessor
implements EnterProcessor {
    @Override
    public boolean doEnter(Editor editor, PsiElement psiElement, boolean isModified) {
        if (isModified) {
            return false;
        }
        PsiElement atCaret = psiElement.getContainingFile().findElementAt(editor.getCaretModel().getOffset());
        PsiComment comment = (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)atCaret, PsiComment.class, (boolean)false);
        if (comment != null) {
            CommentBreakerEnterProcessor.plainEnter(editor);
            if (comment.getTokenType() == JavaTokenType.END_OF_LINE_COMMENT) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"// ");
            }
            return true;
        }
        return false;
    }

    private static void plainEnter(Editor editor) {
        CommentBreakerEnterProcessor.getEnterHandler().execute(editor, ((EditorEx)editor).getDataContext());
    }

    private static EditorActionHandler getEnterHandler() {
        return EditorActionManager.getInstance().getActionHandler("EditorStartNewLine");
    }
}

