/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.WordSelectioner;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DocTagSelectioner
extends WordSelectioner {
    public boolean canSelect(@NotNull PsiElement e) {
        return e instanceof PsiDocTag;
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        List result = super.select(e, editorText, cursorOffset, editor);
        result.add(DocTagSelectioner.getDocTagRange((PsiDocTag)e, editorText, cursorOffset));
        return result;
    }

    public static TextRange getDocTagRange(PsiDocTag e, CharSequence documentText, int minOffset) {
        PsiElement child;
        int childStartOffset;
        TextRange range = e.getTextRange();
        int endOffset = range.getEndOffset();
        int startOffset = range.getStartOffset();
        PsiElement[] children = e.getChildren();
        for (int i = children.length - 1; i >= 0 && (childStartOffset = (child = children[i]).getTextRange().getStartOffset()) > minOffset; --i) {
            if (child instanceof PsiDocToken) {
                PsiDocToken token = (PsiDocToken)child;
                IElementType type2 = token.getTokenType();
                char[] chars = token.textToCharArray();
                int shift = CharArrayUtil.shiftForward((char[])chars, (int)0, (String)" \t\n\r");
                if (shift != chars.length && type2 != JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS) {
                    break;
                }
            } else if (!(child instanceof PsiWhiteSpace)) break;
            endOffset = Math.min(childStartOffset, endOffset);
        }
        startOffset = CharArrayUtil.shiftBackward((CharSequence)documentText, (int)(startOffset - 1), (String)"* \t") + 1;
        return new TextRange(startOffset, endOffset);
    }
}

