/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.BasicSelectioner;
import com.intellij.codeInsight.editorActions.wordSelection.CodeBlockOrInitializerSelectioner;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MethodOrClassSelectioner
extends BasicSelectioner {
    @Override
    public boolean canSelect(@NotNull PsiElement e) {
        return (e instanceof PsiClass && !(e instanceof PsiTypeParameter) || e instanceof PsiMethod) && e.getLanguage() == JavaLanguage.INSTANCE;
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        ArrayList result = ContainerUtil.newArrayList();
        PsiElement firstChild = e.getFirstChild();
        PsiElement[] children = e.getChildren();
        int i = 1;
        if (firstChild instanceof PsiDocComment) {
            while (children[i] instanceof PsiWhiteSpace) {
                ++i;
            }
            TextRange range = new TextRange(children[i].getTextRange().getStartOffset(), e.getTextRange().getEndOffset());
            result.add(range);
            result.addAll(MethodOrClassSelectioner.expandToWholeLinesWithBlanks((CharSequence)editorText, (TextRange)range));
            range = TextRange.create((Segment)firstChild.getTextRange());
            result.addAll(MethodOrClassSelectioner.expandToWholeLinesWithBlanks((CharSequence)editorText, (TextRange)range));
            firstChild = children[i++];
        }
        if (firstChild instanceof PsiComment) {
            while (children[i] instanceof PsiComment || children[i] instanceof PsiWhiteSpace) {
                ++i;
            }
            PsiElement last = children[i - 1] instanceof PsiWhiteSpace ? children[i - 2] : children[i - 1];
            TextRange range = new TextRange(firstChild.getTextRange().getStartOffset(), last.getTextRange().getEndOffset());
            if (range.contains(cursorOffset)) {
                result.addAll(MethodOrClassSelectioner.expandToWholeLinesWithBlanks((CharSequence)editorText, (TextRange)range));
            }
            range = new TextRange(children[i].getTextRange().getStartOffset(), e.getTextRange().getEndOffset());
            result.add(range);
            result.addAll(MethodOrClassSelectioner.expandToWholeLinesWithBlanks((CharSequence)editorText, (TextRange)range));
        }
        result.add(e.getTextRange());
        result.addAll(MethodOrClassSelectioner.expandToWholeLinesWithBlanks((CharSequence)editorText, (TextRange)e.getTextRange()));
        if (e instanceof PsiClass) {
            result.addAll(MethodOrClassSelectioner.selectWithTypeParameters((PsiClass)e));
            result.addAll(MethodOrClassSelectioner.selectBetweenBracesLines(children, editorText));
        }
        if (e instanceof PsiAnonymousClass) {
            result.addAll(MethodOrClassSelectioner.selectWholeBlock((PsiClass)((PsiAnonymousClass)e)));
        }
        return result;
    }

    private static Collection<TextRange> selectWithTypeParameters(@NotNull PsiClass psiClass) {
        PsiIdentifier identifier = psiClass.getNameIdentifier();
        PsiTypeParameterList list = psiClass.getTypeParameterList();
        if (identifier != null && list != null) {
            return Collections.singletonList(new TextRange(identifier.getTextRange().getStartOffset(), list.getTextRange().getEndOffset()));
        }
        return Collections.emptyList();
    }

    private static Collection<TextRange> selectBetweenBracesLines(@NotNull PsiElement[] children, @NotNull CharSequence editorText) {
        int start = CodeBlockOrInitializerSelectioner.findOpeningBrace(children);
        if (start != 0) {
            int end = CodeBlockOrInitializerSelectioner.findClosingBrace(children, start);
            return MethodOrClassSelectioner.expandToWholeLinesWithBlanks((CharSequence)editorText, (TextRange)new TextRange(start, end));
        }
        return Collections.emptyList();
    }

    private static Collection<TextRange> selectWholeBlock(PsiClass c) {
        PsiJavaToken[] tokens = (PsiJavaToken[])PsiTreeUtil.getChildrenOfType((PsiElement)c, PsiJavaToken.class);
        if (tokens != null && tokens.length == 2 && tokens[0].getTokenType() == JavaTokenType.LBRACE && tokens[1].getTokenType() == JavaTokenType.RBRACE) {
            return Collections.singleton(new TextRange(tokens[0].getTextRange().getStartOffset(), tokens[1].getTextRange().getEndOffset()));
        }
        return Collections.emptyList();
    }
}

