/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.lang.LanguageExtension;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiParameter;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public interface ConstructorBodyGenerator {
    public static final LanguageExtension<ConstructorBodyGenerator> INSTANCE = new LanguageExtension("com.intellij.constructorBodyGenerator");

    default public void generateFieldInitialization(@NotNull StringBuilder buffer, @NotNull PsiField[] fields, @NotNull PsiParameter[] parameters2, @NotNull Collection<String> existingNames) {
        int length = fields.length;
        for (int i = 0; i < length; ++i) {
            String fieldName = fields[i].getName();
            String paramName = parameters2[i].getName();
            if (existingNames.contains(fieldName)) {
                buffer.append("this.");
            }
            buffer.append(fieldName);
            buffer.append("=");
            buffer.append(paramName);
            this.appendSemicolon(buffer);
            buffer.append("\n");
        }
    }

    @Deprecated
    default public void generateFieldInitialization(@NotNull StringBuilder buffer, @NotNull PsiField[] fields, @NotNull PsiParameter[] parameters2) {
    }

    default public void appendSemicolon(@NotNull StringBuilder buffer) {
    }

    default public void generateSuperCallIfNeeded(@NotNull StringBuilder buffer, @NotNull PsiParameter[] parameters2) {
        if (parameters2.length > 0) {
            buffer.append("super(");
            for (int j = 0; j < parameters2.length; ++j) {
                PsiParameter param = parameters2[j];
                buffer.append(param.getName());
                if (j >= parameters2.length - 1) continue;
                buffer.append(",");
            }
            buffer.append(")");
            this.appendSemicolon(buffer);
            buffer.append("\n");
        }
    }

    default public StringBuilder start(StringBuilder buffer, @NotNull String name, @NotNull PsiParameter[] parameters2) {
        buffer.append("public ").append(name).append("(");
        for (PsiParameter parameter2 : parameters2) {
            buffer.append(parameter2.getType().getPresentableText()).append(' ').append(parameter2.getName()).append(',');
        }
        if (parameters2.length > 0) {
            buffer.delete(buffer.length() - 1, buffer.length());
        }
        buffer.append("){\n");
        return buffer;
    }

    default public void finish(StringBuilder builder) {
        builder.append('}');
    }
}

