/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.codeInsight.generation.PsiMethodWithOverridingPercentMember;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.MemberChooser;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaOverrideImplementMemberChooser
extends MemberChooser<PsiMethodMember> {
    private static final String SORT_METHODS_BY_PERCENT_DESCRIPTION = "Sort by Percent of Classes which Overrides a Method";
    @NonNls
    public static final String PROP_COMBINED_OVERRIDE_IMPLEMENT = "OverrideImplement.combined";
    @NonNls
    public static final String PROP_OVERRIDING_SORTED_OVERRIDE_IMPLEMENT = "OverrideImplement.overriding.sorted";
    private ToggleAction myMergeAction;
    private final PsiMethodMember[] myAllElements;
    private final PsiMethodMember[] myOnlyPrimaryElements;
    private final NotNullLazyValue<PsiMethodWithOverridingPercentMember[]> myLazyElementsWithPercent;
    private final boolean myToImplement;
    private final Project myProject;
    private final PsiFile myFile;
    private boolean myMerge;
    private boolean mySortedByOverriding;

    @Nullable
    public static JavaOverrideImplementMemberChooser create(PsiElement aClass, boolean toImplement, final Collection<? extends CandidateInfo> candidates, Collection<? extends CandidateInfo> secondary) {
        Project project = aClass.getProject();
        PsiFile file = aClass.getContainingFile();
        if (candidates.isEmpty() && secondary.isEmpty()) {
            return null;
        }
        PsiMethodMember[] onlyPrimary = JavaOverrideImplementMemberChooser.convertToMethodMembers(candidates);
        LinkedHashSet<? extends CandidateInfo> allCandidates = new LinkedHashSet<CandidateInfo>(candidates);
        allCandidates.addAll(secondary);
        PsiMethodMember[] all = JavaOverrideImplementMemberChooser.convertToMethodMembers(allCandidates);
        NotNullLazyValue<PsiMethodWithOverridingPercentMember[]> lazyElementsWithPercent = new NotNullLazyValue<PsiMethodWithOverridingPercentMember[]>(){

            @NotNull
            protected PsiMethodWithOverridingPercentMember[] compute() {
                PsiMethodWithOverridingPercentMember[] elements = PsiMethodWithOverridingPercentMember.calculateOverridingPercents(candidates);
                Arrays.sort(elements, PsiMethodWithOverridingPercentMember.COMPARATOR);
                return elements;
            }
        };
        boolean merge = PropertiesComponent.getInstance((Project)project).getBoolean(PROP_COMBINED_OVERRIDE_IMPLEMENT, true);
        LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)aClass);
        boolean overrideVisible = languageLevel.isAtLeast(LanguageLevel.JDK_1_6) || languageLevel.equals((Object)LanguageLevel.JDK_1_5) && !toImplement;
        JavaOverrideImplementMemberChooser javaOverrideImplementMemberChooser = new JavaOverrideImplementMemberChooser(file, all, onlyPrimary, lazyElementsWithPercent, project, overrideVisible, merge, toImplement, PropertiesComponent.getInstance((Project)project).getBoolean(PROP_OVERRIDING_SORTED_OVERRIDE_IMPLEMENT));
        javaOverrideImplementMemberChooser.setTitle(JavaOverrideImplementMemberChooser.getChooserTitle(toImplement, merge));
        javaOverrideImplementMemberChooser.setCopyJavadocVisible(true);
        if (toImplement) {
            if (onlyPrimary.length == 0) {
                javaOverrideImplementMemberChooser.selectElements(new ClassMember[]{all[0]});
            } else {
                javaOverrideImplementMemberChooser.selectElements((ClassMember[])onlyPrimary);
            }
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (!toImplement || onlyPrimary.length == 0) {
                javaOverrideImplementMemberChooser.selectElements((ClassMember[])all);
            }
            javaOverrideImplementMemberChooser.close(0);
            return javaOverrideImplementMemberChooser;
        }
        return javaOverrideImplementMemberChooser;
    }

    private JavaOverrideImplementMemberChooser(@NotNull PsiFile file, PsiMethodMember[] allElements, PsiMethodMember[] onlyPrimaryElements, NotNullLazyValue<PsiMethodWithOverridingPercentMember[]> lazyElementsWithPercent, @NotNull Project project, boolean isInsertOverrideVisible, boolean merge, boolean toImplement, boolean sortedByOverriding) {
        super(false, true, project, isInsertOverrideVisible, null, null);
        this.myAllElements = allElements;
        this.myOnlyPrimaryElements = onlyPrimaryElements;
        this.myLazyElementsWithPercent = lazyElementsWithPercent;
        this.myProject = project;
        this.myFile = file;
        this.myMerge = merge;
        this.myToImplement = toImplement;
        this.mySortedByOverriding = sortedByOverriding;
        this.resetElements((ClassMember[])JavaOverrideImplementMemberChooser.getInitialElements(allElements, onlyPrimaryElements, lazyElementsWithPercent, merge, toImplement, sortedByOverriding));
        this.init();
    }

    private static PsiMethodMember[] getInitialElements(PsiMethodMember[] allElements, PsiMethodMember[] onlyPrimaryElements, NotNullLazyValue<PsiMethodWithOverridingPercentMember[]> lazyElementsWithPercent, boolean merge, boolean toImplement, boolean sortByOverriding) {
        boolean showElementsWithPercents = sortByOverriding && !toImplement;
        PsiMethodMember[] defaultElements = toImplement || merge ? allElements : onlyPrimaryElements;
        return showElementsWithPercents ? (PsiMethodMember[])lazyElementsWithPercent.getValue() : defaultElements;
    }

    protected void onAlphabeticalSortingEnabled(AnActionEvent event) {
        this.mySortedByOverriding = false;
        this.resetElements((ClassMember[])(this.myToImplement || this.myMerge ? this.myAllElements : this.myOnlyPrimaryElements), null, true);
        this.restoreTree();
    }

    protected void doOKAction() {
        super.doOKAction();
        PropertiesComponent.getInstance((Project)this.myProject).setValue(PROP_COMBINED_OVERRIDE_IMPLEMENT, this.myMerge, true);
        PropertiesComponent.getInstance((Project)this.myProject).setValue(PROP_OVERRIDING_SORTED_OVERRIDE_IMPLEMENT, this.mySortedByOverriding);
    }

    protected void fillToolbarActions(DefaultActionGroup group) {
        super.fillToolbarActions(group);
        if (this.myToImplement) {
            return;
        }
        MySortByOverridingAction sortByOverridingAction = new MySortByOverridingAction();
        if (this.mySortedByOverriding) {
            this.changeSortComparator(PsiMethodWithOverridingPercentMember.COMPARATOR);
        }
        group.add((AnAction)sortByOverridingAction, Constraints.FIRST);
        this.myMergeAction = new MyMergeAction();
        group.add((AnAction)this.myMergeAction);
    }

    private static String getChooserTitle(boolean toImplement, boolean merge) {
        return toImplement ? CodeInsightBundle.message((String)"methods.to.implement.chooser.title", (Object[])new Object[0]) : (merge ? CodeInsightBundle.message((String)"methods.to.override.implement.chooser.title", (Object[])new Object[0]) : CodeInsightBundle.message((String)"methods.to.override.chooser.title", (Object[])new Object[0]));
    }

    private static PsiMethodMember[] convertToMethodMembers(Collection<? extends CandidateInfo> candidates) {
        return (PsiMethodMember[])ContainerUtil.map2Array(candidates, PsiMethodMember.class, s -> new PsiMethodMember((CandidateInfo)s));
    }

    protected boolean isInsertOverrideAnnotationSelected() {
        return JavaCodeStyleSettings.getInstance((PsiFile)this.myFile).INSERT_OVERRIDE_ANNOTATION;
    }

    private class MyMergeAction
    extends ToggleAction {
        private MyMergeAction() {
            super("Show methods to implement", "Show methods to implement", AllIcons.General.Show_to_implement);
            this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(73, 8)), (JComponent)JavaOverrideImplementMemberChooser.this.myTree);
            this.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"OverrideMethods"), (JComponent)JavaOverrideImplementMemberChooser.this.myTree);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return JavaOverrideImplementMemberChooser.this.myMerge;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            JavaOverrideImplementMemberChooser.this.myMerge = state;
            if (state && JavaOverrideImplementMemberChooser.this.mySortedByOverriding) {
                JavaOverrideImplementMemberChooser.this.mySortedByOverriding = false;
            }
            JavaOverrideImplementMemberChooser.this.resetElements((ClassMember[])(state ? JavaOverrideImplementMemberChooser.this.myAllElements : JavaOverrideImplementMemberChooser.this.myOnlyPrimaryElements), null, true);
            JavaOverrideImplementMemberChooser.this.restoreTree();
            JavaOverrideImplementMemberChooser.this.setTitle(JavaOverrideImplementMemberChooser.getChooserTitle(false, JavaOverrideImplementMemberChooser.this.myMerge));
        }
    }

    private class MySortByOverridingAction
    extends ToggleAction {
        MySortByOverridingAction() {
            super(JavaOverrideImplementMemberChooser.SORT_METHODS_BY_PERCENT_DESCRIPTION, JavaOverrideImplementMemberChooser.SORT_METHODS_BY_PERCENT_DESCRIPTION, AllIcons.ObjectBrowser.SortedByUsage);
            this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(85, 8)), (JComponent)JavaOverrideImplementMemberChooser.this.myTree);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return JavaOverrideImplementMemberChooser.this.mySortedByOverriding;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            JavaOverrideImplementMemberChooser.this.mySortedByOverriding = state;
            if (state) {
                if (JavaOverrideImplementMemberChooser.this.myMerge) {
                    JavaOverrideImplementMemberChooser.this.myMergeAction.setSelected(e, false);
                }
                JavaOverrideImplementMemberChooser.this.disableAlphabeticalSorting(e);
                PsiMethodWithOverridingPercentMember[] elementsWithPercent = (PsiMethodWithOverridingPercentMember[])JavaOverrideImplementMemberChooser.this.myLazyElementsWithPercent.getValue();
                JavaOverrideImplementMemberChooser.this.resetElements((ClassMember[])elementsWithPercent, PsiMethodWithOverridingPercentMember.COMPARATOR, false);
            } else {
                PsiMethodMember[] elementsToRender = JavaOverrideImplementMemberChooser.this.myMerge ? JavaOverrideImplementMemberChooser.this.myAllElements : JavaOverrideImplementMemberChooser.this.myOnlyPrimaryElements;
                JavaOverrideImplementMemberChooser.this.resetElementsWithDefaultComparator((ClassMember[])elementsToRender);
            }
        }
    }
}

