/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.MethodImplementor;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.ImplementMethodsHandler;
import com.intellij.codeInsight.generation.JavaOverrideImplementMemberChooser;
import com.intellij.codeInsight.generation.OverrideImplementExploreUtil;
import com.intellij.codeInsight.generation.OverrideImplementsAnnotationsHandler;
import com.intellij.codeInsight.generation.OverrideMethodsHandler;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.JavaTemplateUtil;
import com.intellij.ide.util.MemberChooser;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverrideImplementUtil
extends OverrideImplementExploreUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.OverrideImplementUtil");
    public static final String IMPLEMENT_COMMAND_MARKER = "implement";

    private OverrideImplementUtil() {
    }

    @NotNull
    protected static List<MethodImplementor> getImplementors() {
        return MethodImplementor.EXTENSION_POINT_NAME.getExtensionList();
    }

    @NotNull
    public static List<PsiMethod> overrideOrImplementMethod(@NotNull PsiClass aClass, @NotNull PsiMethod method, boolean toCopyJavaDoc) throws IncorrectOperationException {
        PsiClass containingClass = method.getContainingClass();
        LOG.assertTrue(containingClass != null);
        PsiSubstitutor substitutor = aClass.isInheritor(containingClass, true) ? TypeConversionUtil.getSuperClassSubstitutor((PsiClass)containingClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY) : PsiSubstitutor.EMPTY;
        return OverrideImplementUtil.overrideOrImplementMethod(aClass, method, substitutor, toCopyJavaDoc, JavaCodeStyleSettings.getInstance((PsiFile)aClass.getContainingFile()).INSERT_OVERRIDE_ANNOTATION);
    }

    public static boolean isInsertOverride(@NotNull PsiMethod superMethod, @NotNull PsiClass targetClass) {
        if (!JavaCodeStyleSettings.getInstance((PsiFile)targetClass.getContainingFile()).INSERT_OVERRIDE_ANNOTATION) {
            return false;
        }
        return OverrideImplementUtil.canInsertOverride(superMethod, targetClass);
    }

    public static boolean canInsertOverride(@NotNull PsiMethod superMethod, @NotNull PsiClass targetClass) {
        if (superMethod.isConstructor() || superMethod.hasModifierProperty("static")) {
            return false;
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)targetClass)) {
            return false;
        }
        if (PsiUtil.isLanguageLevel6OrHigher((PsiElement)targetClass)) {
            return true;
        }
        PsiClass superClass = superMethod.getContainingClass();
        return superClass != null && !superClass.isInterface();
    }

    @NotNull
    public static List<PsiMethod> overrideOrImplementMethod(@NotNull PsiClass aClass, @NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, boolean toCopyJavaDoc, boolean insertOverrideIfPossible) throws IncorrectOperationException {
        if (!method.isValid() || !substitutor.isValid()) {
            return Collections.emptyList();
        }
        ArrayList<PsiMethod> results = new ArrayList<PsiMethod>();
        for (MethodImplementor implementor : OverrideImplementUtil.getImplementors()) {
            PsiMethod[] prototypes;
            for (PsiMethod prototype : prototypes = implementor.createImplementationPrototypes(aClass, method)) {
                implementor.createDecorator(aClass, method, toCopyJavaDoc, insertOverrideIfPossible).consume((Object)prototype);
                results.add(prototype);
            }
        }
        if (results.isEmpty()) {
            PsiAnnotationMemberValue defaultValue;
            PsiMethod method1 = GenerateMembersUtil.substituteGenericMethod(method, substitutor, (PsiElement)aClass);
            PsiElement copyClass = OverrideImplementUtil.copyClass(aClass);
            PsiMethod result = (PsiMethod)copyClass.add((PsiElement)method1);
            if (PsiUtil.isAnnotationMethod((PsiElement)result) && (defaultValue = ((PsiAnnotationMethod)result).getDefaultValue()) != null) {
                PsiAnnotationMemberValue defaultKeyword;
                for (defaultKeyword = defaultValue; !(defaultKeyword instanceof PsiKeyword) && defaultKeyword != null; defaultKeyword = defaultKeyword.getPrevSibling()) {
                }
                if (defaultKeyword == null) {
                    defaultKeyword = defaultValue;
                }
                defaultValue.getParent().deleteChildRange((PsiElement)defaultKeyword, (PsiElement)defaultValue);
            }
            Consumer<PsiMethod> decorator = OverrideImplementUtil.createDefaultDecorator(aClass, method, toCopyJavaDoc, insertOverrideIfPossible);
            decorator.consume((Object)result);
            results.add(result);
        }
        results.removeIf(m -> aClass.findMethodBySignature(m, false) != null);
        return results;
    }

    @NotNull
    private static PsiElement copyClass(@NotNull PsiClass aClass) {
        Object marker = new Object();
        PsiTreeUtil.mark((PsiElement)aClass, (Object)marker);
        PsiElement copy = aClass.getContainingFile().copy();
        PsiElement copyClass = PsiTreeUtil.releaseMark((PsiElement)copy, (Object)marker);
        LOG.assertTrue(copyClass != null);
        return copyClass;
    }

    @NotNull
    public static Consumer<PsiMethod> createDefaultDecorator(@NotNull PsiClass aClass, @NotNull PsiMethod method, boolean toCopyJavaDoc, boolean insertOverrideIfPossible) {
        return result -> OverrideImplementUtil.decorateMethod(aClass, method, toCopyJavaDoc, insertOverrideIfPossible, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static PsiMethod decorateMethod(@NotNull PsiClass aClass, @NotNull PsiMethod method, boolean toCopyJavaDoc, boolean insertOverrideIfPossible, @NotNull PsiMethod result) {
        PsiClass containingClass;
        PsiTypeParameterList list;
        PsiUtil.setModifierProperty((PsiModifierListOwner)result, (String)"abstract", (aClass.isInterface() && method.hasModifierProperty("abstract") ? 1 : 0) != 0);
        PsiUtil.setModifierProperty((PsiModifierListOwner)result, (String)"native", (boolean)false);
        if (!toCopyJavaDoc) {
            OverrideImplementUtil.deleteDocComment(result);
        }
        if ((list = result.getTypeParameterList()) != null && (containingClass = method.getContainingClass()) != null) {
            for (PsiClassType classType : aClass.getSuperTypes()) {
                if (!InheritanceUtil.isInheritorOrSelf((PsiClass)PsiUtil.resolveClassInType((PsiType)classType), (PsiClass)containingClass, (boolean)true) || !classType.isRaw()) continue;
                list.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createTypeParameterList());
                break;
            }
        }
        OverrideImplementUtil.annotateOnOverrideImplement(result, aClass, method, insertOverrideIfPossible);
        if (JavaCodeStyleSettings.getInstance((PsiFile)aClass.getContainingFile()).REPEAT_SYNCHRONIZED && method.hasModifierProperty("synchronized")) {
            result.getModifierList().setModifierProperty("synchronized", true);
        }
        PsiCodeBlock body2 = JavaPsiFacade.getElementFactory((Project)method.getProject()).createCodeBlockFromText("{}", null);
        PsiCodeBlock oldBody = result.getBody();
        if (oldBody != null) {
            oldBody.replace((PsiElement)body2);
        } else {
            result.add((PsiElement)body2);
        }
        OverrideImplementUtil.setupMethodBody(result, method, aClass);
        Project project = method.getProject();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        CommonCodeStyleSettings javaSettings = CodeStyle.getLanguageSettings((PsiFile)aClass.getContainingFile(), (Language)JavaLanguage.INSTANCE);
        boolean keepBreaks = javaSettings.KEEP_LINE_BREAKS;
        javaSettings.KEEP_LINE_BREAKS = false;
        try {
            result = (PsiMethod)JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)result);
            result = (PsiMethod)codeStyleManager.reformat((PsiElement)result);
        }
        finally {
            javaSettings.KEEP_LINE_BREAKS = keepBreaks;
        }
        return result;
    }

    public static void deleteDocComment(@NotNull PsiMethod result) {
        PsiDocComment comment = result.getDocComment();
        if (comment != null) {
            comment.delete();
        }
    }

    public static void annotateOnOverrideImplement(@NotNull PsiMethod method, @NotNull PsiClass targetClass, @NotNull PsiMethod overridden) {
        OverrideImplementUtil.annotateOnOverrideImplement(method, targetClass, overridden, JavaCodeStyleSettings.getInstance((PsiFile)targetClass.getContainingFile()).INSERT_OVERRIDE_ANNOTATION);
    }

    static void annotateOnOverrideImplement(@NotNull PsiMethod method, @NotNull PsiClass targetClass, @NotNull PsiMethod overridden, boolean insertOverride) {
        String overrideAnnotationName;
        if (insertOverride && OverrideImplementUtil.canInsertOverride(overridden, targetClass) && !AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)(overrideAnnotationName = Override.class.getName()), (int)0)) {
            AddAnnotationPsiFix.addPhysicalAnnotation(overrideAnnotationName, PsiNameValuePair.EMPTY_ARRAY, method.getModifierList());
        }
        OverrideImplementsAnnotationsHandler.repeatAnnotationsFromSource((PsiModifierListOwner)overridden, (PsiElement)targetClass, (PsiModifierListOwner)method);
    }

    public static void annotate(@NotNull PsiMethod result, @NotNull String fqn, String ... annosToRemove) throws IncorrectOperationException {
        AddAnnotationFix fix2 = new AddAnnotationFix(fqn, (PsiModifierListOwner)result, annosToRemove);
        Project project = result.getProject();
        if (fix2.isAvailable(project, null, result.getContainingFile())) {
            fix2.invoke(project, null, result.getContainingFile());
        }
    }

    @NotNull
    public static List<PsiGenerationInfo<PsiMethod>> overrideOrImplementMethods(@NotNull PsiClass aClass, @NotNull Collection<? extends PsiMethodMember> candidates, boolean toCopyJavaDoc, boolean toInsertAtOverride) throws IncorrectOperationException {
        List candidateInfos = ContainerUtil.map2List(candidates, s -> new CandidateInfo(s.getElement(), s.getSubstitutor()));
        List<PsiMethod> methods = OverrideImplementUtil.overrideOrImplementMethodCandidates(aClass, candidateInfos, toCopyJavaDoc, toInsertAtOverride);
        return OverrideImplementUtil.convert2GenerationInfos(methods);
    }

    @NotNull
    public static List<PsiMethod> overrideOrImplementMethodCandidates(@NotNull PsiClass aClass, @NotNull Collection<? extends CandidateInfo> candidates, boolean toCopyJavaDoc, boolean insertOverrideWherePossible) throws IncorrectOperationException {
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        for (CandidateInfo candidateInfo : candidates) {
            result.addAll(OverrideImplementUtil.overrideOrImplementMethod(aClass, (PsiMethod)candidateInfo.getElement(), candidateInfo.getSubstitutor(), toCopyJavaDoc, insertOverrideWherePossible));
        }
        return result;
    }

    @NotNull
    public static List<PsiGenerationInfo<PsiMethod>> convert2GenerationInfos(@NotNull Collection<? extends PsiMethod> methods) {
        return ContainerUtil.map2List(methods, s -> OverrideImplementUtil.createGenerationInfo(s));
    }

    @NotNull
    public static PsiGenerationInfo<PsiMethod> createGenerationInfo(@NotNull PsiMethod s) {
        return OverrideImplementUtil.createGenerationInfo(s, true);
    }

    @NotNull
    private static PsiGenerationInfo<PsiMethod> createGenerationInfo(@NotNull PsiMethod s, boolean mergeIfExists) {
        for (MethodImplementor implementor : OverrideImplementUtil.getImplementors()) {
            GenerationInfo info = implementor.createGenerationInfo(s, mergeIfExists);
            if (!(info instanceof PsiGenerationInfo)) continue;
            PsiGenerationInfo psiGenerationInfo = (PsiGenerationInfo)info;
            return psiGenerationInfo;
        }
        return new PsiGenerationInfo<PsiMethod>(s);
    }

    @NotNull
    private static String callSuper(@NotNull PsiMethod superMethod, @NotNull PsiMethod overriding) {
        return OverrideImplementUtil.callSuper(superMethod, overriding, true);
    }

    @NotNull
    private static String callSuper(@NotNull PsiMethod superMethod, @NotNull PsiMethod overriding, boolean prependReturn) {
        StringBuilder buffer = new StringBuilder();
        if (prependReturn && !superMethod.isConstructor() && !PsiType.VOID.equals((Object)superMethod.getReturnType())) {
            buffer.append("return ");
        }
        buffer.append("super");
        PsiParameter[] parameters2 = overriding.getParameterList().getParameters();
        if (!superMethod.isConstructor()) {
            buffer.append(".");
            buffer.append(superMethod.getName());
        }
        buffer.append("(");
        for (int i = 0; i < parameters2.length; ++i) {
            String name = parameters2[i].getName();
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(name);
        }
        buffer.append(")");
        return buffer.toString();
    }

    public static void setupMethodBody(@NotNull PsiMethod result, @NotNull PsiMethod originalMethod, @NotNull PsiClass targetClass) throws IncorrectOperationException {
        boolean isAbstract = originalMethod.hasModifierProperty("abstract") || originalMethod.hasModifierProperty("default");
        String templateName = isAbstract ? "Implemented Method Body.java" : "Overridden Method Body.java";
        FileTemplate template = FileTemplateManager.getInstance((Project)originalMethod.getProject()).getCodeTemplate(templateName);
        OverrideImplementUtil.setupMethodBody(result, originalMethod, targetClass, template);
    }

    public static void setupMethodBody(@NotNull PsiMethod result, @NotNull PsiMethod originalMethod, @NotNull PsiClass targetClass, @NotNull FileTemplate template) throws IncorrectOperationException {
        PsiMethod m;
        String methodText;
        if (targetClass.isInterface()) {
            if (OverrideImplementUtil.isImplementInterfaceInJava8Interface(targetClass) || originalMethod.hasModifierProperty("default")) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)result, (String)"default", (boolean)true);
            } else {
                PsiCodeBlock body2 = result.getBody();
                if (body2 != null) {
                    body2.delete();
                }
            }
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByExtension(template.getExtension());
        PsiType returnType = result.getReturnType();
        if (returnType == null) {
            returnType = PsiType.VOID;
        }
        Properties properties = FileTemplateManager.getInstance((Project)targetClass.getProject()).getDefaultProperties();
        properties.setProperty("RETURN_TYPE", returnType.getPresentableText());
        properties.setProperty("DEFAULT_RETURN_VALUE", PsiTypesUtil.getDefaultValueOfType((PsiType)returnType, (boolean)true));
        properties.setProperty("CALL_SUPER", OverrideImplementUtil.callSuper(originalMethod, result));
        properties.setProperty("PLAIN_CALL_SUPER", OverrideImplementUtil.callSuper(originalMethod, result, false));
        JavaTemplateUtil.setClassAndMethodNameProperties(properties, targetClass, result);
        JVMElementFactory factory = JVMElementFactories.getFactory((Language)targetClass.getLanguage(), (Project)originalMethod.getProject());
        if (factory == null) {
            factory = JavaPsiFacade.getElementFactory((Project)originalMethod.getProject());
        }
        try {
            methodText = "void foo () {\n" + template.getText(properties) + "\n}";
            methodText = FileTemplateUtil.indent((String)methodText, (Project)result.getProject(), (FileType)fileType);
        }
        catch (Exception e) {
            throw new IncorrectOperationException("Failed to parse file template", (Throwable)e);
        }
        try {
            m = factory.createMethodFromText(methodText, (PsiElement)originalMethod);
        }
        catch (IncorrectOperationException e) {
            ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((String)CodeInsightBundle.message((String)"override.implement.broken.file.template.message", (Object[])new Object[0]), (String)CodeInsightBundle.message((String)"override.implement.broken.file.template.title", (Object[])new Object[0])));
            return;
        }
        PsiCodeBlock oldBody = result.getBody();
        if (oldBody != null) {
            oldBody.replace((PsiElement)m.getBody());
        }
    }

    private static boolean isImplementInterfaceInJava8Interface(@NotNull PsiClass targetClass) {
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)targetClass)) {
            return false;
        }
        String commandName = CommandProcessor.getInstance().getCurrentCommandName();
        return commandName != null && StringUtil.containsIgnoreCase((String)commandName, (String)IMPLEMENT_COMMAND_MARKER);
    }

    public static void chooseAndOverrideMethods(Project project, Editor editor, PsiClass aClass) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.overrideimplement");
        OverrideImplementUtil.chooseAndOverrideOrImplementMethods(project, editor, aClass, false);
    }

    public static void chooseAndImplementMethods(Project project, Editor editor, PsiClass aClass) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.overrideimplement");
        OverrideImplementUtil.chooseAndOverrideOrImplementMethods(project, editor, aClass, true);
    }

    public static void chooseAndOverrideOrImplementMethods(Project project, Editor editor, @NotNull PsiClass aClass, boolean toImplement) {
        LOG.assertTrue(aClass.isValid());
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection<CandidateInfo> candidates = OverrideImplementUtil.getMethodsToOverrideImplement(aClass, toImplement);
        ArrayList secondary = toImplement || aClass.isInterface() ? ContainerUtil.newArrayList() : OverrideImplementUtil.getMethodsToOverrideImplement(aClass, true);
        MemberChooser<PsiMethodMember> chooser = OverrideImplementUtil.showOverrideImplementChooser(editor, (PsiElement)aClass, toImplement, candidates, secondary);
        if (chooser == null) {
            return;
        }
        List selectedElements = chooser.getSelectedElements();
        if (selectedElements == null || selectedElements.isEmpty()) {
            return;
        }
        LOG.assertTrue(aClass.isValid());
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{aClass.getContainingFile()}).run(() -> OverrideImplementUtil.overrideOrImplementMethodsInRightPlace(editor, aClass, selectedElements, chooser.isCopyJavadoc(), chooser.isInsertOverrideAnnotation()));
    }

    @Nullable
    public static MemberChooser<PsiMethodMember> showOverrideImplementChooser(@NotNull Editor editor, @NotNull PsiElement aClass, boolean toImplement, @NotNull Collection<CandidateInfo> candidates, @NotNull Collection<CandidateInfo> secondary) {
        JavaOverrideImplementMemberChooser chooser;
        if (toImplement) {
            Iterator<CandidateInfo> iterator = candidates.iterator();
            while (iterator.hasNext()) {
                CandidateInfo candidate = iterator.next();
                PsiElement element = candidate.getElement();
                if (!(element instanceof PsiMethod) || !((PsiMethod)element).hasModifierProperty("default")) continue;
                iterator.remove();
                secondary.add(candidate);
            }
        }
        if ((chooser = JavaOverrideImplementMemberChooser.create(aClass, toImplement, candidates, secondary)) == null) {
            return null;
        }
        Project project = aClass.getProject();
        OverrideImplementUtil.registerHandlerForComplementaryAction(project, editor, aClass, toImplement, chooser);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return chooser;
        }
        chooser.show();
        if (chooser.getExitCode() != 0) {
            return null;
        }
        return chooser;
    }

    private static void registerHandlerForComplementaryAction(final @NotNull Project project, final @NotNull Editor editor, final @NotNull PsiElement aClass, final boolean toImplement, final @NotNull MemberChooser<PsiMethodMember> chooser) {
        String s;
        JComponent preferredFocusedComponent = chooser.getPreferredFocusedComponent();
        Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
        Shortcut[] shortcuts = keymap.getShortcuts(s = toImplement ? "OverrideMethods" : "ImplementMethods");
        if (shortcuts.length > 0 && shortcuts[0] instanceof KeyboardShortcut) {
            preferredFocusedComponent.getInputMap().put(((KeyboardShortcut)shortcuts[0]).getFirstKeyStroke(), s);
            preferredFocusedComponent.getActionMap().put(s, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    chooser.close(1);
                    TransactionGuard.getInstance().submitTransactionLater((Disposable)project, () -> {
                        OverrideMethodsHandler handler = toImplement ? new OverrideMethodsHandler() : new ImplementMethodsHandler();
                        handler.invoke(project, editor, aClass.getContainingFile());
                    });
                }
            });
        }
    }

    public static void overrideOrImplementMethodsInRightPlace(@NotNull Editor editor, @NotNull PsiClass aClass, @NotNull Collection<? extends PsiMethodMember> candidates, boolean copyJavadoc, boolean insertOverrideWherePossible) {
        try {
            List<Object> resultMembers;
            int lbraceOffset;
            int offset = editor.getCaretModel().getOffset();
            PsiElement brace = aClass.getLBrace();
            if (brace == null) {
                PsiClass psiClass = JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createClass("X");
                brace = aClass.addRangeAfter(psiClass.getLBrace(), psiClass.getRBrace(), aClass.getLastChild());
                LOG.assertTrue(brace != null, (Object)aClass.getLastChild());
            }
            if (offset <= (lbraceOffset = brace.getTextOffset()) || aClass.isEnum()) {
                resultMembers = new ArrayList();
                for (PsiMethodMember psiMethodMember : candidates) {
                    List<PsiMethod> prototypes = OverrideImplementUtil.overrideOrImplementMethod(aClass, (PsiMethod)psiMethodMember.getElement(), psiMethodMember.getSubstitutor(), copyJavadoc, insertOverrideWherePossible);
                    List<PsiGenerationInfo<PsiMethod>> infos = OverrideImplementUtil.convert2GenerationInfos(prototypes);
                    for (PsiGenerationInfo<PsiMethod> info : infos) {
                        PsiElement anchor = OverrideImplementUtil.getDefaultAnchorToOverrideOrImplement(aClass, (PsiMethod)psiMethodMember.getElement(), psiMethodMember.getSubstitutor());
                        info.insert(aClass, anchor, true);
                        resultMembers.add(info);
                    }
                }
            } else {
                List<PsiGenerationInfo<PsiMethod>> prototypes = OverrideImplementUtil.overrideOrImplementMethods(aClass, candidates, copyJavadoc, insertOverrideWherePossible);
                resultMembers = GenerateMembersUtil.insertMembersAtOffset(aClass, offset, prototypes);
            }
            if (!resultMembers.isEmpty()) {
                ((PsiGenerationInfo)resultMembers.get(0)).positionCaret(editor, true);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    public static PsiElement getDefaultAnchorToOverrideOrImplement(@NotNull PsiClass aClass, @NotNull PsiMethod baseMethod, @NotNull PsiSubstitutor substitutor) {
        PsiMethod prevBaseMethod = (PsiMethod)PsiTreeUtil.getPrevSiblingOfType((PsiElement)baseMethod, PsiMethod.class);
        while (prevBaseMethod != null) {
            MethodSignature signature;
            PsiMethod prevMethod;
            String name;
            String string = name = prevBaseMethod.isConstructor() ? aClass.getName() : prevBaseMethod.getName();
            if (name != null && (prevMethod = MethodSignatureUtil.findMethodBySignature((PsiClass)aClass, (MethodSignature)(signature = MethodSignatureUtil.createMethodSignature((String)name, (PsiParameterList)prevBaseMethod.getParameterList(), (PsiTypeParameterList)prevBaseMethod.getTypeParameterList(), (PsiSubstitutor)substitutor, (boolean)prevBaseMethod.isConstructor())), (boolean)false)) != null && prevMethod.isPhysical()) {
                return prevMethod.getNextSibling();
            }
            prevBaseMethod = (PsiMethod)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prevBaseMethod, PsiMethod.class);
        }
        PsiMethod nextBaseMethod = (PsiMethod)PsiTreeUtil.getNextSiblingOfType((PsiElement)baseMethod, PsiMethod.class);
        while (nextBaseMethod != null) {
            MethodSignature signature;
            PsiMethod nextMethod;
            String name;
            String string = name = nextBaseMethod.isConstructor() ? aClass.getName() : nextBaseMethod.getName();
            if (name != null && (nextMethod = MethodSignatureUtil.findMethodBySignature((PsiClass)aClass, (MethodSignature)(signature = MethodSignatureUtil.createMethodSignature((String)name, (PsiParameterList)nextBaseMethod.getParameterList(), (PsiTypeParameterList)nextBaseMethod.getTypeParameterList(), (PsiSubstitutor)substitutor, (boolean)nextBaseMethod.isConstructor())), (boolean)false)) != null && nextMethod.isPhysical()) {
                return nextMethod;
            }
            nextBaseMethod = (PsiMethod)PsiTreeUtil.getNextSiblingOfType((PsiElement)nextBaseMethod, PsiMethod.class);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<PsiGenerationInfo<PsiMethod>> overrideOrImplement(@NotNull PsiClass psiClass, @NotNull PsiMethod baseMethod) throws IncorrectOperationException {
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)baseMethod.getProject());
        List<Object> results = new ArrayList();
        try {
            List<PsiGenerationInfo<PsiMethod>> prototypes = OverrideImplementUtil.convert2GenerationInfos(OverrideImplementUtil.overrideOrImplementMethod(psiClass, baseMethod, false));
            if (prototypes.isEmpty()) {
                List<PsiGenerationInfo<PsiMethod>> list = Collections.emptyList();
                return list;
            }
            PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)baseMethod.getContainingClass(), (PsiClass)psiClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiElement anchor = OverrideImplementUtil.getDefaultAnchorToOverrideOrImplement(psiClass, baseMethod, substitutor);
            List<Object> list = results = GenerateMembersUtil.insertMembersBeforeAnchor(psiClass, anchor, prototypes);
            return list;
        }
        finally {
            PsiFile psiFile = psiClass.getContainingFile();
            Editor editor = fileEditorManager.openTextEditor(new OpenFileDescriptor(psiFile.getProject(), psiFile.getVirtualFile()), true);
            if (editor != null && !results.isEmpty()) {
                ((PsiGenerationInfo)results.get(0)).positionCaret(editor, true);
                editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
            }
        }
    }

    @Nullable
    public static PsiClass getContextClass(Project project, @NotNull Editor editor, @NotNull PsiFile file, boolean allowInterface) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        while ((element = PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class)) instanceof PsiTypeParameter) {
        }
        PsiClass aClass = (PsiClass)element;
        if (aClass instanceof PsiSyntheticClass) {
            return null;
        }
        return aClass == null || !allowInterface && aClass.isInterface() ? null : aClass;
    }

    public static void overrideOrImplementMethodsInRightPlace(@NotNull Editor editor, @NotNull PsiClass aClass, @NotNull Collection<? extends PsiMethodMember> members, boolean copyJavadoc) {
        boolean insert = JavaCodeStyleSettings.getInstance((PsiFile)aClass.getContainingFile()).INSERT_OVERRIDE_ANNOTATION;
        OverrideImplementUtil.overrideOrImplementMethodsInRightPlace(editor, aClass, members, copyJavadoc, insert);
    }

    @NotNull
    public static List<PsiMethod> overrideOrImplementMethodCandidates(@NotNull PsiClass aClass, @NotNull Collection<? extends CandidateInfo> candidatesToImplement, boolean copyJavadoc) throws IncorrectOperationException {
        boolean insert = JavaCodeStyleSettings.getInstance((PsiFile)aClass.getContainingFile()).INSERT_OVERRIDE_ANNOTATION;
        return OverrideImplementUtil.overrideOrImplementMethodCandidates(aClass, candidatesToImplement, copyJavadoc, insert);
    }
}

