/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.generation.OverrideImplementsAnnotationsHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OverrideImplementsAnnotationsHandlerImpl
implements OverrideImplementsAnnotationsHandler {
    @Override
    public String[] getAnnotations(Project project) {
        List<String> annotations2 = OverrideImplementsAnnotationsHandlerImpl.getCoreAnnotations(project);
        CodeStyleSettings settings = CodeStyle.getSettings((Project)project);
        annotations2.addAll(((JavaCodeStyleSettings)settings.getCustomSettings(JavaCodeStyleSettings.class)).getRepeatAnnotations());
        return ArrayUtil.toStringArray(annotations2);
    }

    @Override
    public String[] getAnnotations(@NotNull PsiFile file) {
        List<String> annotations2 = OverrideImplementsAnnotationsHandlerImpl.getCoreAnnotations(file.getProject());
        annotations2.addAll(JavaCodeStyleSettings.getInstance(file).getRepeatAnnotations());
        return ArrayUtil.toStringArray(annotations2);
    }

    @NotNull
    private static List<String> getCoreAnnotations(Project project) {
        ArrayList<String> annotations2 = new ArrayList<String>();
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)project);
        annotations2.addAll(manager.getNotNulls());
        annotations2.addAll(manager.getNullables());
        annotations2.add("org.jetbrains.annotations.Nls");
        return annotations2;
    }
}

