/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.guess.impl;

import com.intellij.codeInsight.JavaPsiEquivalenceUtil;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.DfaFactMap;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.value.DfaInstanceofValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ExpressionTypeMemoryState
extends DfaMemoryStateImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.guess.impl.ExpressionTypeMemoryState");
    public static final TObjectHashingStrategy<PsiExpression> EXPRESSION_HASHING_STRATEGY = new TObjectHashingStrategy<PsiExpression>(){

        public int computeHashCode(PsiExpression object) {
            if (object instanceof PsiReferenceExpression) {
                return Objects.hashCode(((PsiReferenceExpression)object).getReferenceName()) * 31 + 1;
            }
            if (object instanceof PsiMethodCallExpression) {
                return Objects.hashCode(((PsiMethodCallExpression)object).getMethodExpression().getReferenceName()) * 31 + 2;
            }
            return object.getNode().getElementType().hashCode();
        }

        public boolean equals(@NotNull PsiExpression o1, @NotNull PsiExpression o2) {
            if (JavaPsiEquivalenceUtil.areExpressionsEquivalent(o1, o2)) {
                if (this.computeHashCode(o1) != this.computeHashCode(o2)) {
                    LOG.error("different hashCodes: " + o1 + "; " + o2 + "; " + this.computeHashCode(o1) + "!=" + this.computeHashCode(o2));
                }
                return true;
            }
            return false;
        }
    };
    private final boolean myHonorAssignments;
    private MultiMap<PsiExpression, PsiType> myStates;

    public ExpressionTypeMemoryState(DfaValueFactory factory, boolean honorAssignments) {
        super(factory);
        this.myHonorAssignments = honorAssignments;
        this.myStates = MultiMap.createSet(EXPRESSION_HASHING_STRATEGY);
    }

    private ExpressionTypeMemoryState(ExpressionTypeMemoryState toCopy) {
        super(toCopy);
        this.myHonorAssignments = toCopy.myHonorAssignments;
        this.myStates = toCopy.myStates;
    }

    @Override
    protected DfaFactMap filterFactsOnAssignment(DfaVariableValue var, @NotNull DfaFactMap facts) {
        if (this.myHonorAssignments) {
            return facts;
        }
        if (ControlFlowAnalyzer.isTempVariable(var) || var.getPsiVariable() instanceof PsiParameter && var.getPsiVariable().getParent().getParent() instanceof PsiLambdaExpression) {
            return facts;
        }
        return facts.with(DfaFactType.TYPE_CONSTRAINT, null);
    }

    @Override
    @NotNull
    public DfaMemoryStateImpl createCopy() {
        return new ExpressionTypeMemoryState(this);
    }

    @Override
    public boolean isSuperStateOf(DfaMemoryStateImpl that) {
        if (!super.isSuperStateOf(that)) {
            return false;
        }
        MultiMap<PsiExpression, PsiType> thatStates = ((ExpressionTypeMemoryState)that).myStates;
        if (thatStates == this.myStates) {
            return true;
        }
        for (Map.Entry entry : this.myStates.entrySet()) {
            Collection thisTypes = (Collection)entry.getValue();
            Collection thatTypes = thatStates.get(entry.getKey());
            if (thatTypes.containsAll(thisTypes)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean applyCondition(DfaValue dfaCond) {
        if (dfaCond instanceof DfaInstanceofValue) {
            DfaInstanceofValue value2 = (DfaInstanceofValue)dfaCond;
            if (!value2.isNegated()) {
                this.setExpressionType(value2.getExpression(), value2.getCastType());
            }
            return super.applyCondition(((DfaInstanceofValue)dfaCond).getRelation());
        }
        return super.applyCondition(dfaCond);
    }

    MultiMap<PsiExpression, PsiType> getStates() {
        return this.myStates;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExpressionTypeMemoryState that = (ExpressionTypeMemoryState)o;
        return this.myStates.equals(that.myStates);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myStates.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return super.toString() + " states=[" + this.myStates + "]";
    }

    void removeExpressionType(@NotNull PsiExpression expression2) {
        if (this.myStates.containsKey((Object)expression2)) {
            MultiMap<PsiExpression, PsiType> oldStates = this.myStates;
            this.myStates = MultiMap.createSet(EXPRESSION_HASHING_STRATEGY);
            for (Map.Entry entry : oldStates.entrySet()) {
                if (EXPRESSION_HASHING_STRATEGY.equals(entry.getKey(), (Object)expression2)) continue;
                this.myStates.putValues(entry.getKey(), (Collection)entry.getValue());
            }
        }
    }

    void setExpressionType(@NotNull PsiExpression expression2, @NotNull PsiType type2) {
        if (!this.myStates.get((Object)expression2).contains(type2)) {
            MultiMap<PsiExpression, PsiType> oldStates = this.myStates;
            this.myStates = MultiMap.createSet(EXPRESSION_HASHING_STRATEGY);
            this.myStates.putAllValues(oldStates);
            this.myStates.putValue((Object)expression2, (Object)type2);
        }
    }
}

