/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsControlFlowPolicy;
import com.intellij.util.Consumer;
import com.intellij.util.containers.IntArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class HighlightBreakOutsHandler
extends HighlightUsagesHandlerBase<PsiElement> {
    private final PsiElement myTarget;

    public HighlightBreakOutsHandler(Editor editor, PsiFile file, PsiElement target) {
        super(editor, file);
        this.myTarget = target;
    }

    public List<PsiElement> getTargets() {
        return Collections.singletonList(this.myTarget);
    }

    protected void selectTargets(List<PsiElement> targets, Consumer<List<PsiElement>> selectionConsumer) {
        selectionConsumer.consume(targets);
    }

    public void computeUsages(List<PsiElement> targets) {
        PsiElement parent = this.myTarget.getParent();
        if (parent instanceof PsiContinueStatement) {
            PsiStatement statement = ((PsiContinueStatement)parent).findContinuedStatement();
            if (statement instanceof PsiLoopStatement) {
                this.processLoop((PsiStatement)parent, (PsiLoopStatement)statement);
            }
        } else if (parent instanceof PsiBreakStatement) {
            PsiElement exitedElement = ((PsiBreakStatement)parent).findExitedElement();
            if (exitedElement instanceof PsiLoopStatement) {
                this.processLoop((PsiStatement)parent, (PsiLoopStatement)exitedElement);
            } else if (exitedElement instanceof PsiSwitchBlock) {
                this.addOccurrence(exitedElement.getFirstChild());
                this.collectSiblings((PsiStatement)parent, exitedElement, exitedElement);
            }
        }
        this.addOccurrence(this.myTarget);
    }

    private void processLoop(PsiStatement parent, PsiLoopStatement statement) {
        this.highlightLoopDeclaration(statement);
        PsiStatement body2 = statement.getBody();
        if (body2 instanceof PsiBlockStatement) {
            this.collectSiblings(parent, (PsiElement)statement, (PsiElement)((PsiBlockStatement)body2).getCodeBlock());
        }
    }

    private void collectSiblings(PsiStatement currentStatement, PsiElement container, @NotNull PsiElement block) {
        try {
            ControlFlow controlFlow = ControlFlowFactory.getInstance(block.getProject()).getControlFlow(block, new LocalsControlFlowPolicy(block), false, false);
            Collection<PsiStatement> statements = ControlFlowUtil.findExitPointsAndStatements(controlFlow, 0, controlFlow.getSize(), new IntArrayList(), ControlFlowUtil.DEFAULT_EXIT_STATEMENTS_CLASSES);
            for (PsiStatement psiStatement : statements) {
                if (currentStatement == psiStatement || (!(psiStatement instanceof PsiContinueStatement) || ((PsiContinueStatement)psiStatement).findContinuedStatement() != container) && (!(psiStatement instanceof PsiBreakStatement) || ((PsiBreakStatement)psiStatement).findExitedElement() != container)) continue;
                this.addOccurrence(psiStatement.getFirstChild());
            }
        }
        catch (AnalysisCanceledException analysisCanceledException) {
            // empty catch block
        }
    }

    private void highlightLoopDeclaration(PsiLoopStatement statement) {
        if (statement instanceof PsiDoWhileStatement) {
            PsiKeyword whileKeyword = ((PsiDoWhileStatement)statement).getWhileKeyword();
            if (whileKeyword != null) {
                this.addOccurrence((PsiElement)whileKeyword);
            }
        } else {
            this.addOccurrence(statement.getFirstChild());
        }
    }
}

