/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.HighlightImportedElementsHandler;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactoryBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiKeyword;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightImportedElementsHandlerFactory
extends HighlightUsagesHandlerFactoryBase {
    @Nullable
    public HighlightUsagesHandlerBase createHighlightUsagesHandler(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement target) {
        if (!(target instanceof PsiKeyword) || !"import".equals(target.getText())) {
            return null;
        }
        PsiElement parent = target.getParent();
        if (!(parent instanceof PsiImportStatementBase)) {
            return null;
        }
        PsiElement grand = parent.getParent();
        if (!(grand instanceof PsiImportList)) {
            return null;
        }
        return new HighlightImportedElementsHandler(editor, file, target, (PsiImportStatementBase)parent);
    }
}

