/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.HighlightUsagesDescriptionLocation;
import com.intellij.lang.LangBundle;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import org.jetbrains.annotations.NotNull;

public class JavaHighlightUsagesDescriptionProvider
implements ElementDescriptionProvider {
    private static final int METHOD_FLAGS = 4353;
    private static final int VARIABLE_FLAGS = 4097;

    public String getElementDescription(@NotNull PsiElement element, @NotNull ElementDescriptionLocation location) {
        if (!(location instanceof HighlightUsagesDescriptionLocation)) {
            return null;
        }
        String elementName = null;
        if (element instanceof PsiClass) {
            elementName = ((PsiClass)element).getQualifiedName();
            if (elementName == null) {
                elementName = ((PsiClass)element).getName();
            }
            elementName = LangBundle.message((String)(((PsiClass)element).isInterface() ? "java.terms.interface" : "java.terms.class"), (Object[])new Object[0]) + ' ' + elementName;
        } else if (element instanceof PsiMethod) {
            elementName = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)element), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4353, (int)2);
            elementName = LangBundle.message((String)"java.terms.method", (Object[])new Object[0]) + ' ' + elementName;
        } else if (element instanceof PsiVariable) {
            elementName = PsiFormatUtil.formatVariable((PsiVariable)((PsiVariable)element), (int)4097, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            elementName = element instanceof PsiField ? LangBundle.message((String)"java.terms.field", (Object[])new Object[0]) + ' ' + elementName : (element instanceof PsiParameter ? LangBundle.message((String)"java.terms.parameter", (Object[])new Object[0]) + ' ' + elementName : LangBundle.message((String)"java.terms.variable", (Object[])new Object[0]) + ' ' + elementName);
        } else if (element instanceof PsiPackage) {
            elementName = ((PsiPackage)element).getQualifiedName();
            elementName = LangBundle.message((String)"java.terms.package", (Object[])new Object[0]) + ' ' + elementName;
        }
        return elementName;
    }
}

