/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.DfaFactMap;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.lang.ExpressionTypeProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaTypeProvider
extends ExpressionTypeProvider<PsiExpression> {
    @NotNull
    public String getInformationHint(@NotNull PsiExpression element) {
        PsiType type2 = element.getType();
        if (type2 instanceof PsiLambdaExpressionType) {
            type2 = ((PsiLambdaExpressionType)type2).getExpression().getFunctionalInterfaceType();
        } else if (type2 instanceof PsiMethodReferenceType) {
            type2 = ((PsiMethodReferenceType)type2).getExpression().getFunctionalInterfaceType();
        }
        String text2 = type2 == null ? "<unknown>" : type2.getPresentableText();
        return StringUtil.escapeXmlEntities((String)text2);
    }

    @NotNull
    public String getErrorHint() {
        return "No expression found";
    }

    @NotNull
    public List<PsiExpression> getExpressionsAt(@NotNull PsiElement elementAt) {
        return SyntaxTraverser.psiApi().parents((Object)elementAt).filter(PsiExpression.class).filter(JavaTypeProvider::isLargestNonTrivialExpression).toList();
    }

    private static boolean isLargestNonTrivialExpression(@NotNull PsiExpression e) {
        PsiElement p = e.getParent();
        if (p instanceof PsiUnaryExpression) {
            return false;
        }
        return !(p instanceof PsiMethodCallExpression) || ((PsiMethodCallExpression)p).getMethodExpression() != e;
    }

    public boolean hasAdvancedInformation() {
        return true;
    }

    @NotNull
    public String getAdvancedInformationHint(@NotNull PsiExpression expression2) {
        if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) == null) {
            return "<unknown>";
        }
        CommonDataflow.DataflowResult result = CommonDataflow.getDataflowResult(expression2);
        DfaFactMap map2 = result == null ? null : result.getAllFacts(expression2);
        String basicTypeEscaped = this.getInformationHint(expression2);
        final PsiType type2 = expression2.getType();
        String advancedTypeInfo = map2 == null ? "" : map2.facts(new DfaFactMap.FactMapper<String>(){

            @Override
            public <T> String apply(DfaFactType<T> factType, T value2) {
                return JavaTypeProvider.formatFact(factType, value2, type2);
            }
        }).joining();
        return advancedTypeInfo.isEmpty() ? basicTypeEscaped : "<table>" + JavaTypeProvider.makeHtmlRow("Type", basicTypeEscaped) + advancedTypeInfo + "</table>";
    }

    private static <T> String formatFact(@NotNull DfaFactType<T> factType, @NotNull T value2, @Nullable PsiType type2) {
        String presentationText = factType.getPresentationText(value2, type2);
        return presentationText.isEmpty() ? "" : JavaTypeProvider.makeHtmlRow(factType.getName(value2), StringUtil.escapeXmlEntities((String)presentationText));
    }

    private static String makeHtmlRow(@NotNull String titleText, String contentHtml) {
        String titleCell = "<td align='left' valign='top' style='color:" + ColorUtil.toHtmlColor((Color)DocumentationComponent.SECTION_COLOR) + "'>" + StringUtil.escapeXmlEntities((String)titleText) + ":</td>";
        String contentCell = "<td>" + contentHtml + "</td>";
        return "<tr>" + titleCell + contentCell + "</tr>";
    }
}

