/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint.api.impls;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.tree.IElementType;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ReferenceParameterInfoHandler
implements ParameterInfoHandler<PsiReferenceParameterList, PsiTypeParameter> {
    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        return null;
    }

    public boolean couldShowInLookup() {
        return false;
    }

    public PsiReferenceParameterList findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        PsiReferenceParameterList referenceParameterList = (PsiReferenceParameterList)ParameterInfoUtils.findParentOfType((PsiFile)context.getFile(), (int)context.getOffset(), PsiReferenceParameterList.class);
        if (referenceParameterList != null) {
            if (!(referenceParameterList.getParent() instanceof PsiJavaCodeReferenceElement)) {
                return null;
            }
            PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)referenceParameterList.getParent();
            PsiElement psiElement = ref.resolve();
            if (!(psiElement instanceof PsiTypeParameterListOwner)) {
                return null;
            }
            Object[] typeParams = ((PsiTypeParameterListOwner)psiElement).getTypeParameters();
            if (typeParams.length == 0) {
                return null;
            }
            context.setItemsToShow(typeParams);
            return referenceParameterList;
        }
        return null;
    }

    public void showParameterInfo(@NotNull PsiReferenceParameterList element, @NotNull CreateParameterInfoContext context) {
        context.showHint((PsiElement)element, element.getTextRange().getStartOffset() + 1, (ParameterInfoHandler)this);
    }

    public PsiReferenceParameterList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        return (PsiReferenceParameterList)ParameterInfoUtils.findParentOfType((PsiFile)context.getFile(), (int)context.getOffset(), PsiReferenceParameterList.class);
    }

    public void updateParameterInfo(@NotNull PsiReferenceParameterList parameterOwner, @NotNull UpdateParameterInfoContext context) {
        int index = ParameterInfoUtils.getCurrentParameterIndex((ASTNode)parameterOwner.getNode(), (int)context.getOffset(), (IElementType)JavaTokenType.COMMA);
        context.setCurrentParameter(index);
        Object[] objectsToView = context.getObjectsToView();
        context.setHighlightedParameter(index < objectsToView.length && index >= 0 ? (PsiElement)objectsToView[index] : null);
    }

    public void updateUI(PsiTypeParameter o, @NotNull ParameterInfoUIContext context) {
        ReferenceParameterInfoHandler.updateTypeParameter(o, context);
    }

    private static void updateTypeParameter(PsiTypeParameter typeParameter, ParameterInfoUIContext context) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(typeParameter.getName());
        int highlightEndOffset = buffer.length();
        buffer.append(" extends ");
        buffer.append(StringUtil.join(Arrays.asList(typeParameter.getSuperTypes()), t -> t.getPresentableText(), (String)", "));
        context.setupUIComponentPresentation(buffer.toString(), 0, highlightEndOffset, false, false, false, context.getDefaultParameterColor());
    }
}

