/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.daemon.impl.analysis.AnnotationsHighlightUtil;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddAnnotationPsiFix
extends LocalQuickFixOnPsiElement {
    protected final String myAnnotation;
    private final String[] myAnnotationsToRemove;
    private final PsiNameValuePair[] myPairs;
    protected final String myText;

    public AddAnnotationPsiFix(@NotNull String fqn, @NotNull PsiModifierListOwner modifierListOwner, @NotNull PsiNameValuePair[] values, String ... annotationsToRemove) {
        super((PsiElement)modifierListOwner);
        this.myAnnotation = fqn;
        ObjectUtils.assertAllElementsNotNull((Object[])values);
        this.myPairs = values;
        ObjectUtils.assertAllElementsNotNull((Object[])annotationsToRemove);
        this.myAnnotationsToRemove = annotationsToRemove;
        this.myText = AddAnnotationPsiFix.calcText(modifierListOwner, this.myAnnotation);
    }

    public static String calcText(PsiModifierListOwner modifierListOwner, @Nullable String annotation) {
        String name;
        String shortName;
        String string = shortName = annotation == null ? null : annotation.substring(annotation.lastIndexOf(46) + 1);
        if (modifierListOwner instanceof PsiNamedElement && (name = ((PsiNamedElement)modifierListOwner).getName()) != null) {
            String type2 = LanguageFindUsages.getType((PsiElement)modifierListOwner);
            if (shortName == null) {
                return CodeInsightBundle.message((String)"inspection.i18n.quickfix.annotate.element", (Object[])new Object[]{type2, name});
            }
            return CodeInsightBundle.message((String)"inspection.i18n.quickfix.annotate.element.as", (Object[])new Object[]{type2, name, shortName});
        }
        if (shortName == null) {
            return CodeInsightBundle.message((String)"inspection.i18n.quickfix.annotate", (Object[])new Object[0]);
        }
        return CodeInsightBundle.message((String)"inspection.i18n.quickfix.annotate.as", (Object[])new Object[]{shortName});
    }

    @Nullable
    public static PsiModifierListOwner getContainer(PsiFile file, int offset) {
        PsiElement id;
        PsiElement target;
        PsiReference reference = file.findReferenceAt(offset);
        if (reference != null && (target = reference.resolve()) instanceof PsiMember) {
            return (PsiMember)target;
        }
        PsiElement element = file.findElementAt(offset);
        PsiModifierListOwner listOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PsiModifierListOwner.class, (boolean)false);
        if (listOwner instanceof PsiParameter) {
            return listOwner;
        }
        if (listOwner instanceof PsiNameIdentifierOwner && (id = ((PsiNameIdentifierOwner)listOwner).getNameIdentifier()) != null && id.getTextRange().containsOffset(offset)) {
            return listOwner;
        }
        return null;
    }

    @NotNull
    public String getText() {
        return this.myText;
    }

    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"intention.add.annotation.family", (Object[])new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        return AddAnnotationPsiFix.isAvailable((PsiModifierListOwner)startElement, this.myAnnotation);
    }

    public static boolean isAvailable(@NotNull PsiModifierListOwner modifierListOwner, @NotNull String annotationFQN) {
        if (!modifierListOwner.isValid()) {
            return false;
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)modifierListOwner)) {
            return false;
        }
        PsiModifierList modifierList = modifierListOwner.getModifierList();
        return modifierList != null && !(modifierList instanceof LightElement) && !(modifierListOwner instanceof LightElement) && !AnnotationUtil.isAnnotated((PsiModifierListOwner)modifierListOwner, (String)annotationFQN, (int)10);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiModifierListOwner myModifierListOwner = (PsiModifierListOwner)startElement;
        ExternalAnnotationsManager annotationsManager = ExternalAnnotationsManager.getInstance((Project)project);
        PsiModifierList modifierList = myModifierListOwner.getModifierList();
        if (modifierList == null || modifierList.hasAnnotation(this.myAnnotation)) {
            return;
        }
        PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(this.myAnnotation, myModifierListOwner.getResolveScope());
        ExternalAnnotationsManager.AnnotationPlace annotationAnnotationPlace = aClass != null && BaseIntentionAction.canModify((PsiElement)myModifierListOwner) && AnnotationsHighlightUtil.getRetentionPolicy(aClass) == RetentionPolicy.RUNTIME ? ExternalAnnotationsManager.AnnotationPlace.IN_CODE : annotationsManager.chooseAnnotationsPlace((PsiElement)myModifierListOwner);
        if (annotationAnnotationPlace == ExternalAnnotationsManager.AnnotationPlace.NOWHERE) {
            return;
        }
        if (annotationAnnotationPlace == ExternalAnnotationsManager.AnnotationPlace.EXTERNAL) {
            for (String fqn : this.myAnnotationsToRemove) {
                annotationsManager.deannotate(myModifierListOwner, fqn);
            }
            try {
                annotationsManager.annotateExternally(myModifierListOwner, this.myAnnotation, file, this.myPairs);
            }
            catch (ExternalAnnotationsManager.CanceledConfigurationException canceledConfigurationException) {}
        } else {
            PsiFile containingFile = myModifierListOwner.getContainingFile();
            WriteCommandAction.runWriteCommandAction((Project)project, null, null, () -> {
                AddAnnotationPsiFix.removePhysicalAnnotations(myModifierListOwner, this.myAnnotationsToRemove);
                PsiAnnotation inserted = AddAnnotationPsiFix.addPhysicalAnnotation(this.myAnnotation, this.myPairs, modifierList);
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)inserted);
            }, (PsiFile[])new PsiFile[]{containingFile});
            if (containingFile != file) {
                UndoUtil.markPsiFileForUndo((PsiFile)file);
            }
        }
    }

    public static PsiAnnotation addPhysicalAnnotation(String fqn, PsiNameValuePair[] pairs, PsiModifierList modifierList) {
        PsiAnnotation inserted = modifierList.addAnnotation(fqn);
        for (PsiNameValuePair pair : pairs) {
            inserted.setDeclaredAttributeValue(pair.getName(), pair.getValue());
        }
        return inserted;
    }

    public static void removePhysicalAnnotations(@NotNull PsiModifierListOwner owner, String ... fqns) {
        for (String fqn : fqns) {
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (boolean)true, (String[])new String[]{fqn});
            if (annotation == null || AnnotationUtil.isInferredAnnotation((PsiAnnotation)annotation)) continue;
            annotation.delete();
        }
    }

    @NotNull
    protected String[] getAnnotationsToRemove() {
        return this.myAnnotationsToRemove;
    }

    public static boolean isNullabilityAnnotationApplicable(@NotNull PsiModifierListOwner owner) {
        if (owner instanceof PsiMethod) {
            PsiType returnType = ((PsiMethod)owner).getReturnType();
            return returnType != null && !(returnType instanceof PsiPrimitiveType);
        }
        return !(owner instanceof PsiClass);
    }

    @Nullable
    public static AddAnnotationPsiFix createAddNullableFix(PsiModifierListOwner owner) {
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)owner.getProject());
        return AddAnnotationPsiFix.createAddNullableNotNullFix(owner, manager.getDefaultNullable(), manager.getNotNulls());
    }

    @Nullable
    public static AddAnnotationPsiFix createAddNotNullFix(PsiModifierListOwner owner) {
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)owner.getProject());
        return AddAnnotationPsiFix.createAddNullableNotNullFix(owner, manager.getDefaultNotNull(), manager.getNullables());
    }

    @Nullable
    private static AddAnnotationPsiFix createAddNullableNotNullFix(PsiModifierListOwner owner, String annotationToAdd, List<String> annotationsToRemove) {
        if (!AddAnnotationPsiFix.isNullabilityAnnotationApplicable(owner)) {
            return null;
        }
        return new AddAnnotationPsiFix(annotationToAdd, owner, PsiNameValuePair.EMPTY_ARRAY, ArrayUtil.toStringArray(annotationsToRemove));
    }
}

