/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.editorActions.FixDocCommentAction;
import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.ide.util.PackageUtil;
import com.intellij.lang.java.JavaDocumentationProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class AddJavadocIntention
extends BaseElementAtCaretIntentionAction
implements LowPriorityAction {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        FixDocCommentAction.generateOrFixComment((PsiElement)element, (Project)project, (Editor)editor);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (element instanceof PsiIdentifier || element instanceof PsiJavaCodeReferenceElement || element instanceof PsiJavaModuleReferenceElement) {
            PsiElement targetElement = PsiTreeUtil.skipParentsOfType((PsiElement)element, (Class[])new Class[]{PsiIdentifier.class, PsiJavaCodeReferenceElement.class, PsiJavaModuleReferenceElement.class});
            if (targetElement instanceof PsiVariable && PsiTreeUtil.isAncestor((PsiElement)((PsiVariable)targetElement).getInitializer(), (PsiElement)element, (boolean)false)) {
                return false;
            }
            if (targetElement instanceof PsiJavaDocumentedElement && !(targetElement instanceof PsiTypeParameter) && !(targetElement instanceof PsiAnonymousClass)) {
                return ((PsiJavaDocumentedElement)targetElement).getDocComment() == null;
            }
            if (targetElement instanceof PsiPackageStatement) {
                PsiFile file = targetElement.getContainingFile();
                return PackageUtil.isPackageInfoFile((PsiElement)file) && JavaDocumentationProvider.getPackageInfoComment((PsiElement)file) == null;
            }
            if (PackageUtil.isPackageInfoFile(targetElement)) {
                return JavaDocumentationProvider.getPackageInfoComment(targetElement) == null;
            }
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        return "Add Javadoc";
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }
}

