/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ExternalAnnotationsManagerImpl;
import com.intellij.codeInsight.externalAnnotation.AnnotationProvider;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import one.util.streamex.MoreCollectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class AnnotateIntentionAction
extends BaseIntentionAction
implements LowPriorityAction {
    private AnnotationProvider myAnnotationProvider;
    private boolean mySingleMode;

    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"intention.add.annotation.family", (Object[])new Object[0]);
    }

    private static StreamEx<AnnotationProvider> availableAnnotations(PsiModifierListOwner owner, Project project) {
        return (StreamEx)((StreamEx)StreamEx.of((Collection)AnnotationProvider.KEY.getExtensionList()).filter(p -> p.isAvailable(owner))).filter(p -> !AnnotateIntentionAction.alreadyAnnotated(owner, p, project));
    }

    public boolean selectSingle(Editor editor, PsiFile file, String annotationShortName) {
        if (this.mySingleMode) {
            throw new IllegalStateException();
        }
        this.mySingleMode = true;
        PsiModifierListOwner owner = AddAnnotationPsiFix.getContainer(file, editor.getCaretModel().getOffset());
        if (owner == null || owner.getModifierList() == null || !ExternalAnnotationsManagerImpl.areExternalAnnotationsApplicable(owner)) {
            return false;
        }
        Optional provider = (Optional)((StreamEx)AnnotateIntentionAction.availableAnnotations(owner, file.getProject()).filter(p -> StringUtil.getShortName((String)p.getName(file.getProject())).equals(annotationShortName))).collect(MoreCollectors.onlyOne());
        this.myAnnotationProvider = provider.orElse(null);
        return provider.isPresent();
    }

    private static boolean alreadyAnnotated(PsiModifierListOwner owner, AnnotationProvider p, Project project) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (String[])((String[])ArrayUtil.prepend((Object)p.getName(owner.getProject()), (Object[])p.getAnnotationsToRemove(project))));
        return annotation != null && !AnnotationUtil.isInferredAnnotation((PsiAnnotation)annotation);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiModifierListOwner owner = AddAnnotationPsiFix.getContainer(file, editor.getCaretModel().getOffset());
        if (owner == null || owner.getModifierList() == null || !ExternalAnnotationsManagerImpl.areExternalAnnotationsApplicable(owner)) {
            return false;
        }
        if (this.mySingleMode) {
            return this.myAnnotationProvider != null && AnnotateIntentionAction.availableAnnotations(owner, project).has((Object)this.myAnnotationProvider);
        }
        List annotations2 = (List)((StreamEx)AnnotateIntentionAction.availableAnnotations(owner, project).limit(2L)).collect(Collectors.toList());
        if (annotations2.isEmpty()) {
            return false;
        }
        if (annotations2.size() == 1) {
            this.myAnnotationProvider = (AnnotationProvider)annotations2.get(0);
            this.setText(AddAnnotationPsiFix.calcText(owner, this.myAnnotationProvider.getName(project)));
        } else {
            this.myAnnotationProvider = null;
            this.setText(AddAnnotationPsiFix.calcText(owner, null));
        }
        return true;
    }

    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file) throws IncorrectOperationException {
        final PsiModifierListOwner owner = AddAnnotationPsiFix.getContainer(file, editor.getCaretModel().getOffset());
        assert (owner != null);
        if (this.myAnnotationProvider != null) {
            if (AnnotateIntentionAction.alreadyAnnotated(owner, this.myAnnotationProvider, project)) {
                return;
            }
            AddAnnotationFix fix2 = new AddAnnotationFix(this.myAnnotationProvider.getName(project), owner, this.myAnnotationProvider.getAnnotationsToRemove(project));
            fix2.invoke(project, editor, file);
        } else {
            List annotations2 = (List)AnnotateIntentionAction.availableAnnotations(owner, project).collect(Collectors.toList());
            if (annotations2.isEmpty()) {
                return;
            }
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<AnnotationProvider>(CodeInsightBundle.message((String)"annotate.intention.chooser.title", (Object[])new Object[0]), annotations2){

                public PopupStep onChosen(AnnotationProvider selectedValue, boolean finalChoice) {
                    return this.doFinalStep(() -> new AddAnnotationFix(selectedValue.getName(project), owner, selectedValue.getAnnotationsToRemove(project)).invoke(project, editor, file));
                }

                public boolean isSpeedSearchEnabled() {
                    return true;
                }

                @NotNull
                public String getTextFor(AnnotationProvider value2) {
                    return value2.getName(project);
                }
            }).showInBestPositionFor(editor);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

