/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.intention.impl.FieldFromParameterUtils;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssignFieldFromParameterAction
extends BaseIntentionAction {
    private static final Logger LOG = Logger.getInstance(AssignFieldFromParameterAction.class);

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiClass targetClass;
        PsiType type2;
        PsiParameter myParameter = FieldFromParameterUtils.findParameterAtCursor(file, editor);
        if (!FieldFromParameterUtils.isAvailable(myParameter, type2 = FieldFromParameterUtils.getType(myParameter), targetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)myParameter, PsiClass.class))) {
            return false;
        }
        PsiField field = AssignFieldFromParameterAction.findFieldToAssign(project, myParameter);
        if (field == null || type2 == null || !field.getType().isAssignableFrom(type2)) {
            return false;
        }
        if (!field.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
            return false;
        }
        PsiElement scope = myParameter.getDeclarationScope();
        if (scope instanceof PsiMethod && field.hasModifierProperty("final")) {
            PsiMethod method = (PsiMethod)scope;
            if (!method.isConstructor()) {
                return false;
            }
            if (!JavaHighlightUtil.getChainedConstructors(method).isEmpty()) {
                return false;
            }
            PsiCodeBlock body2 = method.getBody();
            LOG.assertTrue(body2 != null);
            try {
                ControlFlow flow = ControlFlowFactory.getInstance(project).getControlFlow((PsiElement)body2, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
                if (!ControlFlowUtil.isVariableDefinitelyNotAssigned((PsiVariable)field, flow)) {
                    return false;
                }
            }
            catch (AnalysisCanceledException analysisCanceledException) {
                // empty catch block
            }
        }
        this.setText(CodeInsightBundle.message((String)"intention.assign.field.from.parameter.text", (Object[])new Object[]{field.getName()}));
        return true;
    }

    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"intention.assign.field.from.parameter.family", (Object[])new Object[0]);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        PsiParameter myParameter = FieldFromParameterUtils.findParameterAtCursor(file, editor);
        IdeDocumentHistory.getInstance((Project)project).includeCurrentPlaceAsChangePlace();
        PsiField field = AssignFieldFromParameterAction.findFieldToAssign(project, myParameter);
        if (field != null) {
            AssignFieldFromParameterAction.addFieldAssignmentStatement(project, field, myParameter, editor);
        }
    }

    @Nullable
    private static PsiField findFieldToAssign(@NotNull Project project, @NotNull PsiParameter myParameter) {
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project);
        String parameterName = myParameter.getName();
        String propertyName = styleManager.variableNameToPropertyName(parameterName, VariableKind.PARAMETER);
        PsiMethod method = (PsiMethod)myParameter.getDeclarationScope();
        boolean isMethodStatic = method.hasModifierProperty("static");
        VariableKind kind2 = isMethodStatic ? VariableKind.STATIC_FIELD : VariableKind.FIELD;
        SuggestedNameInfo suggestedNameInfo = styleManager.suggestVariableName(kind2, propertyName, null, FieldFromParameterUtils.getSubstitutedType(myParameter));
        String fieldName = suggestedNameInfo.names[0];
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return null;
        }
        PsiField field = aClass.findFieldByName(fieldName, false);
        if (field == null) {
            return null;
        }
        if (!field.hasModifierProperty("static") && isMethodStatic) {
            return null;
        }
        return field;
    }

    public static PsiElement addFieldAssignmentStatement(@NotNull Project project, @NotNull PsiField field, @NotNull PsiParameter parameter2, @NotNull Editor editor) throws IncorrectOperationException {
        PsiMethod method = (PsiMethod)parameter2.getDeclarationScope();
        PsiCodeBlock methodBody2 = method.getBody();
        if (methodBody2 == null) {
            return null;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        String fieldName = field.getName();
        String parameterName = parameter2.getName();
        boolean isMethodStatic = method.hasModifierProperty("static");
        PsiClass targetClass = method.getContainingClass();
        if (targetClass == null) {
            return null;
        }
        String stmtText = fieldName + " = " + parameterName + ";";
        if (Comparing.strEqual((String)fieldName, (String)parameterName) || JavaPsiFacade.getInstance((Project)project).getResolveHelper().resolveReferencedVariable(fieldName, (PsiElement)methodBody2) != field) {
            String prefix = isMethodStatic ? (targetClass.getName() == null ? "" : targetClass.getName() + ".") : "this.";
            stmtText = prefix + stmtText;
        }
        PsiStatement assignmentStmt = (PsiStatement)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)factory.createStatementFromText(stmtText, (PsiElement)methodBody2));
        PsiStatement[] statements = methodBody2.getStatements();
        int i = FieldFromParameterUtils.findFieldAssignmentAnchor(statements, null, targetClass, parameter2);
        PsiElement inserted = i == statements.length ? methodBody2.add((PsiElement)assignmentStmt) : methodBody2.addAfter((PsiElement)assignmentStmt, i > 0 ? statements[i - 1] : null);
        editor.getCaretModel().moveToOffset(inserted.getTextRange().getEndOffset());
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        return inserted;
    }
}

