/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.JavaPsiConstructorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseMoveInitializerToMethodAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (element instanceof PsiCompiledElement) {
            return false;
        }
        PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class, (boolean)false, (Class[])new Class[]{PsiMember.class, PsiCodeBlock.class, PsiDocComment.class});
        if (field == null || this.hasUnsuitableModifiers(field)) {
            return false;
        }
        if (field.getLanguage() != JavaLanguage.INSTANCE) {
            return false;
        }
        PsiExpression initializer = field.getInitializer();
        if (initializer == null || initializer.getNextSibling() instanceof PsiErrorElement) {
            return false;
        }
        PsiClass psiClass = field.getContainingClass();
        return psiClass != null && !psiClass.isInterface() && !(psiClass instanceof PsiAnonymousClass) && !(psiClass instanceof PsiSyntheticClass);
    }

    private boolean hasUnsuitableModifiers(@NotNull PsiField field) {
        for (String modifier : this.getUnsuitableModifiers()) {
            if (!field.hasModifierProperty(modifier)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected abstract Collection<String> getUnsuitableModifiers();

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class);
        assert (field != null);
        PsiClass aClass = field.getContainingClass();
        if (aClass == null) {
            return;
        }
        Collection<PsiMethod> methodsToAddInitialization = this.getOrCreateMethods(project, editor, element.getContainingFile(), aClass);
        if (methodsToAddInitialization.isEmpty()) {
            return;
        }
        List<PsiExpressionStatement> assignments = BaseMoveInitializerToMethodAction.addFieldAssignments(field, methodsToAddInitialization);
        PsiExpression initializer = field.getInitializer();
        if (initializer != null) {
            initializer.delete();
        }
        if (!assignments.isEmpty()) {
            BaseMoveInitializerToMethodAction.highlightRExpression((PsiAssignmentExpression)assignments.get(0).getExpression(), project, editor);
        }
    }

    private static void highlightRExpression(@NotNull PsiAssignmentExpression assignment, @NotNull Project project, Editor editor) {
        EditorColorsManager manager = EditorColorsManager.getInstance();
        TextAttributes attributes = manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        PsiExpression expression2 = assignment.getRExpression();
        HighlightManager.getInstance((Project)project).addOccurrenceHighlights(editor, new PsiElement[]{expression2}, attributes, false, null);
    }

    @NotNull
    private static List<PsiExpressionStatement> addFieldAssignments(@NotNull PsiField field, @NotNull Collection<PsiMethod> methods) {
        ArrayList<PsiExpressionStatement> assignments = new ArrayList<PsiExpressionStatement>();
        for (PsiMethod method : methods) {
            assignments.add(BaseMoveInitializerToMethodAction.addAssignment(BaseMoveInitializerToMethodAction.getOrCreateMethodBody(method), field));
        }
        return assignments;
    }

    @NotNull
    private static PsiCodeBlock getOrCreateMethodBody(@NotNull PsiMethod method) {
        PsiCodeBlock codeBlock = method.getBody();
        if (codeBlock == null) {
            CreateFromUsageUtils.setupMethodBody(method);
            codeBlock = method.getBody();
        }
        return codeBlock;
    }

    @NotNull
    protected abstract Collection<PsiMethod> getOrCreateMethods(@NotNull Project var1, @NotNull Editor var2, PsiFile var3, @NotNull PsiClass var4);

    @NotNull
    private static PsiExpressionStatement addAssignment(@NotNull PsiCodeBlock codeBlock, @NotNull PsiField field) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)codeBlock.getProject());
        PsiExpressionStatement statement = (PsiExpressionStatement)factory.createStatementFromText(field.getName() + " = y;", (PsiElement)codeBlock);
        PsiExpression initializer = field.getInitializer();
        initializer = RefactoringUtil.convertInitializerToNormalExpression(initializer, field.getType());
        PsiAssignmentExpression expression2 = (PsiAssignmentExpression)statement.getExpression();
        Objects.requireNonNull(expression2.getRExpression()).replace((PsiElement)Objects.requireNonNull(initializer));
        PsiElement newStatement = codeBlock.addBefore((PsiElement)statement, BaseMoveInitializerToMethodAction.findFirstFieldUsage(codeBlock.getStatements(), field));
        BaseMoveInitializerToMethodAction.replaceWithQualifiedReferences(newStatement, newStatement, factory);
        return (PsiExpressionStatement)newStatement;
    }

    @Nullable
    private static PsiElement findFirstFieldUsage(@NotNull PsiStatement[] statements, @NotNull PsiField field) {
        for (PsiStatement blockStatement : statements) {
            if (BaseMoveInitializerToMethodAction.isSuperOrThisMethodCall(blockStatement) || !BaseMoveInitializerToMethodAction.containsReference((PsiElement)blockStatement, field)) continue;
            return blockStatement;
        }
        return null;
    }

    private static boolean isSuperOrThisMethodCall(@NotNull PsiStatement statement) {
        if (statement instanceof PsiExpressionStatement) {
            PsiExpression expression2 = ((PsiExpressionStatement)statement).getExpression();
            return JavaPsiConstructorUtil.isConstructorCall((PsiElement)expression2);
        }
        return false;
    }

    private static boolean containsReference(@NotNull PsiElement element, final @NotNull PsiField field) {
        final Ref result = new Ref((Object)Boolean.FALSE);
        element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                if (expression2.resolve() == field) {
                    result.set((Object)Boolean.TRUE);
                }
                super.visitReferenceExpression(expression2);
            }
        });
        return (Boolean)result.get();
    }

    private static void replaceWithQualifiedReferences(@NotNull PsiElement expression2, @NotNull PsiElement root, @NotNull PsiElementFactory factory) throws IncorrectOperationException {
        PsiReference reference = expression2.getReference();
        if (reference == null) {
            for (PsiElement child : expression2.getChildren()) {
                BaseMoveInitializerToMethodAction.replaceWithQualifiedReferences(child, root, factory);
            }
            return;
        }
        PsiElement resolved = reference.resolve();
        if (resolved instanceof PsiVariable && !(resolved instanceof PsiField) && !PsiTreeUtil.isAncestor((PsiElement)root, (PsiElement)resolved, (boolean)false)) {
            PsiVariable variable = (PsiVariable)resolved;
            PsiExpression qualifiedExpr = factory.createExpressionFromText("this." + variable.getName(), expression2);
            expression2.replace((PsiElement)qualifiedExpr);
        }
    }
}

