/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ComposeFunctionChainAction
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)ComposeFunctionChainAction.class.getName());

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class, (boolean)false, (Class[])new Class[]{PsiStatement.class, PsiLambdaExpression.class});
        if (call == null) {
            return false;
        }
        if (!"apply".equals(call.getMethodExpression().getReferenceName())) {
            return false;
        }
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return false;
        }
        if (!"java.util.function.Function".equals(aClass.getQualifiedName()) && !"java.util.function.BiFunction".equals(aClass.getQualifiedName())) {
            return false;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent());
        if (!(parent instanceof PsiExpressionList) || ((PsiExpressionList)parent).getExpressionCount() != 1) {
            return false;
        }
        PsiElement gParent = parent.getParent();
        if (!(gParent instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethod outerMethod = ((PsiMethodCallExpression)gParent).resolveMethod();
        return outerMethod != null && Arrays.stream(outerMethod.getThrowsList().getReferencedTypes()).allMatch(ExceptionUtil::isUncheckedException);
    }

    @NotNull
    public String getText() {
        return CodeInsightBundle.message((String)"intention.compose.function.text", (Object[])new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"intention.compose.function.family", (Object[])new Object[0]);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class, (boolean)false, (Class[])new Class[]{PsiStatement.class, PsiLambdaExpression.class});
        if (call == null) {
            return;
        }
        PsiElement outer = call.getParent().getParent();
        if (!(outer instanceof PsiMethodCallExpression)) {
            return;
        }
        PsiMethodCallExpression outerCall = (PsiMethodCallExpression)outer;
        PsiMethod outerMethod = outerCall.resolveMethod();
        if (outerMethod == null) {
            return;
        }
        PsiClass outerClass = outerMethod.getContainingClass();
        if (outerClass == null) {
            return;
        }
        String outerClassName = outerClass.getQualifiedName();
        PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
        PsiExpression outerQualifier = outerCall.getMethodExpression().getQualifierExpression();
        CommentTracker ct = new CommentTracker();
        String reference = outerMethod.getName().equals("apply") && "java.util.function.Function".equals(outerClassName) ? (outerQualifier == null ? "this" : ct.text((PsiElement)outerQualifier)) : (outerMethod.hasModifierProperty("static") ? outerClassName + "::" + outerMethod.getName() : (outerQualifier == null ? "this" : ct.text((PsiElement)outerQualifier) + "::" + outerMethod.getName()));
        String resultQualifier = qualifier != null ? ct.text((PsiElement)qualifier) + "." : "";
        String replacement = resultQualifier + "andThen(" + reference + ").apply" + ct.text((PsiElement)call.getArgumentList());
        PsiElement result = ct.replaceAndRestoreComments(outer, replacement);
        result = CodeStyleManager.getInstance((Project)project).reformat(result);
        PsiElement applyElement = ((PsiMethodCallExpression)result).getMethodExpression().getReferenceNameElement();
        if (applyElement != null) {
            editor.getCaretModel().moveToOffset(applyElement.getTextOffset() + applyElement.getTextLength());
        }
    }
}

