/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertCompareToToEqualsIntention
extends BaseElementAtCaretIntentionAction {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        CompareToResult compareToResult = CompareToResult.findCompareTo(element);
        assert (compareToResult != null);
        PsiExpression qualifier = compareToResult.getQualifier();
        PsiExpression argument = compareToResult.getArgument();
        StringBuilder text2 = new StringBuilder();
        if (!compareToResult.isEqEq()) {
            text2.append('!');
        }
        if (qualifier != null) {
            text2.append(qualifier.getText()).append('.');
        }
        text2.append("equals(").append(argument.getText()).append(')');
        PsiExpression newExpression = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(text2.toString(), null);
        PsiElement result = compareToResult.getBinaryExpression().replace((PsiElement)newExpression);
        editor.getCaretModel().moveToOffset(result.getTextOffset() + result.getTextLength());
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        return CompareToResult.findCompareTo(element) != null;
    }

    @NotNull
    public String getFamilyName() {
        return "Convert 'compareTo()' expression to 'equals()' call";
    }

    @NotNull
    public String getText() {
        return "Convert 'compareTo()' expression to 'equals()' call (may change semantics)";
    }

    private static class CompareToResult {
        private final PsiBinaryExpression myBinaryExpression;
        private final PsiMethodCallExpression myCompareToCall;

        private CompareToResult(PsiBinaryExpression binaryExpression, PsiMethodCallExpression compareToCall) {
            this.myBinaryExpression = binaryExpression;
            this.myCompareToCall = compareToCall;
        }

        public PsiBinaryExpression getBinaryExpression() {
            return this.myBinaryExpression;
        }

        public boolean isEqEq() {
            return JavaTokenType.EQEQ.equals(this.myBinaryExpression.getOperationTokenType());
        }

        public PsiExpression getArgument() {
            return this.myCompareToCall.getArgumentList().getExpressions()[0];
        }

        public PsiExpression getQualifier() {
            return this.myCompareToCall.getMethodExpression().getQualifierExpression();
        }

        @Nullable
        static CompareToResult findCompareTo(PsiElement element) {
            PsiMethodCallExpression compareToExpression;
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiBinaryExpression.class);
            if (binaryExpression == null) {
                return null;
            }
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (!JavaTokenType.NE.equals(tokenType) && !JavaTokenType.EQEQ.equals(tokenType)) {
                return null;
            }
            PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)binaryExpression.getLOperand());
            PsiExpression rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)binaryExpression.getROperand());
            if (lhs instanceof PsiMethodCallExpression) {
                compareToExpression = (PsiMethodCallExpression)lhs;
                if (!MethodCallUtils.isCompareToCall(compareToExpression) || !ExpressionUtils.isZero(rhs)) {
                    return null;
                }
            } else if (rhs instanceof PsiMethodCallExpression) {
                compareToExpression = (PsiMethodCallExpression)rhs;
                if (!ExpressionUtils.isZero(lhs) || !MethodCallUtils.isCompareToCall(compareToExpression)) {
                    return null;
                }
            } else {
                return null;
            }
            return new CompareToResult(binaryExpression, compareToExpression);
        }
    }
}

