/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeannotateIntentionAction
implements IntentionAction,
LowPriorityAction {
    private static final Logger LOG = Logger.getInstance(DeannotateIntentionAction.class);
    private String myAnnotationName;

    @NotNull
    public String getText() {
        return CodeInsightBundle.message((String)"deannotate.intention.action.text", (Object[])new Object[0]) + (this.myAnnotationName != null ? " @" + this.myAnnotationName : "...");
    }

    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"deannotate.intention.action.text", (Object[])new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        ExternalAnnotationsManager externalAnnotationsManager;
        PsiAnnotation[] annotations2;
        this.myAnnotationName = null;
        PsiModifierListOwner listOwner = DeannotateIntentionAction.getContainer(editor, file);
        if (listOwner != null && (annotations2 = (externalAnnotationsManager = ExternalAnnotationsManager.getInstance((Project)project)).findExternalAnnotations(listOwner)) != null && annotations2.length > 0) {
            List files;
            if (annotations2.length == 1) {
                this.myAnnotationName = annotations2[0].getQualifiedName();
            }
            if ((files = externalAnnotationsManager.findExternalAnnotationsFiles(listOwner)) == null || files.isEmpty()) {
                return false;
            }
            VirtualFile virtualFile = ((PsiFile)files.get(0)).getVirtualFile();
            return virtualFile != null && (virtualFile.isWritable() || virtualFile.isInLocalFileSystem());
        }
        return false;
    }

    @Nullable
    public static PsiModifierListOwner getContainer(Editor editor, PsiFile file) {
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        PsiModifierListOwner listOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PsiParameter.class, (boolean)false);
        if (listOwner == null) {
            PsiIdentifier psiIdentifier = (PsiIdentifier)PsiTreeUtil.getParentOfType((PsiElement)element, PsiIdentifier.class, (boolean)false);
            if (psiIdentifier != null && psiIdentifier.getParent() instanceof PsiModifierListOwner) {
                listOwner = (PsiModifierListOwner)psiIdentifier.getParent();
            } else {
                PsiExpression expression2 = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiExpression.class);
                if (expression2 != null) {
                    PsiParameter[] parameters2;
                    PsiMethod method;
                    PsiElement grParent;
                    int idx;
                    PsiMethod psiMethod;
                    while (expression2.getParent() instanceof PsiExpression && !((expression2 = (PsiExpression)expression2.getParent()) instanceof PsiAssignmentExpression)) {
                    }
                    if (expression2 instanceof PsiMethodCallExpression && (psiMethod = ((PsiMethodCallExpression)expression2).resolveMethod()) != null) {
                        return psiMethod;
                    }
                    PsiElement parent = expression2.getParent();
                    if (parent instanceof PsiExpressionList && (idx = ArrayUtil.indexOf((Object[])((PsiExpressionList)parent).getExpressions(), (Object)expression2)) > -1 && (grParent = parent.getParent()) instanceof PsiCall && (method = ((PsiCall)grParent).resolveMethod()) != null && (parameters2 = method.getParameterList().getParameters()).length > idx) {
                        return parameters2[idx];
                    }
                }
            }
        }
        return listOwner;
    }

    public void invoke(final @NotNull Project project, Editor editor, final PsiFile file) throws IncorrectOperationException {
        final PsiModifierListOwner listOwner = DeannotateIntentionAction.getContainer(editor, file);
        LOG.assertTrue(listOwner != null);
        final ExternalAnnotationsManager annotationsManager = ExternalAnnotationsManager.getInstance((Project)project);
        PsiAnnotation[] externalAnnotations = annotationsManager.findExternalAnnotations(listOwner);
        LOG.assertTrue(externalAnnotations != null && externalAnnotations.length > 0);
        if (externalAnnotations.length == 1) {
            this.deannotate(externalAnnotations[0], project, file, annotationsManager, listOwner);
            return;
        }
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<PsiAnnotation>(CodeInsightBundle.message((String)"deannotate.intention.chooser.title", (Object[])new Object[0]), externalAnnotations){

            public PopupStep onChosen(PsiAnnotation selectedValue, boolean finalChoice) {
                DeannotateIntentionAction.this.deannotate(selectedValue, project, file, annotationsManager, listOwner);
                return PopupStep.FINAL_CHOICE;
            }

            @NotNull
            public String getTextFor(PsiAnnotation value2) {
                String qualifiedName = value2.getQualifiedName();
                LOG.assertTrue(qualifiedName != null);
                return qualifiedName;
            }
        }).showInBestPositionFor(editor);
    }

    private void deannotate(PsiAnnotation annotation, Project project, PsiFile file, ExternalAnnotationsManager annotationsManager, PsiModifierListOwner listOwner) {
        WriteCommandAction.writeCommandAction((Project)project).withName(this.getText()).run(() -> {
            VirtualFile virtualFile = file.getVirtualFile();
            String qualifiedName = annotation.getQualifiedName();
            LOG.assertTrue(qualifiedName != null);
            if (annotationsManager.deannotate(listOwner, qualifiedName) && virtualFile != null && virtualFile.isInLocalFileSystem()) {
                UndoUtil.markPsiFileForUndo((PsiFile)file);
            }
        });
    }

    public boolean startInWriteAction() {
        return false;
    }
}

