/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.util.ImportsUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExpandStaticImportAction
extends BaseElementAtCaretIntentionAction {
    private static final String REPLACE_THIS_OCCURRENCE = "Replace this occurrence and keep the import";
    private static final String REPLACE_ALL_AND_DELETE_IMPORT = "Replace all and delete the import";

    @NotNull
    public String getFamilyName() {
        return "Expand static import";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)element)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(element instanceof PsiIdentifier) || !(parent instanceof PsiJavaCodeReferenceElement)) {
            return false;
        }
        PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)parent;
        PsiElement resolveScope = ExpandStaticImportAction.getImportStaticStatement(referenceElement);
        if (resolveScope instanceof PsiImportStaticStatement) {
            PsiClass targetClass = ((PsiImportStaticStatement)resolveScope).resolveTargetClass();
            if (targetClass == null) {
                return false;
            }
            this.setText("Replace static import with qualified access to " + targetClass.getName());
            return true;
        }
        return false;
    }

    private static PsiElement getImportStaticStatement(PsiJavaCodeReferenceElement referenceElement) {
        PsiElement parent = referenceElement.getParent();
        return parent instanceof PsiImportStaticStatement ? parent : referenceElement.advancedResolve(true).getCurrentFileResolveScope();
    }

    public void invoke(final Project project, PsiFile file, Editor editor, PsiElement element) {
        PsiImportStaticStatement staticImport;
        final PsiJavaCodeReferenceElement refExpr = (PsiJavaCodeReferenceElement)element.getParent();
        final List expressionToExpand = ImportsUtil.collectReferencesThrough((PsiFile)file, (PsiJavaCodeReferenceElement)refExpr, (PsiImportStaticStatement)(staticImport = (PsiImportStaticStatement)ExpandStaticImportAction.getImportStaticStatement(refExpr)));
        if (expressionToExpand.isEmpty()) {
            ImportsUtil.expand((PsiJavaCodeReferenceElement)refExpr, (PsiImportStaticStatement)staticImport);
            staticImport.delete();
        } else if (ApplicationManager.getApplication().isUnitTestMode() || refExpr.getParent() instanceof PsiImportStaticStatement) {
            ImportsUtil.replaceAllAndDeleteImport((List)expressionToExpand, (PsiJavaCodeReferenceElement)refExpr, (PsiImportStaticStatement)staticImport);
        } else {
            BaseListPopupStep<String> step2 = new BaseListPopupStep<String>("Multiple Usages of the Static Import Found", new String[]{REPLACE_THIS_OCCURRENCE, REPLACE_ALL_AND_DELETE_IMPORT}){

                public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                    WriteCommandAction.writeCommandAction((Project)project).withName(ExpandStaticImportAction.this.getText()).run(() -> {
                        if (selectedValue == ExpandStaticImportAction.REPLACE_THIS_OCCURRENCE) {
                            ImportsUtil.expand((PsiJavaCodeReferenceElement)refExpr, (PsiImportStaticStatement)staticImport);
                        } else {
                            ImportsUtil.replaceAllAndDeleteImport((List)expressionToExpand, (PsiJavaCodeReferenceElement)refExpr, (PsiImportStaticStatement)staticImport);
                        }
                    });
                    return FINAL_CHOICE;
                }
            };
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)step2).showInBestPositionFor(editor);
        }
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        this.invoke(project, element.getContainingFile(), editor, element);
    }
}

