/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.chainCall.ChainCallExtractor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ExtractChainedMapAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiLocalVariable variable = (PsiLocalVariable)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLocalVariable.class, (boolean)false, (Class[])new Class[]{PsiStatement.class, PsiLambdaExpression.class});
        if (variable == null || variable.getName() == null) {
            return false;
        }
        PsiExpression initializer = variable.getInitializer();
        if (initializer == null) {
            return false;
        }
        PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)variable.getParent(), PsiDeclarationStatement.class);
        if (declaration2 == null || declaration2.getDeclaredElements().length != 1) {
            return false;
        }
        PsiCodeBlock block = (PsiCodeBlock)ObjectUtils.tryCast((Object)declaration2.getParent(), PsiCodeBlock.class);
        if (block == null || ArrayUtil.getFirstElement((Object[])block.getStatements()) != declaration2) {
            return false;
        }
        PsiLambdaExpression lambda2 = (PsiLambdaExpression)ObjectUtils.tryCast((Object)block.getParent(), PsiLambdaExpression.class);
        ChainCallExtractor extractor = ChainCallExtractor.findExtractor(lambda2, initializer, variable.getType());
        if (extractor == null) {
            return false;
        }
        PsiParameter parameter2 = lambda2.getParameterList().getParameters()[0];
        if (ReferencesSearch.search((PsiElement)parameter2).allMatch(ref -> PsiTreeUtil.isAncestor((PsiElement)initializer, (PsiElement)ref.getElement(), (boolean)false))) {
            this.setText(CodeInsightBundle.message((String)"intention.extract.map.step.text", (Object[])new Object[]{variable.getName(), extractor.getMethodName((PsiVariable)parameter2, initializer, variable.getType())}));
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiLocalVariable variable = (PsiLocalVariable)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLocalVariable.class, (boolean)false, (Class[])new Class[]{PsiStatement.class, PsiLambdaExpression.class});
        ChainCallExtractor.extractMappingStep(project, variable);
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"intention.extract.map.step.family", (Object[])new Object[0]);
    }
}

