/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.StreamRefactoringUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineStreamMapAction
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)InlineStreamMapAction.class.getName());
    private static final Set<String> MAP_METHODS = StreamEx.of((Object[])new String[]{"map", "mapToInt", "mapToLong", "mapToDouble", "mapToObj", "boxed", "asLongStream", "asDoubleStream"}).toSet();
    public static final Set<String> NEXT_METHODS = StreamEx.of((Object[])new String[]{"flatMap", "flatMapToInt", "flatMapToLong", "flatMapToDouble", "forEach", "forEachOrdered", "anyMatch", "noneMatch", "allMatch"}).append(MAP_METHODS).toSet();

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (!(element instanceof PsiIdentifier)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiElement gParent = parent.getParent();
        if (!(gParent instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression curCall = (PsiMethodCallExpression)gParent;
        if (!InlineStreamMapAction.isMapCall(curCall)) {
            return false;
        }
        PsiMethodCallExpression nextCall = InlineStreamMapAction.getNextExpressionToMerge(curCall);
        if (nextCall == null) {
            return false;
        }
        String key2 = curCall.getArgumentList().isEmpty() || nextCall.getArgumentList().isEmpty() ? "intention.inline.map.merge.text" : "intention.inline.map.inline.text";
        this.setText(CodeInsightBundle.message((String)key2, (Object[])new Object[]{element.getText(), nextCall.getMethodExpression().getReferenceName()}));
        return true;
    }

    private static boolean isMapCall(@NotNull PsiMethodCallExpression methodCallExpression) {
        String name = methodCallExpression.getMethodExpression().getReferenceName();
        if (name == null || !MAP_METHODS.contains(name)) {
            return false;
        }
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        PsiExpression[] expressions2 = argumentList.getExpressions();
        if (!name.startsWith("map") && expressions2.length == 0) {
            return true;
        }
        if (expressions2.length != 1) {
            return false;
        }
        if (!StreamRefactoringUtil.isRefactoringCandidate(expressions2[0], true)) {
            return false;
        }
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        return InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.util.stream.BaseStream");
    }

    @Nullable
    private static PsiMethodCallExpression getNextExpressionToMerge(PsiMethodCallExpression methodCallExpression) {
        PsiMethodCallExpression nextCall = ExpressionUtils.getCallForQualifier((PsiExpression)methodCallExpression);
        if (nextCall == null) {
            return null;
        }
        String nextName = nextCall.getMethodExpression().getReferenceName();
        if (nextName == null || !NEXT_METHODS.contains(nextName) || InlineStreamMapAction.translateName(methodCallExpression, nextCall) == null) {
            return null;
        }
        PsiExpressionList argumentList = nextCall.getArgumentList();
        PsiExpression[] expressions2 = argumentList.getExpressions();
        if (expressions2.length == 0) {
            if (!(nextName.equals("boxed") || nextName.equals("asLongStream") || nextName.equals("asDoubleStream"))) {
                return null;
            }
            return nextCall;
        }
        if (expressions2.length != 1 || !StreamRefactoringUtil.isRefactoringCandidate(expressions2[0], false)) {
            return null;
        }
        return nextCall;
    }

    @Nullable
    private static String translateName(@NotNull PsiMethodCallExpression prevCall, @NotNull PsiMethodCallExpression nextCall) {
        PsiMethod nextMethod = nextCall.resolveMethod();
        if (nextMethod == null) {
            return null;
        }
        String nextName = nextMethod.getName();
        PsiMethod method = prevCall.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiClass prevClass = method.getContainingClass();
        if (prevClass == null) {
            return null;
        }
        String prevClassName = prevClass.getQualifiedName();
        if (prevClassName == null) {
            return null;
        }
        String prevName = method.getName();
        if (nextName.endsWith("Match") || nextName.startsWith("forEach")) {
            return nextName;
        }
        if (nextName.equals("map")) {
            return InlineStreamMapAction.translateMap(prevName);
        }
        if (prevName.equals("map")) {
            return InlineStreamMapAction.translateMap(nextName);
        }
        if (MAP_METHODS.contains(nextName)) {
            PsiType type2 = nextMethod.getReturnType();
            if (!(type2 instanceof PsiClassType)) {
                return null;
            }
            PsiClass nextClass = ((PsiClassType)type2).resolve();
            if (nextClass == null) {
                return null;
            }
            String nextClassName = nextClass.getQualifiedName();
            if (nextClassName == null) {
                return null;
            }
            if (prevClassName.equals(nextClassName)) {
                return "map";
            }
            switch (nextClassName) {
                case "java.util.stream.IntStream": {
                    return "mapToInt";
                }
                case "java.util.stream.LongStream": {
                    return "mapToLong";
                }
                case "java.util.stream.DoubleStream": {
                    return "mapToDouble";
                }
                case "java.util.stream.Stream": {
                    return "mapToObj";
                }
            }
            return null;
        }
        if (nextName.equals("flatMap") && prevClassName.equals("java.util.stream.Stream")) {
            return InlineStreamMapAction.mapToFlatMap(prevName);
        }
        return null;
    }

    @Contract(pure=true)
    @Nullable
    private static String mapToFlatMap(String mapMethod) {
        switch (mapMethod) {
            case "map": {
                return "flatMap";
            }
            case "mapToInt": {
                return "flatMapToInt";
            }
            case "mapToLong": {
                return "flatMapToLong";
            }
            case "mapToDouble": {
                return "flatMapToDouble";
            }
        }
        return null;
    }

    @Contract(pure=true)
    @NotNull
    private static String translateMap(String nextMethod) {
        switch (nextMethod) {
            case "boxed": {
                return "mapToObj";
            }
            case "asLongStream": {
                return "mapToLong";
            }
            case "asDoubleStream": {
                return "mapToDouble";
            }
        }
        return nextMethod;
    }

    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"intention.inline.map.family", (Object[])new Object[0]);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiElement body2;
        PsiMethodCallExpression mapCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
        if (mapCall == null) {
            return;
        }
        PsiMethodCallExpression nextCall = InlineStreamMapAction.getNextExpressionToMerge(mapCall);
        if (nextCall == null) {
            return;
        }
        PsiReferenceExpression nextRef = nextCall.getMethodExpression();
        PsiExpression nextQualifier = nextRef.getQualifierExpression();
        if (nextQualifier == null) {
            return;
        }
        String newName = InlineStreamMapAction.translateName(mapCall, nextCall);
        if (newName == null) {
            return;
        }
        PsiLambdaExpression previousLambda = InlineStreamMapAction.getLambda(mapCall);
        LOG.assertTrue(previousLambda != null);
        PsiExpression previousBody = LambdaUtil.extractSingleExpressionFromBody((PsiElement)previousLambda.getBody());
        LOG.assertTrue(previousBody != null);
        PsiLambdaExpression lambda2 = InlineStreamMapAction.getLambda(nextCall);
        LOG.assertTrue(lambda2 != null);
        CommentTracker ct = new CommentTracker();
        if (!lambda2.isPhysical()) {
            lambda2 = (PsiLambdaExpression)nextCall.getArgumentList().add((PsiElement)lambda2);
        }
        LOG.assertTrue((body2 = lambda2.getBody()) != null);
        ct.markUnchanged(body2);
        PsiParameter[] nextParameters = lambda2.getParameterList().getParameters();
        LOG.assertTrue(nextParameters.length == 1);
        PsiParameter[] prevParameters = previousLambda.getParameterList().getParameters();
        LOG.assertTrue(prevParameters.length == 1);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        for (PsiReference ref : ReferencesSearch.search((PsiElement)nextParameters[0], (SearchScope)new LocalSearchScope(body2)).findAll()) {
            PsiElement e = ref.getElement();
            PsiExpression replacement = ct.markUnchanged(previousBody);
            if (e.getParent() instanceof PsiExpression && ParenthesesUtils.areParenthesesNeeded(previousBody, (PsiExpression)e.getParent(), false)) {
                replacement = factory.createExpressionFromText("(a)", e);
                PsiExpression parenthesized = ((PsiParenthesizedExpression)replacement).getExpression();
                LOG.assertTrue(parenthesized != null);
                parenthesized.replace((PsiElement)previousBody);
            }
            ct.replace(e, (PsiElement)replacement);
        }
        ct.replace((PsiElement)lambda2.getParameterList(), (PsiElement)previousLambda.getParameterList());
        ExpressionUtils.bindReferenceTo(nextRef, newName);
        PsiExpression prevQualifier = mapCall.getMethodExpression().getQualifierExpression();
        if (prevQualifier == null) {
            ct.deleteAndRestoreComments((PsiElement)nextQualifier);
        } else {
            ct.replaceAndRestoreComments((PsiElement)nextQualifier, (PsiElement)prevQualifier);
        }
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)lambda2);
    }

    @Nullable
    private static PsiLambdaExpression getLambda(PsiMethodCallExpression call) {
        String expression2;
        String type2;
        String varName;
        PsiExpression[] expressions2 = call.getArgumentList().getExpressions();
        if (expressions2.length == 1) {
            PsiExpression expression3 = expressions2[0];
            if (expression3 instanceof PsiLambdaExpression) {
                return (PsiLambdaExpression)expression3;
            }
            if (expression3 instanceof PsiMethodReferenceExpression) {
                return LambdaRefactoringUtil.convertMethodReferenceToLambda((PsiMethodReferenceExpression)expression3, false, true);
            }
            return null;
        }
        if (expressions2.length != 0) {
            return null;
        }
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        String className = containingClass.getQualifiedName();
        if (className == null) {
            return null;
        }
        switch (className) {
            case "java.util.stream.IntStream": {
                varName = "i";
                type2 = "java.lang.Integer";
                break;
            }
            case "java.util.stream.LongStream": {
                varName = "l";
                type2 = "java.lang.Long";
                break;
            }
            case "java.util.stream.DoubleStream": {
                varName = "d";
                type2 = "java.lang.Double";
                break;
            }
            default: {
                return null;
            }
        }
        varName = JavaCodeStyleManager.getInstance((Project)call.getProject()).suggestUniqueVariableName(varName, (PsiElement)call, true);
        if ("boxed".equals(method.getName())) {
            expression2 = varName + " -> (" + type2 + ")" + varName;
        } else if ("asLongStream".equals(method.getName())) {
            expression2 = varName + " -> (long)" + varName;
        } else if ("asDoubleStream".equals(method.getName())) {
            expression2 = varName + " -> (double)" + varName;
        } else {
            return null;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)call.getProject());
        return (PsiLambdaExpression)factory.createExpressionFromText(expression2, (PsiElement)call);
    }
}

