/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.BranchingInstruction;
import com.intellij.psi.controlFlow.ConditionalGoToInstruction;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.GoToInstruction;
import com.intellij.psi.controlFlow.Instruction;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InvertIfConditionAction
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.InvertIfConditionAction");

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiElement block;
        int offset = editor.getCaretModel().getOffset();
        PsiIfStatement ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiIfStatement.class);
        if (ifStatement == null) {
            return false;
        }
        PsiExpression condition2 = ifStatement.getCondition();
        if (condition2 == null) {
            return false;
        }
        if (ifStatement.getThenBranch() == null) {
            return false;
        }
        if (SyntaxTraverser.psiTraverser((PsiElement)condition2).filter(PsiPrefixExpression.class).filter(prefixExpr -> PsiUtil.skipParenthesizedExprDown((PsiExpression)prefixExpr.getOperand()) == null).first() != null) {
            return false;
        }
        if (element instanceof PsiKeyword) {
            if (element.getParent() != ifStatement) {
                return false;
            }
            IElementType tokenType = ((PsiKeyword)element).getTokenType();
            if (tokenType != JavaTokenType.IF_KEYWORD && tokenType != JavaTokenType.ELSE_KEYWORD) {
                return false;
            }
        } else {
            TextRange condTextRange = condition2.getTextRange();
            if (condTextRange == null || !condTextRange.contains(offset)) {
                return false;
            }
        }
        if ((block = InvertIfConditionAction.findCodeBlock(ifStatement)) == null) {
            return false;
        }
        if (PsiUtil.skipParenthesizedExprDown((PsiExpression)ifStatement.getCondition()) == null) {
            return true;
        }
        ControlFlow localFlow = InvertIfConditionAction.buildControlFlow(block);
        int startThenOffset = InvertIfConditionAction.getThenOffset(localFlow, ifStatement);
        int afterIfOffset = localFlow.getEndOffset((PsiElement)ifStatement);
        return startThenOffset >= 0 && afterIfOffset >= 0;
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"intention.invert.if.condition", (Object[])new Object[0]);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiIfStatement ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiIfStatement.class);
        LOG.assertTrue(ifStatement != null);
        PsiElement block = InvertIfConditionAction.findCodeBlock(ifStatement);
        LOG.assertTrue(block != null);
        ControlFlow controlFlow = InvertIfConditionAction.buildControlFlow(block);
        ifStatement = InvertIfConditionAction.setupBranches(ifStatement, controlFlow);
        if (!ifStatement.isValid()) {
            return;
        }
        PsiExpression condition2 = Objects.requireNonNull(ifStatement.getCondition());
        CommentTracker tracker = new CommentTracker();
        String negatedCondition = BoolUtils.getNegatedExpressionText(condition2, tracker);
        tracker.replaceAndRestoreComments((PsiElement)condition2, negatedCondition);
        InvertIfConditionAction.formatIf(ifStatement);
    }

    private static void formatIf(PsiIfStatement ifStatement) throws IncorrectOperationException {
        PsiBlockStatement codeBlock1;
        Project project = ifStatement.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiElement thenBranch = Objects.requireNonNull(ifStatement.getThenBranch()).copy();
        PsiElement elseBranch = ifStatement.getElseBranch() != null ? ifStatement.getElseBranch().copy() : null;
        PsiElement condition2 = Objects.requireNonNull(ifStatement.getCondition()).copy();
        CodeStyleManager codeStyle = CodeStyleManager.getInstance((Project)project);
        PsiBlockStatement codeBlock = (PsiBlockStatement)factory.createStatementFromText("{}", (PsiElement)ifStatement);
        codeBlock = (PsiBlockStatement)codeStyle.reformat((PsiElement)codeBlock);
        ifStatement.getThenBranch().replace((PsiElement)codeBlock);
        if (elseBranch != null) {
            ifStatement.getElseBranch().replace((PsiElement)codeBlock);
        }
        ifStatement.getCondition().replace((PsiElement)factory.createExpressionFromText("true", null));
        ifStatement = (PsiIfStatement)codeStyle.reformat((PsiElement)ifStatement);
        if (!(thenBranch instanceof PsiBlockStatement)) {
            codeBlock1 = (PsiBlockStatement)Objects.requireNonNull(ifStatement.getThenBranch()).replace((PsiElement)codeBlock);
            codeBlock1 = (PsiBlockStatement)codeStyle.reformat((PsiElement)codeBlock1);
            codeBlock1.getCodeBlock().add(thenBranch);
        } else {
            Objects.requireNonNull(ifStatement.getThenBranch()).replace(thenBranch);
        }
        if (elseBranch != null) {
            if (!(elseBranch instanceof PsiBlockStatement)) {
                codeBlock1 = (PsiBlockStatement)Objects.requireNonNull(ifStatement.getElseBranch()).replace((PsiElement)codeBlock);
                codeBlock1 = (PsiBlockStatement)codeStyle.reformat((PsiElement)codeBlock1);
                codeBlock1.getCodeBlock().add(elseBranch);
            } else {
                elseBranch = Objects.requireNonNull(ifStatement.getElseBranch()).replace(elseBranch);
                if (InvertIfConditionAction.emptyBlock(((PsiBlockStatement)elseBranch).getCodeBlock())) {
                    PsiElement parent = ifStatement.getParent();
                    if (parent instanceof PsiIfStatement && ((PsiIfStatement)parent).getElseBranch() != null) {
                        ifStatement = (PsiIfStatement)InvertIfConditionAction.wrapWithCodeBlock((PsiStatement)ifStatement);
                    }
                    new CommentTracker().deleteAndRestoreComments((PsiElement)Objects.requireNonNull(ifStatement.getElseBranch()));
                }
            }
        }
        Objects.requireNonNull(ifStatement.getCondition()).replace(condition2);
    }

    private static boolean emptyBlock(PsiCodeBlock block) {
        PsiElement[] children;
        for (PsiElement child : children = block.getChildren()) {
            if (child instanceof PsiComment) {
                return false;
            }
            if (child instanceof PsiWhiteSpace || child instanceof PsiJavaToken) continue;
            return false;
        }
        return true;
    }

    private static PsiElement findCodeBlock(PsiIfStatement ifStatement) {
        PsiElement e = PsiTreeUtil.getParentOfType((PsiElement)ifStatement, (Class[])new Class[]{PsiMethod.class, PsiClassInitializer.class, PsiLambdaExpression.class});
        if (e instanceof PsiMethod) {
            return ((PsiMethod)e).getBody();
        }
        if (e instanceof PsiLambdaExpression) {
            return ((PsiLambdaExpression)e).getBody();
        }
        if (e instanceof PsiClassInitializer) {
            return ((PsiClassInitializer)e).getBody();
        }
        return null;
    }

    @NotNull
    private static ControlFlow buildControlFlow(@Nullable PsiElement element) {
        if (element == null) {
            return ControlFlow.EMPTY;
        }
        try {
            return ControlFlowFactory.getInstance(element.getProject()).getControlFlow(element, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
        }
        catch (AnalysisCanceledException e) {
            return ControlFlow.EMPTY;
        }
    }

    private static PsiIfStatement setupBranches(PsiIfStatement ifStatement, ControlFlow flow) throws IncorrectOperationException {
        PsiElement parent;
        boolean nextUnreachable;
        PsiElement element;
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)ifStatement.getProject());
        Project project = ifStatement.getProject();
        CommentTracker ct = new CommentTracker();
        PsiStatement thenBranch = Objects.requireNonNull(ifStatement.getThenBranch());
        PsiStatement elseBranch = ifStatement.getElseBranch();
        if (elseBranch != null) {
            elseBranch = (PsiStatement)elseBranch.copy();
            InvertIfConditionAction.setElseBranch(ifStatement, thenBranch, flow, ct);
            ct.replaceAndRestoreComments((PsiElement)ifStatement.getThenBranch(), (PsiElement)elseBranch);
            return ifStatement;
        }
        CodeStyleManager codeStyle = CodeStyleManager.getInstance((Project)project);
        if (flow.getSize() == 0) {
            ifStatement.setElseBranch(thenBranch);
            PsiStatement statement = factory.createStatementFromText("{}", (PsiElement)ifStatement);
            statement = (PsiStatement)codeStyle.reformat((PsiElement)statement);
            statement = (PsiStatement)ct.replaceAndRestoreComments((PsiElement)ifStatement.getThenBranch(), (PsiElement)statement);
            codeStyle.reformat((PsiElement)statement);
            return ifStatement;
        }
        int endOffset = InvertIfConditionAction.calcEndOffset(flow, ifStatement);
        LOG.assertTrue(endOffset >= 0);
        if (endOffset >= flow.getSize()) {
            PsiStatement statement = factory.createStatementFromText("return;", (PsiElement)ifStatement);
            statement = (PsiStatement)codeStyle.reformat((PsiElement)statement);
            if (thenBranch instanceof PsiBlockStatement) {
                if (ifStatement.getParent() instanceof PsiIfStatement) {
                    ifStatement = (PsiIfStatement)InvertIfConditionAction.wrapWithCodeBlock((PsiStatement)ifStatement);
                    thenBranch = ifStatement.getThenBranch();
                    assert (thenBranch != null);
                }
                PsiCodeBlock codeBlock = ((PsiBlockStatement)thenBranch).getCodeBlock();
                PsiElement firstElement = codeBlock.getFirstBodyElement();
                PsiElement lastElement = codeBlock.getLastBodyElement();
                if (firstElement != null && lastElement != null) {
                    ifStatement.getParent().addRangeAfter(firstElement, lastElement, (PsiElement)ifStatement);
                    ct.markRangeUnchanged(firstElement, lastElement);
                }
            } else if (!(thenBranch instanceof PsiReturnStatement)) {
                ifStatement = InvertIfConditionAction.addAfterWithinCodeBlock(ifStatement, ct.markUnchanged(thenBranch), ct);
            }
            ct.replaceAndRestoreComments((PsiElement)Objects.requireNonNull(ifStatement.getThenBranch()), (PsiElement)statement);
            return ifStatement;
        }
        for (element = flow.getElement(endOffset); element != null && !(element instanceof PsiStatement); element = element.getParent()) {
        }
        if (element != null && element.getParent() instanceof PsiForStatement && ((PsiForStatement)element.getParent()).getUpdate() == element || element instanceof PsiWhileStatement && flow.getStartOffset(element) == endOffset && PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)ifStatement, (boolean)true) || element instanceof PsiForeachStatement && flow.getStartOffset(element) + 1 == endOffset) {
            PsiStatement statement = factory.createStatementFromText("continue;", (PsiElement)ifStatement);
            statement = (PsiStatement)codeStyle.reformat((PsiElement)statement);
            ifStatement = InvertIfConditionAction.addAfterWithinCodeBlock(ifStatement, ct.markUnchanged(thenBranch), ct);
            Objects.requireNonNull(ifStatement.getThenBranch()).replace((PsiElement)statement);
            return ifStatement;
        }
        if (element instanceof PsiReturnStatement) {
            PsiReturnStatement returnStatement = (PsiReturnStatement)element;
            ifStatement = InvertIfConditionAction.addAfterWithinCodeBlock(ifStatement, thenBranch, ct);
            ct.replaceAndRestoreComments((PsiElement)Objects.requireNonNull(ifStatement.getThenBranch()), ct.markUnchanged(returnStatement).copy());
            ControlFlow flow2 = InvertIfConditionAction.buildControlFlow(InvertIfConditionAction.findCodeBlock(ifStatement));
            if (!ControlFlowUtil.isInstructionReachable(flow2, flow2.getStartOffset((PsiElement)returnStatement), 0)) {
                returnStatement.delete();
            }
            return ifStatement;
        }
        boolean bl = nextUnreachable = flow.getEndOffset((PsiElement)ifStatement) == flow.getSize();
        if (!nextUnreachable && (parent = ifStatement.getParent()) != null) {
            if (!(parent instanceof PsiCodeBlock)) {
                ifStatement = (PsiIfStatement)InvertIfConditionAction.wrapWithCodeBlock((PsiStatement)ifStatement);
                parent = ifStatement.getParent();
                thenBranch = ifStatement.getThenBranch();
            }
            ControlFlow localFlow = InvertIfConditionAction.buildControlFlow(parent);
            int startThenOffset = InvertIfConditionAction.getThenOffset(localFlow, ifStatement);
            int afterIfOffset = localFlow.getEndOffset((PsiElement)ifStatement);
            boolean bl2 = nextUnreachable = !ControlFlowUtil.isInstructionReachable(localFlow, afterIfOffset, startThenOffset);
        }
        if (nextUnreachable) {
            InvertIfConditionAction.setElseBranch(ifStatement, thenBranch, flow, ct);
            PsiElement first = PsiTreeUtil.skipWhitespacesForward((PsiElement)ifStatement);
            if (first != null) {
                PsiElement last = first;
                for (PsiElement next = last.getNextSibling(); next != null && !(next instanceof PsiSwitchLabelStatement); next = next.getNextSibling()) {
                    last = next;
                }
                while (first != last && (last instanceof PsiWhiteSpace || PsiUtil.isJavaToken((PsiElement)last, (IElementType)JavaTokenType.RBRACE))) {
                    last = last.getPrevSibling();
                }
                PsiBlockStatement codeBlock = (PsiBlockStatement)factory.createStatementFromText("{}", (PsiElement)ifStatement);
                if (first == last && PsiUtil.isJavaToken((PsiElement)last, (IElementType)JavaTokenType.RBRACE)) {
                    ct.replaceAndRestoreComments((PsiElement)ifStatement.getThenBranch(), (PsiElement)codeBlock);
                } else {
                    codeBlock.getCodeBlock().addRange(first, last);
                    ct.replaceAndRestoreComments((PsiElement)ifStatement.getThenBranch(), (PsiElement)codeBlock);
                    first.getParent().deleteChildRange(first, last);
                }
            }
            codeStyle.reformat((PsiElement)ifStatement);
            return ifStatement;
        }
        InvertIfConditionAction.setElseBranch(ifStatement, thenBranch, flow, ct);
        PsiStatement statement = factory.createStatementFromText("{}", (PsiElement)ifStatement);
        statement = (PsiStatement)codeStyle.reformat((PsiElement)statement);
        statement = (PsiStatement)ct.replaceAndRestoreComments((PsiElement)Objects.requireNonNull(ifStatement.getThenBranch()), (PsiElement)statement);
        codeStyle.reformat((PsiElement)statement);
        return ifStatement;
    }

    private static void setElseBranch(PsiIfStatement ifStatement, PsiStatement thenBranch, ControlFlow flow, CommentTracker ct) throws IncorrectOperationException {
        if (flow.getEndOffset((PsiElement)ifStatement) == flow.getEndOffset((PsiElement)thenBranch)) {
            PsiStatement[] statements;
            Object[] statements2;
            PsiStatement body2;
            PsiLoopStatement loopStmt = (PsiLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)ifStatement, PsiLoopStatement.class);
            if (loopStmt != null && (body2 = loopStmt.getBody()) instanceof PsiBlockStatement && (statements2 = ((PsiBlockStatement)body2).getCodeBlock().getStatements()).length > 0 && !PsiTreeUtil.isAncestor((PsiElement)statements2[statements2.length - 1], (PsiElement)ifStatement, (boolean)false) && ArrayUtilRt.find((Object[])statements2, (Object)ifStatement) < 0) {
                ifStatement.setElseBranch(ct.markUnchanged(thenBranch));
                return;
            }
            if (thenBranch instanceof PsiContinueStatement) {
                PsiStatement elseBranch = ifStatement.getElseBranch();
                if (elseBranch != null) {
                    elseBranch.delete();
                }
                return;
            }
            if (thenBranch instanceof PsiBlockStatement && (statements = ((PsiBlockStatement)thenBranch).getCodeBlock().getStatements()).length > 0 && statements[statements.length - 1] instanceof PsiContinueStatement) {
                new CommentTracker().deleteAndRestoreComments((PsiElement)statements[statements.length - 1]);
            }
        }
        ifStatement.setElseBranch(ct.markUnchanged(thenBranch));
    }

    private static PsiStatement wrapWithCodeBlock(@NotNull PsiStatement statement) {
        Project project = statement.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        CodeStyleManager codeStyle = CodeStyleManager.getInstance((Project)project);
        PsiIfStatement ifStatement = (PsiIfStatement)factory.createStatementFromText("if (true) {}", (PsiElement)statement);
        ifStatement = (PsiIfStatement)codeStyle.reformat((PsiElement)ifStatement);
        PsiStatement thenBranch = ifStatement.getThenBranch();
        assert (thenBranch instanceof PsiBlockStatement);
        ((PsiBlockStatement)thenBranch).getCodeBlock().add((PsiElement)statement);
        PsiCodeBlock stmt = ((PsiBlockStatement)statement.replace((PsiElement)thenBranch)).getCodeBlock();
        return stmt.getStatements()[0];
    }

    private static PsiIfStatement addAfterWithinCodeBlock(@NotNull PsiIfStatement ifStatement, @NotNull PsiStatement branch, CommentTracker ct) {
        PsiElement parent = ifStatement.getParent();
        if (parent != null && !(parent instanceof PsiCodeBlock)) {
            branch = (PsiStatement)branch.copy();
            ifStatement = (PsiIfStatement)InvertIfConditionAction.wrapWithCodeBlock((PsiStatement)ifStatement);
        }
        InvertIfConditionAction.addAfter(ifStatement, branch, ct);
        return ifStatement;
    }

    static void addAfter(PsiIfStatement ifStatement, PsiStatement branch, CommentTracker ct) throws IncorrectOperationException {
        if (branch instanceof PsiBlockStatement) {
            PsiBlockStatement blockStatement = (PsiBlockStatement)branch;
            PsiCodeBlock block = blockStatement.getCodeBlock();
            PsiElement firstBodyElement = block.getFirstBodyElement();
            PsiElement lastBodyElement = block.getLastBodyElement();
            if (firstBodyElement != null && lastBodyElement != null) {
                ct.markRangeUnchanged(firstBodyElement, lastBodyElement);
                ifStatement.getParent().addRangeAfter(firstBodyElement, lastBodyElement, (PsiElement)ifStatement);
            }
        } else {
            ifStatement.getParent().addAfter((PsiElement)ct.markUnchanged(branch), (PsiElement)ifStatement);
        }
    }

    private static int getThenOffset(ControlFlow controlFlow, PsiIfStatement ifStatement) {
        PsiStatement thenBranch = ifStatement.getThenBranch();
        for (int i = 0; i < controlFlow.getSize(); ++i) {
            if (!PsiTreeUtil.isAncestor((PsiElement)thenBranch, (PsiElement)controlFlow.getElement(i), (boolean)false)) continue;
            return i;
        }
        return -1;
    }

    private static int calcEndOffset(ControlFlow controlFlow, PsiIfStatement ifStatement) {
        int endOffset = -1;
        List<Instruction> instructions = controlFlow.getInstructions();
        for (int i = 0; i < instructions.size(); ++i) {
            BranchingInstruction goToInstruction;
            Instruction instruction = instructions.get(i);
            if (controlFlow.getElement(i) != ifStatement) continue;
            if (instruction instanceof GoToInstruction) {
                goToInstruction = (GoToInstruction)instruction;
                if (goToInstruction.role != BranchingInstruction.Role.END) continue;
                endOffset = goToInstruction.offset;
                break;
            }
            if (!(instruction instanceof ConditionalGoToInstruction)) continue;
            goToInstruction = (ConditionalGoToInstruction)instruction;
            if (((ConditionalGoToInstruction)goToInstruction).role != BranchingInstruction.Role.END) continue;
            endOffset = ((ConditionalGoToInstruction)goToInstruction).offset;
            break;
        }
        if (endOffset == -1) {
            endOffset = controlFlow.getSize();
        }
        while (endOffset < instructions.size() && instructions.get(endOffset) instanceof GoToInstruction && !((GoToInstruction)instructions.get((int)endOffset)).isReturn && !(controlFlow.getElement(endOffset) instanceof PsiBreakStatement) && !(controlFlow.getElement(endOffset) instanceof PsiContinueStatement)) {
            endOffset = ((BranchingInstruction)instructions.get((int)endOffset)).offset;
        }
        return endOffset;
    }
}

