/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.StreamRefactoringUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergeFilterChainAction
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)MergeFilterChainAction.class.getName());

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (!(element instanceof PsiIdentifier)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiElement gParent = parent.getParent();
        if (!(gParent instanceof PsiMethodCallExpression)) {
            return false;
        }
        if (!MergeFilterChainAction.isFilterCall((PsiMethodCallExpression)gParent)) {
            return false;
        }
        return MergeFilterChainAction.getFilterToMerge((PsiMethodCallExpression)gParent) != null;
    }

    @Nullable
    private static PsiMethodCallExpression getFilterToMerge(PsiMethodCallExpression methodCallExpression) {
        PsiMethodCallExpression prevCall = MethodCallUtils.getQualifierMethodCall(methodCallExpression);
        if (prevCall != null && MergeFilterChainAction.isFilterCall(prevCall)) {
            return prevCall;
        }
        PsiMethodCallExpression nextCall = ExpressionUtils.getCallForQualifier((PsiExpression)methodCallExpression);
        if (nextCall != null && MergeFilterChainAction.isFilterCall(nextCall)) {
            return nextCall;
        }
        return null;
    }

    public static boolean isFilterCall(PsiMethodCallExpression methodCallExpression) {
        String name = methodCallExpression.getMethodExpression().getReferenceName();
        if (!"filter".equals(name) && !"anyMatch".equals(name)) {
            return false;
        }
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        PsiExpression[] expressions2 = argumentList.getExpressions();
        if (expressions2.length != 1) {
            return false;
        }
        if (!StreamRefactoringUtil.isRefactoringCandidate(expressions2[0], true)) {
            return false;
        }
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        return parameters2.length == 1 && InheritanceUtil.isInheritor((PsiClass)containingClass, (boolean)false, (String)"java.util.stream.BaseStream");
    }

    @NotNull
    public String getText() {
        return CodeInsightBundle.message((String)"intention.merge.filter.text", (Object[])new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"intention.merge.filter.family", (Object[])new Object[0]);
    }

    @Nullable
    private static PsiLambdaExpression getLambda(PsiMethodCallExpression call) {
        PsiExpression[] expressions2 = call.getArgumentList().getExpressions();
        if (expressions2.length != 1) {
            return null;
        }
        PsiExpression expression2 = expressions2[0];
        if (expression2 instanceof PsiLambdaExpression) {
            return (PsiLambdaExpression)expression2;
        }
        if (expression2 instanceof PsiMethodReferenceExpression) {
            return LambdaRefactoringUtil.convertMethodReferenceToLambda((PsiMethodReferenceExpression)expression2, false, true);
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiParameter[] sourceLambdaParams;
        PsiMethodCallExpression filterCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
        LOG.assertTrue(filterCall != null);
        PsiMethodCallExpression filterToMerge = MergeFilterChainAction.getFilterToMerge(filterCall);
        LOG.assertTrue(filterToMerge != null);
        PsiMethodCallExpression callToStay = filterCall.getTextLength() < filterToMerge.getTextLength() ? filterCall : filterToMerge;
        PsiMethodCallExpression callToEliminate = callToStay == filterCall ? filterToMerge : filterCall;
        String resultingOperation = callToEliminate.getMethodExpression().getReferenceName();
        LOG.assertTrue(resultingOperation != null);
        PsiLambdaExpression targetLambda = MergeFilterChainAction.getLambda(callToStay);
        LOG.assertTrue(targetLambda != null, (Object)callToStay);
        PsiParameter[] parameters2 = targetLambda.getParameterList().getParameters();
        String name = parameters2.length > 0 ? parameters2[0].getName() : null;
        PsiLambdaExpression sourceLambda = MergeFilterChainAction.getLambda(callToEliminate);
        LOG.assertTrue(sourceLambda != null, (Object)callToEliminate);
        if (name != null && (sourceLambdaParams = sourceLambda.getParameterList().getParameters()).length > 0 && !name.equals(sourceLambdaParams[0].getName())) {
            for (PsiReference reference : ReferencesSearch.search((PsiElement)sourceLambdaParams[0]).findAll()) {
                PsiElement referenceElement = reference.getElement();
                if (!(referenceElement instanceof PsiReferenceExpression)) continue;
                ExpressionUtils.bindReferenceTo((PsiReferenceExpression)referenceElement, name);
            }
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiElement nameElement = callToStay.getMethodExpression().getReferenceNameElement();
        LOG.assertTrue(nameElement != null);
        if (!resultingOperation.equals(nameElement.getText())) {
            nameElement.replace((PsiElement)factory.createIdentifier(resultingOperation));
        }
        PsiElement targetBody = targetLambda.getBody();
        LOG.assertTrue(targetBody instanceof PsiExpression);
        PsiElement sourceLambdaBody = sourceLambda.getBody();
        LOG.assertTrue(sourceLambdaBody instanceof PsiExpression);
        PsiExpression compoundExpression = factory.createExpressionFromText(ParenthesesUtils.getText((PsiExpression)targetBody, 14) + " && " + ParenthesesUtils.getText((PsiExpression)sourceLambdaBody, 14), (PsiElement)sourceLambda);
        targetBody = targetBody.replace((PsiElement)compoundExpression);
        CodeStyleManager.getInstance((Project)project).reformat(targetBody);
        PsiExpression qualifierExpression2 = callToEliminate.getMethodExpression().getQualifierExpression();
        LOG.assertTrue(qualifierExpression2 != null, (Object)callToEliminate);
        Collection comments = PsiTreeUtil.findChildrenOfType((PsiElement)callToEliminate, PsiComment.class);
        for (PsiComment comment : comments) {
            TextRange commentRange = comment.getTextRange();
            if (sourceLambdaBody.getTextRange().contains(commentRange) || qualifierExpression2.getTextRange().contains(commentRange)) continue;
            targetBody.add((PsiElement)comment);
        }
        callToEliminate.replace((PsiElement)qualifierExpression2);
    }
}

