/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceAssignmentWithComparisonFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    public ReplaceAssignmentWithComparisonFix(@NotNull PsiAssignmentExpression expr) {
        super((PsiElement)expr);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiBinaryExpression comparisonExpr = (PsiBinaryExpression)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText("a==b", startElement);
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)startElement;
        comparisonExpr.getLOperand().replace((PsiElement)assignmentExpression.getLExpression());
        PsiExpression rOperand = comparisonExpr.getROperand();
        assert (rOperand != null);
        PsiExpression rExpression = assignmentExpression.getRExpression();
        assert (rExpression != null);
        rOperand.replace((PsiElement)rExpression);
        CodeStyleManager.getInstance((Project)project).reformat(assignmentExpression.replace((PsiElement)comparisonExpr));
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"=", "=="});
    }
}

