/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceCastWithVariableAction
extends PsiElementBaseIntentionAction {
    private String myReplaceVariableName = "";

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTypeCastExpression.class);
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        if (typeCastExpression == null || method == null) {
            return false;
        }
        PsiExpression operand2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)typeCastExpression.getOperand());
        if (!(operand2 instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression operandReference = (PsiReferenceExpression)operand2;
        PsiElement resolved = operandReference.resolve();
        if (!(resolved instanceof PsiParameter) && !(resolved instanceof PsiLocalVariable)) {
            return false;
        }
        PsiLocalVariable replacement = ReplaceCastWithVariableAction.findReplacement(method, (PsiVariable)resolved, typeCastExpression);
        if (replacement == null) {
            return false;
        }
        this.myReplaceVariableName = replacement.getName();
        this.setText(CodeInsightBundle.message((String)"intention.replace.cast.with.var.text", (Object[])new Object[]{typeCastExpression.getText(), this.myReplaceVariableName}));
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTypeCastExpression.class);
        if (typeCastExpression == null) {
            return;
        }
        PsiTypeCastExpression toReplace = typeCastExpression.getParent() instanceof PsiParenthesizedExpression ? typeCastExpression.getParent() : typeCastExpression;
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        new CommentTracker().replaceAndRestoreComments((PsiElement)toReplace, (PsiElement)factory.createExpressionFromText(this.myReplaceVariableName, (PsiElement)toReplace));
    }

    @Nullable
    private static PsiLocalVariable findReplacement(@NotNull PsiMethod method, @NotNull PsiVariable castedVar, @NotNull PsiTypeCastExpression expression2) {
        TextRange expressionTextRange = expression2.getTextRange();
        PsiExpression operand2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getOperand());
        List found = SyntaxTraverser.psiTraverser((PsiElement)method).filter(PsiTypeCastExpression.class).filter(cast -> EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(cast.getOperand(), operand2)).toList();
        PsiResolveHelper resolveHelper = PsiResolveHelper.SERVICE.getInstance((Project)method.getProject());
        for (PsiTypeCastExpression occurrence : found) {
            ProgressIndicatorProvider.checkCanceled();
            TextRange occurrenceTextRange = occurrence.getTextRange();
            if (occurrence == expression2 || occurrenceTextRange.getEndOffset() >= expressionTextRange.getStartOffset()) continue;
            PsiLocalVariable variable = ReplaceCastWithVariableAction.getVariable((PsiExpression)occurrence);
            PsiCodeBlock methodBody2 = method.getBody();
            if (variable == null || methodBody2 == null || variable.getName() == null || resolveHelper.resolveReferencedVariable(variable.getName(), (PsiElement)expression2) != variable || ReplaceCastWithVariableAction.isChangedBetween(castedVar, (PsiElement)methodBody2, (PsiElement)occurrence, (PsiElement)expression2) || ReplaceCastWithVariableAction.isChangedBetween((PsiVariable)variable, (PsiElement)methodBody2, (PsiElement)occurrence, (PsiElement)expression2)) continue;
            return variable;
        }
        return null;
    }

    private static boolean isChangedBetween(final @NotNull PsiVariable variable, @NotNull PsiElement scope, final @NotNull PsiElement start, final @NotNull PsiElement end) {
        if (variable.hasModifierProperty("final")) {
            return false;
        }
        final Ref result = new Ref();
        scope.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){
            private boolean inScope;

            public void visitElement(PsiElement element) {
                if (element == start) {
                    this.inScope = true;
                }
                if (element == end) {
                    this.inScope = false;
                    this.stopWalking();
                }
                super.visitElement(element);
            }

            public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
                PsiReferenceExpression referenceExpression;
                if (this.inScope && expression2.getLExpression() instanceof PsiReferenceExpression && variable.equals((referenceExpression = (PsiReferenceExpression)expression2.getLExpression()).resolve())) {
                    result.set((Object)true);
                    this.stopWalking();
                }
                super.visitAssignmentExpression(expression2);
            }
        });
        return result.get() == Boolean.TRUE;
    }

    @Nullable
    private static PsiLocalVariable getVariable(@NotNull PsiExpression occurrence) {
        PsiReferenceExpression referenceExpression;
        PsiElement resolved;
        PsiAssignmentExpression assignmentExpression;
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)occurrence.getParent());
        if (parent instanceof PsiLocalVariable) {
            return (PsiLocalVariable)parent;
        }
        if (parent instanceof PsiAssignmentExpression && (assignmentExpression = (PsiAssignmentExpression)parent).getLExpression() instanceof PsiReferenceExpression && (resolved = (referenceExpression = (PsiReferenceExpression)assignmentExpression.getLExpression()).resolve()) instanceof PsiLocalVariable) {
            return (PsiLocalVariable)resolved;
        }
        return null;
    }

    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"intention.replace.cast.with.var.family", (Object[])new Object[0]);
    }
}

