/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.JavaClassSupers;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SameErasureButDifferentMethodsFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final SmartPsiElementPointer<PsiMethod> methodPtr;

    public SameErasureButDifferentMethodsFix(@NotNull PsiMethod method, @NotNull PsiMethod superMethod) {
        super((PsiElement)superMethod);
        this.methodPtr = SmartPointerManager.getInstance((Project)method.getProject()).createSmartPsiElementPointer((PsiElement)method);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiParameter[] superParameters;
        if (!this.isAvailable(project, file, startElement, endElement)) {
            return;
        }
        PsiMethod superMethod = (PsiMethod)startElement;
        PsiMethod method = (PsiMethod)this.methodPtr.getElement();
        if (method == null || !method.isValid()) {
            return;
        }
        PsiClass containingClass = method.getContainingClass();
        PsiClass superContainingClass = superMethod.getContainingClass();
        if (containingClass == null || superContainingClass == null) {
            return;
        }
        PsiSubstitutor superSubstitutor = JavaClassSupers.getInstance().getSuperClassSubstitutor(superContainingClass, containingClass, containingClass.getResolveScope(), PsiSubstitutor.EMPTY);
        if (superSubstitutor == null) {
            return;
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (parameters2.length != (superParameters = superMethod.getParameterList().getParameters()).length) {
            return;
        }
        ParameterInfoImpl[] infos = new ParameterInfoImpl[parameters2.length];
        for (int i = 0; i < parameters2.length; ++i) {
            PsiParameter parameter2 = parameters2[i];
            PsiParameter superParameter = superParameters[i];
            PsiType superParameterType = superSubstitutor.substitute(superParameter.getType());
            infos[i] = new ParameterInfoImpl(i, parameter2.getName(), superParameterType);
        }
        ChangeSignatureProcessor processor = new ChangeSignatureProcessor(project, method, false, null, method.getName(), method.getReturnType(), infos);
        TransactionGuard.submitTransaction((Disposable)project, (Runnable)((Object)processor));
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiMethod superMethod = (PsiMethod)startElement;
        PsiMethod method = (PsiMethod)this.methodPtr.getElement();
        if (method == null || !method.isValid()) {
            return false;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiClass containingClass = method.getContainingClass();
        PsiClass superContainingClass = superMethod.getContainingClass();
        if (containingClass == null || superContainingClass == null) {
            return false;
        }
        if (!facade.getResolveHelper().isAccessible((PsiMember)superMethod, (PsiElement)containingClass, null)) {
            return false;
        }
        MethodSignature signature = method.getSignature(PsiSubstitutor.EMPTY);
        PsiSubstitutor superSubstitutor = JavaClassSupers.getInstance().getSuperClassSubstitutor(superContainingClass, containingClass, containingClass.getResolveScope(), PsiSubstitutor.EMPTY);
        if (superSubstitutor == null) {
            return false;
        }
        MethodSignature superSignature = superMethod.getSignature(superSubstitutor);
        if (method.getParameterList().getParametersCount() != superMethod.getParameterList().getParametersCount()) {
            return false;
        }
        return !signature.equals(superSignature) && MethodSignatureUtil.areSignaturesErasureEqual((MethodSignature)signature, (MethodSignature)superSignature);
    }

    @NotNull
    public String getText() {
        PsiMethod method = (PsiMethod)this.methodPtr.getElement();
        if (method == null || !method.isValid()) {
            return this.getFamilyName();
        }
        return "Fix method '" + method.getName() + "' parameters with bounded wildcards";
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return "Fix bounded wildcards";
    }

    public boolean startInWriteAction() {
        return false;
    }
}

