/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.daemon.impl.quickfix.SimplifyBooleanExpressionFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplifyBooleanExpressionAction
implements IntentionAction {
    private String myText = this.getFamilyName();

    @NotNull
    public String getText() {
        return this.myText;
    }

    @NotNull
    public String getFamilyName() {
        return SimplifyBooleanExpressionFix.FAMILY_NAME;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiExpression expression2 = SimplifyBooleanExpressionAction.getExpressionToSimplify(editor, file);
        if (expression2 != null && SimplifyBooleanExpressionFix.canBeSimplified(expression2)) {
            Object o = JavaConstantExpressionEvaluator.computeConstantExpression(expression2, false);
            this.myText = o instanceof Boolean ? SimplifyBooleanExpressionFix.getIntentionText(expression2, (Boolean)o) : this.getFamilyName();
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiExpression getExpressionToSimplify(@NotNull Editor editor, @NotNull PsiFile file) {
        PsiExpression expression2;
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return null;
        }
        PsiExpression parent = expression2 = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiExpression.class);
        while (parent instanceof PsiExpression && !(parent instanceof PsiAssignmentExpression) && (PsiType.BOOLEAN.equals((Object)parent.getType()) || parent instanceof PsiConditionalExpression)) {
            expression2 = parent;
            parent = parent.getParent();
        }
        return expression2;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiExpression expression2 = SimplifyBooleanExpressionAction.getExpressionToSimplify(editor, file);
        if (expression2 != null) {
            SimplifyBooleanExpressionFix.simplifyExpression(expression2);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

