/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ipp.psiutils.ErrorUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SplitConditionUtil {
    public static PsiPolyadicExpression findCondition(PsiElement element) {
        return SplitConditionUtil.findCondition(element, true, true);
    }

    public static PsiPolyadicExpression findCondition(PsiElement element, boolean acceptAnd, boolean acceptOr) {
        boolean isOrExpression;
        if (!(element instanceof PsiJavaToken)) {
            return null;
        }
        PsiJavaToken token = (PsiJavaToken)element;
        if (!(token.getParent() instanceof PsiPolyadicExpression)) {
            return null;
        }
        PsiPolyadicExpression expression2 = (PsiPolyadicExpression)token.getParent();
        boolean isAndExpression = acceptAnd && expression2.getOperationTokenType() == JavaTokenType.ANDAND;
        boolean bl = isOrExpression = acceptOr && expression2.getOperationTokenType() == JavaTokenType.OROR;
        if (!isAndExpression && !isOrExpression) {
            return null;
        }
        if (ErrorUtil.containsError((PsiElement)expression2)) {
            return null;
        }
        while (expression2.getParent() instanceof PsiPolyadicExpression) {
            expression2 = (PsiPolyadicExpression)expression2.getParent();
            if (isAndExpression && expression2.getOperationTokenType() != JavaTokenType.ANDAND) {
                return null;
            }
            if (!isOrExpression || expression2.getOperationTokenType() == JavaTokenType.OROR) continue;
            return null;
        }
        return expression2;
    }

    public static PsiExpression getROperands(PsiPolyadicExpression expression2, PsiJavaToken separator) {
        return SplitConditionUtil.getROperands(expression2, separator, new CommentTracker());
    }

    public static PsiExpression getROperands(PsiPolyadicExpression expression2, PsiJavaToken separator, CommentTracker ct) {
        int offsetInParent;
        PsiElement next = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)separator);
        if (next == null) {
            offsetInParent = separator.getStartOffsetInParent() + separator.getTextLength();
        } else {
            ct.markRangeUnchanged(next, expression2.getLastChild());
            offsetInParent = next.getStartOffsetInParent();
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expression2.getProject());
        String rOperands = expression2.getText().substring(offsetInParent);
        return factory.createExpressionFromText(rOperands, expression2.getParent());
    }

    public static PsiExpression getLOperands(PsiPolyadicExpression expression2, PsiJavaToken separator) {
        return SplitConditionUtil.getLOperands(expression2, separator, new CommentTracker());
    }

    public static PsiExpression getLOperands(PsiPolyadicExpression expression2, PsiJavaToken separator, CommentTracker ct) {
        PsiJavaToken prev = separator;
        if (prev.getPrevSibling() instanceof PsiWhiteSpace) {
            prev = prev.getPrevSibling();
        }
        ct.markRangeUnchanged(expression2.getFirstChild(), prev.getPrevSibling());
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expression2.getProject());
        String rOperands = expression2.getText().substring(0, prev.getStartOffsetInParent());
        return factory.createExpressionFromText(rOperands, expression2.getParent());
    }

    @Nullable
    static PsiIfStatement create(@NotNull PsiElementFactory factory, @NotNull PsiIfStatement ifStatement, @NotNull PsiExpression extract, @NotNull PsiExpression leave, @NotNull IElementType operation, CommentTracker tracker) {
        PsiStatement thenBranch = ifStatement.getThenBranch();
        if (thenBranch == null) {
            return null;
        }
        PsiStatement elseBranch = ifStatement.getElseBranch();
        if (operation == JavaTokenType.OROR) {
            return SplitConditionUtil.createOrOr(factory, thenBranch, elseBranch, extract, leave, tracker);
        }
        if (operation == JavaTokenType.ANDAND) {
            return SplitConditionUtil.createAndAnd(factory, thenBranch, elseBranch, extract, leave, tracker);
        }
        return null;
    }

    @NotNull
    private static PsiIfStatement createAndAnd(@NotNull PsiElementFactory factory, @NotNull PsiStatement thenBranch, @Nullable PsiStatement elseBranch, @NotNull PsiExpression extract, @NotNull PsiExpression leave, CommentTracker tracker) {
        PsiExpression nextCondition;
        PsiIfStatement nextIf;
        ArrayList<String> elseChain = new ArrayList<String>();
        boolean chainFinished = false;
        block0: while (!chainFinished && (nextIf = (PsiIfStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.stripBraces(elseBranch), PsiIfStatement.class)) != null && (nextCondition = PsiUtil.skipParenthesizedExprDown((PsiExpression)nextIf.getCondition())) != null) {
            if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)extract, (PsiElement)nextCondition) && nextIf.getThenBranch() != null) {
                elseChain.add(tracker.text((PsiElement)nextIf.getThenBranch()));
                chainFinished = true;
            } else {
                PsiExpression[] operands2;
                PsiPolyadicExpression nextPolyadic;
                if (!(nextCondition instanceof PsiPolyadicExpression) || !(nextPolyadic = (PsiPolyadicExpression)nextCondition).getOperationTokenType().equals(JavaTokenType.ANDAND)) break;
                PsiExpression[] nextOperands = nextPolyadic.getOperands();
                if (nextOperands.length <= (operands2 = extract instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)extract).getOperationTokenType().equals(JavaTokenType.ANDAND) ? ((PsiPolyadicExpression)extract).getOperands() : new PsiExpression[]{extract}).length) break;
                for (int i = 0; i < operands2.length; ++i) {
                    if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)nextOperands[i], (PsiElement)operands2[i])) break block0;
                }
                PsiExpression nextExtracted = SplitConditionUtil.getROperands(nextPolyadic, nextPolyadic.getTokenBeforeOperand(nextOperands[operands2.length]), tracker);
                elseChain.add(SplitConditionUtil.createIfString(nextExtracted, nextIf.getThenBranch(), (PsiStatement)null, tracker));
            }
            elseBranch = nextIf.getElseBranch();
        }
        if (!chainFinished && elseBranch != null) {
            elseChain.add(elseBranch.getText());
        }
        String thenString = elseChain.isEmpty() ? SplitConditionUtil.createIfString(leave, thenBranch, (String)null, tracker) : "{" + SplitConditionUtil.createIfString(leave, thenBranch, String.join((CharSequence)"\nelse ", elseChain), tracker) + "\n}";
        String ifString = SplitConditionUtil.createIfString(extract, thenString, elseBranch, tracker);
        return (PsiIfStatement)factory.createStatementFromText(ifString, (PsiElement)thenBranch);
    }

    @NotNull
    private static PsiIfStatement createOrOr(@NotNull PsiElementFactory factory, @NotNull PsiStatement thenBranch, @Nullable PsiStatement elseBranch, @NotNull PsiExpression extract, @NotNull PsiExpression leave, CommentTracker tracker) {
        return (PsiIfStatement)factory.createStatementFromText(SplitConditionUtil.createIfString(extract, thenBranch, SplitConditionUtil.createIfString(leave, thenBranch, elseBranch, tracker), tracker), (PsiElement)thenBranch);
    }

    @NotNull
    private static String createIfString(@NotNull PsiExpression condition2, @NotNull PsiStatement thenBranch, @Nullable PsiStatement elseBranch, CommentTracker tracker) {
        PsiExpression stripped = PsiUtil.skipParenthesizedExprDown((PsiExpression)condition2);
        return SplitConditionUtil.createIfString(tracker.text((PsiElement)(stripped == null ? condition2 : stripped)), SplitConditionUtil.toThenBranchString(tracker.markUnchanged(thenBranch)), SplitConditionUtil.toElseBranchString(elseBranch != null ? tracker.markUnchanged(elseBranch) : null, false));
    }

    @NotNull
    private static String createIfString(@NotNull PsiExpression condition2, @NotNull PsiStatement thenBranch, @Nullable String elseBranch, CommentTracker tracker) {
        PsiExpression stripped = PsiUtil.skipParenthesizedExprDown((PsiExpression)condition2);
        return SplitConditionUtil.createIfString(tracker.text((PsiElement)(stripped == null ? condition2 : stripped)), SplitConditionUtil.toThenBranchString(tracker.markUnchanged(thenBranch)), elseBranch);
    }

    @NotNull
    private static String createIfString(@NotNull PsiExpression condition2, @NotNull String thenBranch, @Nullable PsiStatement elseBranch, CommentTracker tracker) {
        PsiExpression stripped = PsiUtil.skipParenthesizedExprDown((PsiExpression)condition2);
        return SplitConditionUtil.createIfString(tracker.text((PsiElement)(stripped == null ? condition2 : stripped)), thenBranch, SplitConditionUtil.toElseBranchString(elseBranch != null ? tracker.markUnchanged(elseBranch) : null, true));
    }

    @NotNull
    private static String createIfString(@NotNull String condition2, @NotNull String thenBranch, @Nullable String elseBranch) {
        String elsePart = elseBranch != null ? "\n else " + elseBranch : "";
        return "if (" + condition2 + ")\n" + thenBranch + elsePart;
    }

    @NotNull
    private static String toThenBranchString(@NotNull PsiStatement statement) {
        if (!(statement instanceof PsiBlockStatement)) {
            return "{ " + statement.getText() + "\n }";
        }
        return statement.getText();
    }

    @Nullable
    private static String toElseBranchString(@Nullable PsiStatement statement, boolean skipElse) {
        if (statement == null) {
            return null;
        }
        if (statement instanceof PsiBlockStatement || skipElse && statement instanceof PsiIfStatement) {
            return statement.getText();
        }
        return "{ " + statement.getText() + "\n }";
    }
}

