/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.MergeFilterChainAction;
import com.intellij.codeInsight.intention.impl.SplitConditionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SplitFilterAction
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)SplitFilterAction.class.getName());

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiPolyadicExpression expression2 = SplitConditionUtil.findCondition(element, true, false);
        if (expression2 == null || expression2.getOperands().length < 2) {
            return false;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
        if (!(parent instanceof PsiLambdaExpression)) {
            return false;
        }
        if (((PsiLambdaExpression)parent).getParameterList().getParametersCount() != 1) {
            return false;
        }
        if (!((parent = parent.getParent()) instanceof PsiExpressionList)) {
            return false;
        }
        PsiElement gParent = parent.getParent();
        if (!(gParent instanceof PsiMethodCallExpression)) {
            return false;
        }
        return MergeFilterChainAction.isFilterCall((PsiMethodCallExpression)gParent);
    }

    @NotNull
    public String getText() {
        return CodeInsightBundle.message((String)"intention.split.filter.text", (Object[])new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"intention.split.filter.family", (Object[])new Object[0]);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiJavaToken token = (PsiJavaToken)element;
        PsiPolyadicExpression expression2 = SplitConditionUtil.findCondition((PsiElement)token, true, false);
        PsiLambdaExpression originalLambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiLambdaExpression.class);
        LOG.assertTrue(originalLambdaExpression != null);
        String lambdaParameterName = originalLambdaExpression.getParameterList().getParameters()[0].getName();
        PsiElement originalLambdaExpressionBody = originalLambdaExpression.getBody();
        LOG.assertTrue(originalLambdaExpressionBody != null);
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethodCallExpression.class);
        LOG.assertTrue(methodCallExpression != null, (Object)expression2);
        PsiExpression qualifierExpression2 = methodCallExpression.getMethodExpression().getQualifierExpression();
        LOG.assertTrue(qualifierExpression2 != null);
        PsiMethodCallExpression newFilterCall = (PsiMethodCallExpression)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText("a.filter(" + lambdaParameterName + " -> x)", (PsiElement)methodCallExpression);
        PsiLambdaExpression newFilterLambda = (PsiLambdaExpression)newFilterCall.getArgumentList().getExpressions()[0];
        PsiExpression filterCallQualifier = newFilterCall.getMethodExpression().getQualifierExpression();
        LOG.assertTrue(filterCallQualifier != null);
        PsiElement newFilterLambdaBody = newFilterLambda.getBody();
        LOG.assertTrue(newFilterLambdaBody != null);
        List comments = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)expression2, PsiComment.class);
        int separatorOffset = token.getTextOffset();
        for (PsiComment comment : comments) {
            if (comment.getTextOffset() < separatorOffset) {
                newFilterLambda.getParent().add((PsiElement)comment);
                continue;
            }
            originalLambdaExpression.addBefore((PsiElement)comment, originalLambdaExpressionBody);
        }
        PsiExpression rOperands = SplitConditionUtil.getROperands(expression2, token);
        PsiExpression lOperands = SplitConditionUtil.getLOperands(expression2, token);
        originalLambdaExpressionBody.replace((PsiElement)rOperands);
        newFilterLambdaBody.replace((PsiElement)lOperands);
        filterCallQualifier.replace((PsiElement)qualifierExpression2);
        qualifierExpression2.replace((PsiElement)newFilterCall);
    }
}

