/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.codeInsight.intention.impl.SplitConditionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public class SplitIfAction
extends BaseElementAtCaretIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.SplitIfAction");

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiPolyadicExpression expression2 = SplitConditionUtil.findCondition(element);
        if (expression2 == null) {
            return false;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
        if (!(parent instanceof PsiIfStatement)) {
            return false;
        }
        PsiIfStatement ifStatement = (PsiIfStatement)parent;
        if (!PsiTreeUtil.isAncestor((PsiElement)ifStatement.getCondition(), (PsiElement)expression2, (boolean)false)) {
            return false;
        }
        if (ifStatement.getThenBranch() == null) {
            return false;
        }
        this.setText(CodeInsightBundle.message((String)"intention.split.if.text", (Object[])new Object[0]));
        return true;
    }

    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"intention.split.if.family", (Object[])new Object[0]);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiExpression resultCondition;
        PsiJavaToken token = (PsiJavaToken)element;
        LOG.assertTrue(token.getTokenType() == JavaTokenType.ANDAND || token.getTokenType() == JavaTokenType.OROR);
        PsiPolyadicExpression expression2 = (PsiPolyadicExpression)token.getParent();
        PsiIfStatement ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiIfStatement.class);
        if (ifStatement == null) {
            return;
        }
        PsiExpression condition2 = ifStatement.getCondition();
        LOG.assertTrue(PsiTreeUtil.isAncestor((PsiElement)condition2, (PsiElement)expression2, (boolean)false));
        CommentTracker ct = new CommentTracker();
        PsiExpression lOperand = SplitConditionUtil.getLOperands(expression2, token, ct);
        PsiExpression rOperand = SplitConditionUtil.getROperands(expression2, token, ct);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expression2.getProject());
        PsiIfStatement replacement = SplitConditionUtil.create(factory, ifStatement, lOperand, rOperand, token.getTokenType(), ct);
        if (replacement == null) {
            return;
        }
        PsiElement result = ct.replaceAndRestoreComments((PsiElement)ifStatement, (PsiElement)replacement);
        result = CodeStyleManager.getInstance((Project)project).reformat(result);
        if (result instanceof PsiIfStatement && (resultCondition = ((PsiIfStatement)result).getCondition()) != null) {
            int offset = resultCondition.getTextOffset();
            editor.getCaretModel().moveToOffset(offset);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            editor.getSelectionModel().removeSelection();
        }
    }
}

