/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiRawStringLiteralUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public class SplitRawStringIntentionAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        int offset;
        int caretInTokenIdx;
        int trailingTicsSequence;
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        PsiJavaToken token = (PsiJavaToken)element;
        if (token.getTokenType() != JavaTokenType.RAW_STRING_LITERAL) {
            return false;
        }
        String text2 = token.getText();
        if (text2 == null) {
            return false;
        }
        int leadingTicsSequence = PsiRawStringLiteralUtil.getLeadingTicksSequence((CharSequence)text2);
        return leadingTicsSequence == (trailingTicsSequence = PsiRawStringLiteralUtil.getTrailingTicksSequence((CharSequence)text2)) && (caretInTokenIdx = (offset = editor.getCaretModel().getOffset()) - token.getTextOffset()) > leadingTicsSequence && offset < token.getTextRange().getEndOffset() - trailingTicsSequence && text2.charAt(caretInTokenIdx) != '`' && text2.charAt(caretInTokenIdx - 1) != '`';
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (!(element instanceof PsiJavaToken)) {
            return;
        }
        PsiJavaToken token = (PsiJavaToken)element;
        if (token.getTokenType() != JavaTokenType.RAW_STRING_LITERAL) {
            return;
        }
        String text2 = token.getText();
        if (text2 == null) {
            return;
        }
        int ticsSequenceLength = PsiRawStringLiteralUtil.getLeadingTicksSequence((CharSequence)text2);
        String breakSequence = StringUtil.repeat((String)"`", (int)ticsSequenceLength);
        int offset = editor.getCaretModel().getOffset();
        int splitIdx = offset - token.getTextOffset();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiBinaryExpression replacement = (PsiBinaryExpression)factory.createExpressionFromText(text2.substring(0, splitIdx) + breakSequence + " + " + breakSequence + text2.substring(splitIdx), element);
        PsiPolyadicExpression replacedExpression = (PsiPolyadicExpression)ExpressionUtils.replacePolyadicWithParent((PsiExpression)token.getParent(), (PsiExpression)replacement);
        if (replacedExpression != null) {
            PsiJavaToken tokenBeforeOperand;
            PsiElement leftOperand2 = replacedExpression.findElementAt(splitIdx);
            Object[] operands2 = replacedExpression.getOperands();
            int idx = ArrayUtil.find((Object[])operands2, (Object)leftOperand2);
            if (idx < operands2.length - 1 && (tokenBeforeOperand = replacedExpression.getTokenBeforeOperand((PsiExpression)operands2[idx + 1])) != null) {
                editor.getCaretModel().moveToOffset(tokenBeforeOperand.getTextOffset());
            }
        } else {
            PsiBinaryExpression replaced = (PsiBinaryExpression)token.getParent().replace((PsiElement)replacement);
            editor.getCaretModel().moveToOffset(replaced.getOperationSign().getTextOffset());
        }
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @NotNull
    public String getFamilyName() {
        return "Split raw string literal";
    }
}

