/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.TypeExpression;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SurroundAutoCloseableAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        return element.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE) && PsiUtil.getLanguageLevel((PsiElement)element).isAtLeast(LanguageLevel.JDK_1_7) && (SurroundAutoCloseableAction.findVariable(element) != null || SurroundAutoCloseableAction.findExpression(element) != null);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiLocalVariable variable = SurroundAutoCloseableAction.findVariable(element);
        if (variable != null) {
            SurroundAutoCloseableAction.processVariable(project, editor, variable);
        } else {
            PsiExpression expression2 = SurroundAutoCloseableAction.findExpression(element);
            if (expression2 != null) {
                SurroundAutoCloseableAction.processExpression(project, editor, expression2);
            }
        }
    }

    private static PsiLocalVariable findVariable(PsiElement element) {
        PsiElement lastVar;
        PsiElement sibling;
        PsiLocalVariable variable = (PsiLocalVariable)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiLocalVariable.class});
        if (variable != null && variable.getParent() instanceof PsiDeclarationStatement && variable.getParent().getParent() instanceof PsiCodeBlock && SurroundAutoCloseableAction.rightType(variable.getType()) && SurroundAutoCloseableAction.validExpression(variable.getInitializer())) {
            return variable;
        }
        if (variable == null && element instanceof PsiWhiteSpace && (sibling = element.getPrevSibling()) instanceof PsiDeclarationStatement && (lastVar = (PsiElement)ArrayUtil.getLastElement((Object[])((PsiDeclarationStatement)sibling).getDeclaredElements())) instanceof PsiLocalVariable && SurroundAutoCloseableAction.rightType((variable = (PsiLocalVariable)lastVar).getType()) && SurroundAutoCloseableAction.validExpression(variable.getInitializer())) {
            return variable;
        }
        return null;
    }

    private static PsiExpression findExpression(PsiElement element) {
        PsiElement sibling;
        PsiExpression expression2 = (PsiExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiExpression.class});
        if (expression2 != null && expression2.getParent() instanceof PsiExpressionStatement && expression2.getParent().getParent() instanceof PsiCodeBlock && SurroundAutoCloseableAction.validExpression(expression2)) {
            return expression2;
        }
        if (expression2 == null && element instanceof PsiWhiteSpace && (sibling = element.getPrevSibling()) instanceof PsiExpressionStatement && SurroundAutoCloseableAction.validExpression(expression2 = ((PsiExpressionStatement)sibling).getExpression())) {
            return expression2;
        }
        return null;
    }

    private static boolean rightType(PsiType type2) {
        return InheritanceUtil.isInheritor((PsiType)type2, (String)"java.lang.AutoCloseable");
    }

    private static boolean validExpression(PsiExpression expression2) {
        return expression2 != null && SurroundAutoCloseableAction.rightType(expression2.getType()) && PsiTreeUtil.findChildOfType((PsiElement)expression2, PsiErrorElement.class) == null;
    }

    private static void processVariable(Project project, Editor editor, PsiLocalVariable variable) {
        PsiJavaToken brace;
        PsiCodeBlock tryBlock;
        PsiExpression initializer = (PsiExpression)ObjectUtils.assertNotNull((Object)variable.getInitializer());
        PsiElement declaration2 = variable.getParent();
        PsiElement codeBlock = declaration2.getParent();
        LocalSearchScope scope = new LocalSearchScope(codeBlock);
        PsiElement last = null;
        for (PsiReference reference : ReferencesSearch.search((PsiElement)variable, (SearchScope)scope).findAll()) {
            PsiElement usage = PsiTreeUtil.findPrevParent((PsiElement)codeBlock, (PsiElement)reference.getElement());
            if (last != null && usage.getTextOffset() <= last.getTextOffset()) continue;
            last = usage;
        }
        CommentTracker tracker = new CommentTracker();
        String text2 = "try (" + variable.getTypeElement().getText() + " " + variable.getName() + " = " + tracker.text((PsiElement)initializer) + ") {}";
        PsiTryStatement armStatement = (PsiTryStatement)tracker.replaceAndRestoreComments(declaration2, text2);
        List<PsiElement> toFormat = null;
        if (last != null) {
            toFormat = SurroundAutoCloseableAction.moveStatements(last, armStatement);
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        PsiElement formattedElement = codeStyleManager.reformat((PsiElement)armStatement);
        if (toFormat != null) {
            for (PsiElement psiElement : toFormat) {
                codeStyleManager.reformat(psiElement);
            }
        }
        if (last == null && (tryBlock = ((PsiTryStatement)formattedElement).getTryBlock()) != null && (brace = tryBlock.getLBrace()) != null) {
            editor.getCaretModel().moveToOffset(brace.getTextOffset() + 1);
        }
    }

    private static List<PsiElement> moveStatements(PsiElement last, PsiTryStatement statement) {
        PsiCodeBlock tryBlock = statement.getTryBlock();
        assert (tryBlock != null) : statement.getText();
        PsiElement parent = statement.getParent();
        LocalSearchScope scope = new LocalSearchScope(parent);
        SmartList toFormat = new SmartList();
        PsiElement stopAt = last.getNextSibling();
        PsiElement i = statement.getNextSibling();
        while (i != null && i != stopAt) {
            PsiElement[] declaredElements;
            PsiElement child = i;
            i = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)i);
            if (!(child instanceof PsiDeclarationStatement)) continue;
            int endOffset = last.getTextRange().getEndOffset();
            if (child.getTextOffset() > endOffset) break;
            PsiElement anchor = child;
            for (PsiElement declared : declaredElements = ((PsiDeclarationStatement)child).getDeclaredElements()) {
                boolean contained;
                if (!(declared instanceof PsiLocalVariable) || (contained = ReferencesSearch.search((PsiElement)declared, (SearchScope)scope).allMatch(ref -> ref.getElement().getTextOffset() <= endOffset))) continue;
                PsiLocalVariable var = (PsiLocalVariable)declared;
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)statement.getProject());
                String name = var.getName();
                assert (name != null) : child.getText();
                PsiDeclarationStatement declarationStatement = factory.createVariableDeclarationStatement(name, var.getType(), null);
                PsiUtil.setModifierProperty((PsiModifierListOwner)((PsiLocalVariable)declarationStatement.getDeclaredElements()[0]), (String)"final", (boolean)var.hasModifierProperty("final"));
                toFormat.add(parent.addBefore((PsiElement)declarationStatement, (PsiElement)statement));
                CommentTracker commentTracker = new CommentTracker();
                PsiExpression varInit = var.getInitializer();
                if (varInit != null) {
                    String varAssignText = name + " = " + commentTracker.text((PsiElement)varInit) + ";";
                    anchor = parent.addAfter((PsiElement)factory.createStatementFromText(varAssignText, parent), anchor);
                }
                commentTracker.deleteAndRestoreComments((PsiElement)(declaredElements.length == 1 ? child : var));
            }
            if (child != last || child.isValid()) continue;
            last = anchor;
        }
        PsiElement first = statement.getNextSibling();
        tryBlock.addRangeBefore(first, last, (PsiElement)tryBlock.getRBrace());
        parent.deleteChildRange(first, last);
        return toFormat;
    }

    private static void processExpression(Project project, Editor editor, PsiExpression expression2) {
        PsiType type2 = (PsiType)ObjectUtils.assertNotNull((Object)expression2.getType());
        PsiStatement statement = (PsiStatement)expression2.getParent();
        CommentTracker commentTracker = new CommentTracker();
        String text2 = "try (" + type2.getCanonicalText(true) + " r = " + commentTracker.text((PsiElement)expression2) + ") {}";
        PsiTryStatement tryStatement = (PsiTryStatement)commentTracker.replaceAndRestoreComments((PsiElement)statement, text2);
        tryStatement = (PsiTryStatement)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)tryStatement);
        PsiResourceList resourceList = (tryStatement = (PsiTryStatement)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)tryStatement)).getResourceList();
        if (resourceList != null) {
            PsiResourceVariable var = (PsiResourceVariable)resourceList.iterator().next();
            PsiIdentifier id = var.getNameIdentifier();
            PsiExpression initializer = var.getInitializer();
            if (id != null && initializer != null) {
                type2 = initializer.getType();
                String[] names = IntroduceVariableBase.getSuggestedName((PsiType)type2, (PsiExpression)initializer).names;
                PsiType[] types = (PsiType[])Stream.of(new TypeSelectorManagerImpl(project, type2, initializer, PsiExpression.EMPTY_ARRAY).getTypesForAll()).filter(SurroundAutoCloseableAction::rightType).toArray(PsiType[]::new);
                TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)var);
                builder.replaceElement((PsiElement)id, (Expression)new NamesExpression(names));
                builder.replaceElement((PsiElement)var.getTypeElement(), (Expression)new TypeExpression(project, types));
                builder.run(editor, true);
            }
        }
    }

    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"intention.surround.resource.with.ARM.block", (Object[])new Object[0]);
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    public static class Template
    implements SurroundDescriptor,
    Surrounder {
        private final Surrounder[] mySurrounders = new Surrounder[]{this};

        @NotNull
        public PsiElement[] getElementsToSurround(PsiFile file, int startOffset, int endOffset) {
            PsiElement[] psiElementArray;
            if (!PsiUtil.isLanguageLevel7OrHigher((PsiElement)file)) {
                return PsiElement.EMPTY_ARRAY;
            }
            PsiElement element = file.findElementAt(endOffset);
            PsiExpression target = SurroundAutoCloseableAction.findExpression(element);
            if (target == null) {
                target = SurroundAutoCloseableAction.findVariable(element);
            }
            if (target != null) {
                PsiElement[] psiElementArray2 = new PsiElement[1];
                psiElementArray = psiElementArray2;
                psiElementArray2[0] = target;
            } else {
                psiElementArray = PsiElement.EMPTY_ARRAY;
            }
            return psiElementArray;
        }

        @NotNull
        public Surrounder[] getSurrounders() {
            return this.mySurrounders;
        }

        public boolean isExclusive() {
            return false;
        }

        public String getTemplateDescription() {
            return CodeInsightBundle.message((String)"intention.surround.with.ARM.block.template", (Object[])new Object[0]);
        }

        public boolean isApplicable(@NotNull PsiElement[] elements) {
            return elements.length == 1 && (SurroundAutoCloseableAction.findExpression(elements[0]) != null || SurroundAutoCloseableAction.findVariable(elements[0]) != null);
        }

        @Nullable
        public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement[] elements) {
            if (elements.length == 1) {
                new SurroundAutoCloseableAction().invoke(project, editor, elements[0]);
            }
            return null;
        }
    }

    private static class NamesExpression
    extends Expression {
        private final String[] myNames;

        NamesExpression(String[] names) {
            this.myNames = names;
        }

        public Result calculateResult(ExpressionContext context) {
            return this.calculateQuickResult(context);
        }

        public Result calculateQuickResult(ExpressionContext context) {
            return new TextResult(this.myNames[0]);
        }

        public LookupElement[] calculateLookupItems(ExpressionContext context) {
            return (LookupElement[])Stream.of(this.myNames).map(LookupElementBuilder::create).toArray(LookupElement[]::new);
        }
    }
}

